/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.common.netty;

import com.aizuda.easy.retry.client.common.Lifecycle;
import com.aizuda.easy.retry.client.common.config.EasyRetryProperties;
import com.aizuda.easy.retry.client.common.netty.NettyChannel;
import com.aizuda.easy.retry.client.common.netty.NettyHttpClientHandler;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class NettyHttpConnectClient
implements Lifecycle,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private static NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup();
    private static Bootstrap bootstrap = new Bootstrap();
    private volatile Channel channel;

    @Override
    public void start() {
        try {
            EasyRetryProperties easyRetryProperties = (EasyRetryProperties)this.applicationContext.getBean(EasyRetryProperties.class);
            EasyRetryProperties.ServerConfig server = easyRetryProperties.getServer();
            final NettyHttpConnectClient thisClient = this;
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)nioEventLoopGroup)).channel(NioSocketChannel.class)).remoteAddress(server.getHost(), server.getPort()).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0L, 0L, 30L, TimeUnit.SECONDS)}).addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(0x500000)}).addLast(new ChannelHandler[]{new NettyHttpClientHandler(thisClient)});
                }
            })).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
            this.connect();
        }
        catch (Exception e) {
            EasyRetryLog.LOCAL.error("Client start exception", new Object[]{e});
        }
    }

    public void connect() {
        try {
            ChannelFuture channelFuture = bootstrap.connect();
            boolean notTimeout = channelFuture.awaitUninterruptibly(30L, TimeUnit.SECONDS);
            this.channel = channelFuture.channel();
            if (notTimeout) {
                if (this.channel != null && this.channel.isActive()) {
                    EasyRetryLog.LOCAL.info("netty client started {} connect to server", new Object[]{this.channel.localAddress()});
                    NettyChannel.setChannel(this.getChannel());
                    return;
                }
                Throwable cause = channelFuture.cause();
                if (cause != null) {
                    this.exceptionHandler(cause);
                }
            } else {
                EasyRetryLog.LOCAL.warn("connect remote host[{}] timeout {}s", new Object[]{this.channel.remoteAddress(), 30});
            }
        }
        catch (Exception e) {
            this.exceptionHandler(e);
        }
        this.channel.close();
    }

    public void reconnect() {
        ChannelFuture channelFuture = bootstrap.connect();
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            Throwable cause = future.cause();
            if (cause != null) {
                this.exceptionHandler(cause);
            } else {
                this.channel = channelFuture.channel();
                if (this.channel != null && this.channel.isActive()) {
                    EasyRetryLog.LOCAL.info("Netty client {} reconnect to server", new Object[]{this.channel.localAddress()});
                    NettyChannel.setChannel(this.getChannel());
                }
            }
        }));
    }

    private void exceptionHandler(Throwable cause) {
        if (cause instanceof ConnectException) {
            EasyRetryLog.LOCAL.error("connect error:{}", new Object[]{cause.getMessage()});
        } else if (cause instanceof ClosedChannelException) {
            EasyRetryLog.LOCAL.error("connect error:{}", new Object[]{"client has destroy"});
        } else {
            EasyRetryLog.LOCAL.error("connect error:", new Object[]{cause});
        }
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
        if (nioEventLoopGroup != null) {
            nioEventLoopGroup.shutdownGracefully();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Channel getChannel() {
        return this.channel;
    }
}

