/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.common.cache;

import com.aizuda.easy.retry.client.common.Lifecycle;
import com.aizuda.easy.retry.client.common.NettyClient;
import com.aizuda.easy.retry.client.common.proxy.RequestBuilder;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.model.dto.ConfigDTO;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Order
public class GroupVersionCache
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(GroupVersionCache.class);
    public static ConfigDTO configDTO;

    public static Integer getVersion() {
        if (Objects.isNull(configDTO)) {
            return 0;
        }
        return configDTO.getVersion();
    }

    public static long getDdl(String sceneName) {
        if (Objects.isNull(configDTO)) {
            return 60000L;
        }
        List sceneList = configDTO.getSceneList();
        if (CollectionUtils.isEmpty((Collection)sceneList)) {
            return 60000L;
        }
        for (ConfigDTO.Scene scene : sceneList) {
            if (!scene.getSceneName().equals(sceneName)) continue;
            return scene.getDdl();
        }
        return 60000L;
    }

    public static Set<String> getSceneBlacklist() {
        if (Objects.isNull(configDTO)) {
            return new HashSet<String>();
        }
        return configDTO.getSceneBlacklist();
    }

    public static ConfigDTO.Notify getNotifyAttribute(Integer notifyScene) {
        List notifyList = configDTO.getNotifyList();
        for (ConfigDTO.Notify notify : notifyList) {
            if (!notify.getNotifyScene().equals(notifyScene)) continue;
            return notify;
        }
        return null;
    }

    @Override
    public void start() {
        try {
            NettyClient client = RequestBuilder.newBuilder().client(NettyClient.class).callback(nettyResult -> {
                if (Objects.isNull(nettyResult.getData())) {
                    EasyRetryLog.LOCAL.error("\u83b7\u53d6\u914d\u7f6e\u7ed3\u679c\u4e3anull", new Object[0]);
                    return;
                }
                configDTO = (ConfigDTO)JsonUtil.parseObject((String)nettyResult.getData().toString(), ConfigDTO.class);
            }).build();
            client.getConfig(0);
        }
        catch (Exception e) {
            EasyRetryLog.LOCAL.error("\u540c\u6b65\u7248\u672c\u5931\u8d25", new Object[]{e});
        }
    }

    @Override
    public void close() {
    }
}

