/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.common.appender;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.aizuda.easy.retry.client.common.report.AsyncReportLog;
import com.aizuda.easy.retry.client.common.util.ThreadLocalLogUtil;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.log.dto.LogContentDTO;
import java.util.Objects;
import org.slf4j.MDC;

public class EasyRetryLogbackAppender<E>
extends UnsynchronizedAppenderBase<E> {
    public void start() {
        super.start();
    }

    protected void append(E eventObject) {
        if (!(eventObject instanceof LoggingEvent) || Objects.isNull(ThreadLocalLogUtil.getContext()) || Objects.isNull(MDC.get((String)"remote"))) {
            return;
        }
        MDC.remove((String)"remote");
        LogContentDTO logContentDTO = new LogContentDTO();
        ((LoggingEvent)eventObject).prepareForDeferredProcessing();
        LoggingEvent event = (LoggingEvent)eventObject;
        logContentDTO.addTimeStamp(Long.valueOf(event.getTimeStamp()));
        logContentDTO.addLevelField(event.getLevel().levelStr);
        logContentDTO.addThreadField(event.getThreadName());
        logContentDTO.addMessageField(event.getFormattedMessage());
        logContentDTO.addLocationField(this.getLocationField(event));
        logContentDTO.addThrowableField(this.getThrowableField(event));
        ((AsyncReportLog)SpringContext.getBeanByType(AsyncReportLog.class)).syncReportLog(logContentDTO);
    }

    private String getThrowableField(LoggingEvent event) {
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null) {
            Object throwable = this.getExceptionInfo(iThrowableProxy);
            throwable = (String)throwable + this.formatThrowable(event.getThrowableProxy().getStackTraceElementProxyArray());
            return throwable;
        }
        return null;
    }

    private String getLocationField(LoggingEvent event) {
        StackTraceElement[] caller = event.getCallerData();
        if (caller != null && caller.length > 0) {
            return caller[0].toString();
        }
        return null;
    }

    private String formatThrowable(StackTraceElementProxy[] stackTraceElementProxyArray) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElementProxy step : stackTraceElementProxyArray) {
            builder.append(CoreConstants.LINE_SEPARATOR);
            String string = step.toString();
            builder.append('\t').append(string);
            ThrowableProxyUtil.subjoinPackagingData((StringBuilder)builder, (StackTraceElementProxy)step);
        }
        return builder.toString();
    }

    private String getExceptionInfo(IThrowableProxy iThrowableProxy) {
        String s = iThrowableProxy.getClassName();
        String message = iThrowableProxy.getMessage();
        return message != null ? s + ": " + message : s;
    }
}

