/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncBatch;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchNodeList;
import com.aerospike.client.policy.BatchPolicy;

public abstract class AsyncBatchExecutor
implements BatchNodeList.IBatchStatus {
    final EventLoop eventLoop;
    final Cluster cluster;
    private AerospikeException exception;
    private AsyncBatch.AsyncBatchCommand[] commands;
    private int completedCount;
    private final boolean hasResultCode;
    boolean done;
    boolean error;

    public AsyncBatchExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, boolean hasResultCode) {
        this.eventLoop = eventLoop;
        this.cluster = cluster;
        this.hasResultCode = hasResultCode;
    }

    public void execute(AsyncBatch.AsyncBatchCommand[] cmds) {
        this.commands = cmds;
        for (AsyncBatch.AsyncBatchCommand cmd : cmds) {
            this.eventLoop.execute(this.cluster, cmd);
        }
    }

    public void executeBatchRetry(AsyncBatch.AsyncBatchCommand[] cmds, AsyncBatch.AsyncBatchCommand orig, Runnable other, long deadline) {
        AsyncBatch.AsyncBatchCommand[] target = new AsyncBatch.AsyncBatchCommand[this.commands.length + cmds.length - 1];
        int count = 0;
        for (AsyncBatch.AsyncBatchCommand cmd : this.commands) {
            if (cmd == orig) continue;
            target[count++] = cmd;
        }
        for (AsyncBatch.AsyncBatchCommand cmd : cmds) {
            target[count++] = cmd;
        }
        this.commands = target;
        for (AsyncBatch.AsyncBatchCommand cmd : cmds) {
            this.eventLoop.executeBatchRetry(other, cmd, deadline);
        }
    }

    final void childSuccess() {
        if (++this.completedCount == this.commands.length && !this.done) {
            this.done = true;
            if (this.exception == null) {
                this.onSuccess();
            } else {
                this.onFailure(this.exception);
            }
        }
    }

    final void childFailure(AerospikeException ae) {
        if (this.exception == null) {
            this.exception = ae;
        }
        this.childSuccess();
    }

    @Override
    public void setInvalidNode(Key key, int index2, AerospikeException ae, boolean inDoubt, boolean hasWrite) {
    }

    @Override
    public void setInvalidNode(AerospikeException e) {
        this.error = true;
        if (!this.hasResultCode && this.exception == null) {
            this.exception = e;
        }
    }

    public void setRowError() {
        this.error = true;
    }

    public boolean getStatus() {
        return !this.error;
    }

    abstract void onSuccess();

    abstract void onFailure(AerospikeException var1);
}

