/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.policy.WritePolicy;
import java.io.IOException;

public final class WriteCommand
extends SyncCommand {
    private final WritePolicy writePolicy;
    private final Key key;
    private final Partition partition;
    private final Bin[] bins;
    private final Operation.Type operation;

    public WriteCommand(Cluster cluster, WritePolicy writePolicy, Key key, Bin[] bins, Operation.Type operation) {
        super(cluster, writePolicy);
        this.writePolicy = writePolicy;
        this.key = key;
        this.partition = Partition.write(cluster, writePolicy, key);
        this.bins = bins;
        this.operation = operation;
    }

    @Override
    protected boolean isWrite() {
        return true;
    }

    @Override
    protected Node getNode() {
        return this.partition.getNodeWrite(this.cluster);
    }

    @Override
    protected void writeBuffer() {
        this.setWrite(this.writePolicy, this.operation, this.key, this.bins);
    }

    @Override
    protected void parseResult(Connection conn) throws IOException {
        conn.readFully(this.dataBuffer, 30, (byte)2);
        conn.updateLastUsed();
        int resultCode = this.dataBuffer[13] & 0xFF;
        if (resultCode == 0) {
            return;
        }
        if (resultCode == 27) {
            if (this.writePolicy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            return;
        }
        throw new AerospikeException(resultCode);
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryWrite(timeout);
        return true;
    }
}

