/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.OperateArgs;
import com.aerospike.client.command.ReadCommand;
import com.aerospike.client.policy.Policy;
import java.util.ArrayList;
import java.util.Map;

public final class OperateCommand
extends ReadCommand {
    private final OperateArgs args;

    public OperateCommand(Cluster cluster, Key key, OperateArgs args) {
        super(cluster, (Policy)args.writePolicy, key, args.partition);
        this.args = args;
    }

    @Override
    protected boolean isWrite() {
        return this.args.hasWrite;
    }

    @Override
    protected Node getNode() {
        return this.args.hasWrite ? this.partition.getNodeWrite(this.cluster) : this.partition.getNodeRead(this.cluster);
    }

    @Override
    protected void writeBuffer() {
        this.setOperate(this.args.writePolicy, this.key, this.args);
    }

    @Override
    protected void handleNotFound(int resultCode) {
        if (this.args.hasWrite) {
            throw new AerospikeException(resultCode);
        }
    }

    @Override
    protected void addBin(Map<String, Object> bins, String name, Object value) {
        if (bins.containsKey(name)) {
            Object prev = bins.get(name);
            if (prev instanceof OpResults) {
                OpResults list = (OpResults)prev;
                list.add(value);
            } else {
                OpResults list = new OpResults();
                list.add(prev);
                list.add(value);
                bins.put(name, list);
            }
        } else {
            bins.put(name, value);
        }
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        if (this.args.hasWrite) {
            this.partition.prepareRetryWrite(timeout);
        } else {
            this.partition.prepareRetryRead(timeout);
        }
        return true;
    }

    private static class OpResults
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        private OpResults() {
        }
    }
}

