/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.EventLoops;
import com.aerospike.client.async.EventPolicy;
import com.aerospike.client.async.NettyEventLoop;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.util.Util;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.concurrent.EventExecutor;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;

public final class NettyEventLoops
implements EventLoops,
CipherSuiteFilter {
    private final Map<EventExecutor, NettyEventLoop> eventLoopMap;
    private final NettyEventLoop[] eventLoopArray;
    private final EventLoopGroup group;
    TlsPolicy tlsPolicy;
    SslContext sslContext;
    private int eventIter;
    final boolean isEpoll;

    public NettyEventLoops(EventLoopGroup group) {
        this(new EventPolicy(), group);
    }

    public NettyEventLoops(EventPolicy policy, EventLoopGroup group) {
        if (policy.minTimeout < 5) {
            throw new AerospikeException("Invalid minTimeout " + policy.minTimeout + ". Must be at least 5ms.");
        }
        this.group = group;
        this.isEpoll = group instanceof EpollEventLoopGroup;
        ArrayList<NettyEventLoop> list = new ArrayList<NettyEventLoop>();
        Iterator iter = group.iterator();
        int count = 0;
        while (iter.hasNext()) {
            EventExecutor eventExecutor = (EventExecutor)iter.next();
            list.add(new NettyEventLoop(policy, (EventLoop)eventExecutor, this, count++));
        }
        this.eventLoopArray = list.toArray(new NettyEventLoop[count]);
        this.eventLoopMap = new IdentityHashMap<EventExecutor, NettyEventLoop>(count);
        for (NettyEventLoop eventLoop : this.eventLoopArray) {
            this.eventLoopMap.put((EventExecutor)eventLoop.eventLoop, eventLoop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initTlsContext(TlsPolicy policy) {
        if (this.tlsPolicy != null) {
            return;
        }
        this.tlsPolicy = policy;
        if (policy.context != null) {
            this.sslContext = policy.ciphers == null ? new JdkSslContext(policy.context, true, ClientAuth.NONE) : new JdkSslContext(policy.context, true, null, (CipherSuiteFilter)this, null, ClientAuth.NONE);
            return;
        }
        try {
            String keyStoreLocation;
            SslContextBuilder builder = SslContextBuilder.forClient();
            if (policy.protocols != null) {
                builder.protocols(policy.protocols);
            }
            if (policy.ciphers != null) {
                builder.ciphers(Arrays.asList(policy.ciphers));
            }
            if ((keyStoreLocation = System.getProperty("javax.net.ssl.keyStore")) != null) {
                String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
                char[] pass = keyStorePassword != null ? keyStorePassword.toCharArray() : null;
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                try (FileInputStream is = new FileInputStream(keyStoreLocation);){
                    ks.load(is, pass);
                }
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, pass);
                builder.keyManager(kmf);
            }
            this.sslContext = builder.build();
        }
        catch (Exception e) {
            throw new AerospikeException("Failed to init netty TLS: " + Util.getErrorMessage(e));
        }
    }

    public String[] filterCipherSuites(Iterable<String> ciphers, List<String> defaultCiphers, Set<String> supportedCiphers) {
        if (this.tlsPolicy.ciphers != null) {
            return this.tlsPolicy.ciphers;
        }
        return this.tlsPolicy.context.getSupportedSSLParameters().getCipherSuites();
    }

    public NettyEventLoop get(EventExecutor eventExecutor) {
        return this.eventLoopMap.get(eventExecutor);
    }

    public NettyEventLoop[] getArray() {
        return this.eventLoopArray;
    }

    @Override
    public int getSize() {
        return this.eventLoopArray.length;
    }

    @Override
    public NettyEventLoop get(int index2) {
        return this.eventLoopArray[index2];
    }

    @Override
    public NettyEventLoop next() {
        int iter = this.eventIter++;
        if ((iter %= this.eventLoopArray.length) < 0) {
            iter += this.eventLoopArray.length;
        }
        return this.eventLoopArray[iter];
    }

    @Override
    public void close() {
        this.group.shutdownGracefully();
    }
}

