/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.listener.InfoListener;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.policy.Policy;
import java.util.Map;

public final class AsyncInfoCommand
extends AsyncCommand {
    private final InfoListener listener;
    private final Node node;
    private final String[] commands;
    private Map<String, String> map;

    public AsyncInfoCommand(InfoListener listener, InfoPolicy policy, Node node, String ... commands) {
        super(AsyncInfoCommand.createPolicy(policy), true);
        this.listener = listener;
        this.node = node;
        this.commands = commands;
    }

    private static Policy createPolicy(InfoPolicy policy) {
        Policy p = new Policy();
        if (policy == null) {
            p.setTimeout(1000);
        } else {
            p.setTimeout(policy.timeout);
        }
        return p;
    }

    @Override
    boolean isWrite() {
        return true;
    }

    @Override
    Node getNode(Cluster cluster) {
        return this.node;
    }

    @Override
    protected void writeBuffer() {
        this.dataOffset = 8;
        for (String command : this.commands) {
            this.dataOffset += Buffer.estimateSizeUtf8(command) + 1;
        }
        this.sizeBuffer();
        this.dataOffset = 8;
        for (String command : this.commands) {
            this.dataOffset += Buffer.stringToUtf8(command, this.dataBuffer, this.dataOffset);
            this.dataBuffer[this.dataOffset++] = 10;
        }
        long size = (long)this.dataOffset - 8L | 0x200000000000000L | 0x1000000000000L;
        Buffer.longToBytes(size, this.dataBuffer, 0);
    }

    @Override
    protected final boolean parseResult() {
        Info info = new Info(this.dataBuffer, this.receiveSize);
        this.map = info.parseMultiResponse();
        return true;
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        return true;
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.map);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

