/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.common.service.dal.routing.router;

import com.xiaomi.common.service.dal.routing.Router;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.BadSqlGrammarException;

public class XmHashRouter
implements Router {
    protected static final Log logger = LogFactory.getLog(XmHashRouter.class);
    protected String column;
    protected String pattern;
    protected int count;

    public XmHashRouter(String column, String pattern, int count) {
        this.column = column;
        this.pattern = pattern;
        this.count = count;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public String doRoute(Object columnValue) {
        if (this.pattern != null && columnValue != null) {
            long longValue = this.convert(columnValue);
            int value = (int)(longValue % 100L / 10L);
            String name = MessageFormat.format(this.pattern, value);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Routing on [" + this.column + " = " + columnValue + ", " + columnValue.getClass() + "]: " + name));
            }
            return name;
        }
        return null;
    }

    protected long convert(Object columnValue) {
        if (columnValue instanceof Number) {
            return ((Number)columnValue).longValue();
        }
        try {
            return Long.parseLong(String.valueOf(columnValue));
        }
        catch (NumberFormatException e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Column '" + this.column + "' must be number, but: " + columnValue));
            }
            throw new BadSqlGrammarException("HashRouter.convert", "Column '" + this.column + "' must be number, but: " + columnValue, null);
        }
    }
}

