/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.common.service.dal.routing.router;

import com.xiaomi.common.service.dal.routing.Router;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.BadSqlGrammarException;

public class RangeRouter
implements Router {
    protected static final Log logger = LogFactory.getLog(RangeRouter.class);
    private static final Pattern PATTERN = Pattern.compile("\\{([^\\{\\}]+)\\}");
    protected String column;
    protected String pattern;

    public RangeRouter(String column, String pattern) {
        this.column = column;
        this.pattern = pattern;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String doRoute(Object columnValue) {
        if (this.pattern != null && columnValue != null) {
            Date timeValue = this.convert(columnValue);
            String name = RangeRouter.format(this.pattern, timeValue);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Routing on [" + this.column + " = " + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(timeValue) + ", " + columnValue.getClass() + "]: " + name));
            }
            return name;
        }
        return null;
    }

    private Date convert(Object columnValue) {
        if (columnValue instanceof Date) {
            return (Date)columnValue;
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse(String.valueOf(columnValue));
        }
        catch (ParseException e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Column '" + this.column + "' must be date/time, but: " + columnValue));
            }
            throw new BadSqlGrammarException("RangeRouter.convert", "Column '" + this.column + "' must be date/time, but: " + columnValue, null);
        }
    }

    private static String format(String pattern, Date timeValue) {
        Matcher matcher = PATTERN.matcher(pattern);
        if (matcher.find()) {
            StringBuilder builder = new StringBuilder(pattern.length());
            int index = 0;
            do {
                SimpleDateFormat format = new SimpleDateFormat(matcher.group(1).trim());
                builder.append(pattern.substring(index, matcher.start()));
                builder.append(format.format(timeValue));
                index = matcher.end();
            } while (matcher.find());
            builder.append(pattern.substring(index));
            return builder.toString();
        }
        return pattern;
    }

    public static void main(String ... args) {
        System.out.println(RangeRouter.format("log_{yyyy}", new Date()));
        System.out.println(RangeRouter.format("log_{yyyy_MM}", new Date()));
        System.out.println(RangeRouter.format("log_{yyyy_ww}", new Date()));
        System.out.println(RangeRouter.format("log_{yyyy_MM_dd}", new Date()));
    }
}

