/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.common.service.dal.routing.router;

import com.xiaomi.common.service.dal.routing.router.HashRouter;

public class HexHashRouter
extends HashRouter {
    public HexHashRouter(String column, String pattern, int count) {
        super(column, pattern, count);
    }

    @Override
    protected long convert(Object columnValue) {
        if (this.count > 256) {
            throw new IllegalArgumentException("[Hex hash] Partitions must less than 256");
        }
        String stringValue = String.valueOf(columnValue);
        int length = stringValue.length();
        if (length < 2) {
            throw new IllegalArgumentException("[Hex hash] Column '" + this.column + "' must have more than 2 characters");
        }
        try {
            return Long.parseLong(stringValue.substring(length - 2), 16);
        }
        catch (NumberFormatException e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("[Hex hash] Column '" + this.column + "' must be hex number, but: " + columnValue));
            }
            throw new IllegalArgumentException("Column '" + this.column + "' must be hex number, but: " + columnValue);
        }
    }
}

