/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.common.service.dal.routing.router;

import com.xiaomi.common.service.dal.routing.Router;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectRouter
implements Router {
    protected static final Log logger = LogFactory.getLog(DirectRouter.class);
    protected String column;
    protected String pattern;

    public DirectRouter(String column, String pattern) {
        this.column = column;
        this.pattern = pattern;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String doRoute(Object columnValue) {
        if (this.pattern != null) {
            String name = MessageFormat.format(this.pattern, columnValue);
            if (logger.isDebugEnabled()) {
                if (columnValue != null) {
                    logger.debug((Object)("Routing on [" + this.column + " = " + columnValue + ", " + columnValue.getClass() + "]: " + name));
                } else {
                    logger.debug((Object)("Routing to: " + name));
                }
            }
            return name;
        }
        return null;
    }
}

