/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.common.service.dal.routing;

public class SqlTokenizer {
    protected final String sql;
    protected final int length;
    protected int offset = 0;
    protected boolean unwrapBracket;
    protected boolean wantedComparison;
    protected boolean wantedOperator;
    protected boolean wantedBracket;
    protected boolean wantedComma;
    private static final char COMMA = ',';
    private static final char QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char LEFT_BRACKET = '(';
    private static final char RIGHT_BRACKET = ')';

    public SqlTokenizer(String sql) {
        this.sql = sql;
        this.length = sql.length();
    }

    public SqlTokenizer(String sql, int offset) {
        this.sql = sql;
        this.length = sql.length();
    }

    public void setUnwrapBracket(boolean unwrapBracket) {
        this.unwrapBracket = unwrapBracket;
    }

    public void setWantedComparison(boolean wantedComparison) {
        this.wantedComparison = wantedComparison;
    }

    public void setWantedOperator(boolean wantedOperator) {
        this.wantedOperator = wantedOperator;
    }

    public void setWantedBracket(boolean wantedBracket) {
        this.wantedBracket = wantedBracket;
    }

    public void setWantedComma(boolean wantedComma) {
        this.wantedComma = wantedComma;
    }

    public String getSql() {
        return this.sql;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean moreTokens() {
        while (this.offset < this.length) {
            char ch = this.sql.charAt(this.offset);
            if (!(Character.isWhitespace(ch) || !this.wantedComma && ch == ',' || !this.wantedOperator && SqlTokenizer.isOperator(ch) || !this.wantedComparison && SqlTokenizer.isComparison(ch) || this.unwrapBracket && !this.wantedBracket && ch == '(' || !this.wantedBracket && ch == ')')) {
                return true;
            }
            ++this.offset;
        }
        return false;
    }

    public String nextToken() {
        int begin = this.offset;
        while (this.offset < this.length) {
            char ch = this.sql.charAt(this.offset);
            if (Character.isWhitespace(ch)) {
                if (begin < this.offset) {
                    return this.sql.substring(begin, this.offset);
                }
                this.moreTokens();
                begin = ++this.offset;
                continue;
            }
            if (SqlTokenizer.isOperator(ch)) {
                if (begin < this.offset) {
                    return this.sql.substring(begin, this.offset);
                }
                if (this.wantedOperator) {
                    ++this.offset;
                    return String.valueOf(ch);
                }
                this.moreTokens();
                begin = ++this.offset;
                continue;
            }
            if (SqlTokenizer.isComparison(ch)) {
                if (begin < this.offset) {
                    return this.sql.substring(begin, this.offset);
                }
                if (this.wantedComparison) {
                    ++this.offset;
                    this.nextComparison();
                    return this.sql.substring(begin, this.offset);
                }
                this.moreTokens();
                begin = ++this.offset;
                continue;
            }
            if (ch == '(') {
                if (begin < this.offset) {
                    return this.sql.substring(begin, this.offset);
                }
                if (!this.unwrapBracket) {
                    ++this.offset;
                    this.nextBracket('(', ')');
                    return this.sql.substring(begin, this.offset);
                }
                if (this.wantedBracket) {
                    ++this.offset;
                    return String.valueOf(ch);
                }
                this.moreTokens();
                begin = ++this.offset;
                continue;
            }
            if (ch == ')') {
                if (begin < this.offset) {
                    return this.sql.substring(begin, this.offset);
                }
                if (this.wantedBracket) {
                    ++this.offset;
                    return String.valueOf(ch);
                }
                this.moreTokens();
                begin = ++this.offset;
                continue;
            }
            if (ch == ',') {
                if (begin < this.offset) {
                    return this.sql.substring(begin, this.offset);
                }
                if (this.wantedComma) {
                    ++this.offset;
                    return String.valueOf(ch);
                }
                this.moreTokens();
                begin = ++this.offset;
                continue;
            }
            if (ch == '\'') {
                if (begin < this.offset) {
                    return this.sql.substring(begin, this.offset);
                }
                ++this.offset;
                this.nextQuote('\'');
                return this.sql.substring(begin, this.offset);
            }
            if (ch == '\"') {
                if (begin < this.offset) {
                    return this.sql.substring(begin, this.offset);
                }
                ++this.offset;
                this.nextQuote('\"');
                return this.sql.substring(begin, this.offset);
            }
            ++this.offset;
        }
        if (begin < this.offset) {
            return this.sql.substring(begin, this.offset);
        }
        return null;
    }

    public boolean findToken(String keyword) {
        while (this.moreTokens()) {
            String token = this.nextToken();
            if (!keyword.equalsIgnoreCase(token)) continue;
            return true;
        }
        return false;
    }

    protected void nextQuote(char quoteChar) {
        while (this.offset < this.length) {
            char ch = this.sql.charAt(this.offset);
            if (ch == '\\') {
                ++this.offset;
            } else if (ch == quoteChar) {
                ++this.offset;
                break;
            }
            ++this.offset;
        }
    }

    protected void nextBracket(char bracketLeft, char bracketRight) {
        int nesting = 0;
        while (this.offset < this.length) {
            char ch = this.sql.charAt(this.offset);
            if (ch == '\'') {
                ++this.offset;
                this.nextQuote('\'');
                continue;
            }
            if (ch == '\"') {
                ++this.offset;
                this.nextQuote('\"');
                continue;
            }
            if (ch == bracketLeft) {
                ++nesting;
            } else if (ch == bracketRight) {
                if (nesting == 0) {
                    ++this.offset;
                    break;
                }
                --nesting;
            }
            ++this.offset;
        }
    }

    protected void nextComparison() {
        char ch;
        while (this.offset < this.length && SqlTokenizer.isComparison(ch = this.sql.charAt(this.offset))) {
            ++this.offset;
        }
    }

    private static boolean isOperator(char ch) {
        return ch == '.' || ch == '+' || ch == '-' || ch == '*' || ch == '/';
    }

    private static boolean isComparison(char ch) {
        return ch == '<' || ch == '>' || ch == '=';
    }
}

