/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.common.service.dal.routing;

import com.xiaomi.common.service.dal.routing.SqlTokenizer;

public class SqlRewriter {
    public static String rewriteSqlTable(String sql, String oldName, String newName) {
        SqlTokenizer tokenizer = new SqlTokenizer(sql);
        tokenizer.setWantedComma(true);
        String first = tokenizer.nextToken();
        if ("SELECT".equalsIgnoreCase(first)) {
            return SqlRewriter.rewriteSelectTable(tokenizer, oldName, newName);
        }
        if ("UPDATE".equalsIgnoreCase(first)) {
            return SqlRewriter.rewriteUpdateTable(tokenizer, oldName, newName);
        }
        if ("INSERT".equalsIgnoreCase(first) || "REPLACE".equalsIgnoreCase(first)) {
            return SqlRewriter.rewriteInsertTable(tokenizer, oldName, newName);
        }
        if ("DELETE".equalsIgnoreCase(first)) {
            return SqlRewriter.rewriteDeleteTable(tokenizer, oldName, newName);
        }
        return sql;
    }

    private static String rewriteInsertTable(SqlTokenizer tokenizer, String oldName, String newName) {
        String token;
        int begin;
        String sql = tokenizer.getSql();
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (tokenizer.moreTokens()) {
            begin = tokenizer.getOffset();
            token = tokenizer.nextToken();
            if ("INTO".equalsIgnoreCase(token)) continue;
            if (token.charAt(0) == '(' || "VALUES".equalsIgnoreCase(token)) break;
            if (!token.equals(oldName)) continue;
            builder.append(sql.substring(index, begin));
            builder.append(newName);
            index = tokenizer.getOffset();
        }
        if (tokenizer.findToken("FROM")) {
            while (tokenizer.moreTokens()) {
                begin = tokenizer.getOffset();
                token = tokenizer.nextToken();
                if (token.equalsIgnoreCase("WHERE")) break;
                if (!token.equals(oldName)) continue;
                int end = tokenizer.getOffset();
                boolean usingAlias = false;
                if (tokenizer.moreTokens()) {
                    token = tokenizer.nextToken();
                    if (!(",".equals(token) || "WHERE".equalsIgnoreCase(token) || "JOIN".equalsIgnoreCase(token) || "LEFT".equalsIgnoreCase(token) || "RIGHT".equalsIgnoreCase(token) || "INNER".equalsIgnoreCase(token))) {
                        usingAlias = true;
                    }
                    while (!",".equals(token) && !"WHERE".equalsIgnoreCase(token)) {
                        token = tokenizer.nextToken();
                        if (tokenizer.moreTokens()) continue;
                    }
                }
                builder.append(sql.substring(index, begin));
                builder.append(newName);
                if (!usingAlias) {
                    builder.append(' ');
                    builder.append(oldName);
                }
                index = end;
            }
        }
        if (index < sql.length()) {
            builder.append(sql.substring(index, sql.length()));
        }
        return builder.toString();
    }

    private static String rewriteUpdateTable(SqlTokenizer tokenizer, String oldName, String newName) {
        String sql = tokenizer.getSql();
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (tokenizer.moreTokens()) {
            int begin = tokenizer.getOffset();
            String token = tokenizer.nextToken();
            if ("SET".equalsIgnoreCase(token)) break;
            if (!token.equals(oldName)) continue;
            int end = tokenizer.getOffset();
            boolean usingAlias = false;
            if (tokenizer.moreTokens()) {
                token = tokenizer.nextToken();
                if (!(",".equals(token) || "SET".equalsIgnoreCase(token) || "JOIN".equalsIgnoreCase(token) || "LEFT".equalsIgnoreCase(token) || "RIGHT".equalsIgnoreCase(token) || "INNER".equalsIgnoreCase(token))) {
                    usingAlias = true;
                }
                while (!",".equals(token) && !"SET".equalsIgnoreCase(token)) {
                    token = tokenizer.nextToken();
                    if (tokenizer.moreTokens()) continue;
                }
            }
            builder.append(sql.substring(index, begin));
            builder.append(newName);
            if (!usingAlias) {
                builder.append(' ');
                builder.append(oldName);
            }
            index = end;
        }
        if (index < sql.length()) {
            builder.append(sql.substring(index, sql.length()));
        }
        return builder.toString();
    }

    private static String rewriteSelectTable(SqlTokenizer tokenizer, String oldName, String newName) {
        String sql = tokenizer.getSql();
        if (tokenizer.findToken("FROM")) {
            StringBuilder builder = new StringBuilder();
            int index = 0;
            while (tokenizer.moreTokens()) {
                int begin = tokenizer.getOffset();
                String token = tokenizer.nextToken();
                if (token.equalsIgnoreCase("WHERE")) break;
                if (!token.equals(oldName)) continue;
                int end = tokenizer.getOffset();
                boolean usingAlias = false;
                if (tokenizer.moreTokens()) {
                    token = tokenizer.nextToken();
                    if (!(",".equals(token) || "WHERE".equalsIgnoreCase(token) || "JOIN".equalsIgnoreCase(token) || "LEFT".equalsIgnoreCase(token) || "RIGHT".equalsIgnoreCase(token) || "INNER".equalsIgnoreCase(token))) {
                        usingAlias = true;
                    }
                    while (!",".equals(token) && !"WHERE".equalsIgnoreCase(token)) {
                        token = tokenizer.nextToken();
                        if (tokenizer.moreTokens()) continue;
                    }
                }
                builder.append(sql.substring(index, begin));
                builder.append(newName);
                if (!usingAlias) {
                    builder.append(' ');
                    builder.append(oldName);
                }
                index = end;
            }
            if (index < sql.length()) {
                builder.append(sql.substring(index, sql.length()));
            }
            return builder.toString();
        }
        return sql;
    }

    private static String rewriteDeleteTable(SqlTokenizer tokenizer, String oldName, String newName) {
        String sql = tokenizer.getSql();
        if (tokenizer.findToken("FROM")) {
            StringBuilder builder = new StringBuilder();
            int index = 0;
            while (tokenizer.moreTokens()) {
                int begin = tokenizer.getOffset();
                String token = tokenizer.nextToken();
                if (token.equalsIgnoreCase("WHERE")) break;
                if (!token.equals(oldName)) continue;
                builder.append(sql.substring(index, begin));
                builder.append(newName);
                index = tokenizer.getOffset();
            }
            if (index < sql.length()) {
                builder.append(sql.substring(index, sql.length()));
            }
            return builder.toString();
        }
        return sql;
    }
}

