/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.common.service.dal.routing;

import com.meidusa.amoeba.mysql.parser.sql.MysqlParser;
import com.meidusa.amoeba.parser.ParseException;
import com.meidusa.amoeba.parser.dbobject.Column;
import com.meidusa.amoeba.parser.dbobject.Table;
import com.meidusa.amoeba.parser.expression.BaseExpressionList;
import com.meidusa.amoeba.parser.expression.ColumnExpression;
import com.meidusa.amoeba.parser.expression.ComparisonExpression;
import com.meidusa.amoeba.parser.expression.ConstantExpression;
import com.meidusa.amoeba.parser.expression.Expression;
import com.meidusa.amoeba.parser.expression.FunctionExpression;
import com.meidusa.amoeba.parser.expression.ParameterExpression;
import com.meidusa.amoeba.parser.function.Function;
import com.meidusa.amoeba.parser.function.UnknowableFunction;
import com.meidusa.amoeba.parser.statement.DMLStatement;
import com.meidusa.amoeba.parser.statement.DeleteStatement;
import com.meidusa.amoeba.parser.statement.InsertStatement;
import com.meidusa.amoeba.parser.statement.SelectStatement;
import com.meidusa.amoeba.parser.statement.Statement;
import com.meidusa.amoeba.parser.statement.UpdateStatement;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQLParseInfo {
    protected static final Log logger = LogFactory.getLog(SQLParseInfo.class);
    protected static Pattern LIMIT_PATTERN = Pattern.compile("\\s+LIMIT\\s+(\\d+|\\?)(?:,\\s*(\\d+|\\?))?\\s*$", 2);
    protected static Map<String, Function> functionMap = new HashMap<String, Function>();
    protected static LRUMap cacheInfo;
    protected final String sql;
    protected boolean dml;
    protected boolean select;
    protected boolean insert;
    protected boolean update;
    protected boolean delete;
    protected Table[] tables;
    protected HashMap<Column, Object> namedParams = new HashMap();
    protected ArrayList<Column> indexParams = new ArrayList();
    protected int paramOffset = 0;
    protected int paramCount = 0;
    protected boolean parsingFailed = false;
    protected boolean inited = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLParseInfo getParseInfo(String sql) {
        SQLParseInfo info;
        LRUMap lRUMap = cacheInfo;
        synchronized (lRUMap) {
            info = (SQLParseInfo)cacheInfo.get((Object)sql);
            if (info == null) {
                info = new SQLParseInfo(sql);
                cacheInfo.put((Object)sql, (Object)info);
            }
        }
        info.parseInfoIfNecessary();
        return info;
    }

    public SQLParseInfo(String sql) {
        this.sql = sql;
    }

    public String getSQL() {
        return this.sql;
    }

    public boolean isInited() {
        return this.inited;
    }

    public boolean isParsingFailed() {
        return this.parsingFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseInfoIfNecessary() {
        if (this.inited) {
            return;
        }
        SQLParseInfo sQLParseInfo = this;
        synchronized (sQLParseInfo) {
            if (this.inited) {
                return;
            }
            this.parseInfo();
            this.inited = true;
        }
    }

    private void parseInfo() {
        Statement stmt;
        block8: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("First parsing SQL: " + this.sql));
            }
            String parseSql = this.sql;
            Matcher matcher = LIMIT_PATTERN.matcher(this.sql);
            if (matcher.find()) {
                parseSql = this.sql.substring(0, matcher.start());
                if ("?".equals(matcher.group(1))) {
                    ++this.paramCount;
                }
                if ("?".equals(matcher.group(2))) {
                    ++this.paramCount;
                }
            }
            MysqlParser parser = new MysqlParser((Reader)new StringReader(parseSql));
            parser.setFunctionMap(functionMap);
            stmt = null;
            try {
                stmt = parser.doParse();
            }
            catch (ParseException e) {
                this.parsingFailed = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Parsing SQL failed: " + this.sql), (Throwable)e);
                }
                if (!logger.isWarnEnabled()) break block8;
                logger.warn((Object)("Parsing SQL failed: " + this.sql));
            }
        }
        this.dml = stmt instanceof DMLStatement;
        if (this.dml) {
            this.select = stmt instanceof SelectStatement;
            this.insert = stmt instanceof InsertStatement;
            this.update = stmt instanceof UpdateStatement;
            this.delete = stmt instanceof DeleteStatement;
            DMLStatement dmlStmt = (DMLStatement)stmt;
            this.tables = dmlStmt.getTables();
            this.parseExpr(dmlStmt.getExpression(), null);
            this.paramOffset = this.indexParams.size() - stmt.getParameterCount() - 1;
            this.paramCount += stmt.getParameterCount();
        }
    }

    public boolean isDML() {
        return this.dml;
    }

    public boolean isSelect() {
        return this.select;
    }

    public boolean isInsert() {
        return this.insert;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public boolean isUnswitch() {
        return this.select && 0 == this.tables.length;
    }

    public Table[] getTables() {
        return this.tables;
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public Column getColumn(int paramIndex) {
        int size = this.indexParams.size();
        int index = this.paramOffset + paramIndex;
        if (index < 0 || index >= size) {
            return null;
        }
        return this.indexParams.get(index);
    }

    public int getColumnIndex(Column column) {
        int index = this.indexParams.indexOf(column);
        if (index >= 0) {
            return index - this.paramOffset;
        }
        return -1;
    }

    public boolean containsParam(Column column) {
        return this.namedParams.containsKey(column);
    }

    public Object getParam(Column column) {
        return this.namedParams.get(column);
    }

    public static Map<String, Function> getFunctionMap() {
        return functionMap;
    }

    public static Table newTable(String tableName) {
        Table table = new Table();
        table.setName(tableName);
        return table;
    }

    public static Table newTable(String tableName, String aliasName) {
        Table table = new Table();
        table.setName(tableName);
        table.setAlias(aliasName);
        return table;
    }

    public static Column newColumn(String composeName) {
        int index = composeName.indexOf(46);
        if (index >= 0) {
            return SQLParseInfo.newColumn(composeName.substring(0, index), composeName.substring(index + 1));
        }
        return SQLParseInfo.newColumn((Table)null, composeName);
    }

    public static Column newColumn(String tableName, String columnName) {
        Column column = new Column();
        column.setTable(SQLParseInfo.newTable(tableName));
        column.setName(columnName.toUpperCase());
        return column;
    }

    public static Column newColumn(Table table, String columnName) {
        Column column = new Column();
        column.setTable(table);
        column.setName(columnName.toUpperCase());
        return column;
    }

    protected void parseExpr(Expression expr, Column column) {
        block3: {
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                if (!(expr instanceof BaseExpressionList)) break block2;
                                BaseExpressionList exprList = (BaseExpressionList)expr;
                                List list = exprList.getAllExpression();
                                for (Expression exp : list) {
                                    this.parseExpr(exp, null);
                                }
                                break block3;
                            }
                            if (!(expr instanceof ColumnExpression)) break block4;
                            ColumnExpression columnExpr = (ColumnExpression)expr;
                            column = columnExpr.getColumn();
                            this.parseExpr(columnExpr.getExpression(), column);
                            break block3;
                        }
                        if (!(expr instanceof ComparisonExpression)) break block5;
                        ComparisonExpression compExpr = (ComparisonExpression)expr;
                        this.parseExpr(compExpr.getExpression(), column);
                        break block3;
                    }
                    if (!(expr instanceof ParameterExpression)) break block6;
                    this.indexParams.add(column);
                    this.namedParams.put(column, null);
                    break block3;
                }
                if (!(expr instanceof ConstantExpression)) break block7;
                this.namedParams.put(column, expr.evaluate(null));
                break block3;
            }
            if (!(expr instanceof FunctionExpression)) break block3;
            FunctionExpression funcExpr = (FunctionExpression)expr;
            List list = funcExpr.getArgList();
            for (Expression exp : list) {
                this.parseExpr(exp, null);
            }
        }
    }

    public static void main(String ... args) throws IOException {
        Matcher matcher = LIMIT_PATTERN.matcher("SELECT * FROM dual LIMIT ?, ?");
        if (matcher.find()) {
            System.out.println(matcher.group(1));
            System.out.println(matcher.group(2));
        }
    }

    static {
        functionMap.put("MOD", (Function)new UnknowableFunction());
        functionMap.put("CONCAT", (Function)new UnknowableFunction());
        functionMap.put("CONCAT_WS", (Function)new UnknowableFunction());
        functionMap.put("NOW", (Function)new UnknowableFunction());
        functionMap.put("SYSDATE", (Function)new UnknowableFunction());
        functionMap.put("CURRENT_TIMESTAMP", (Function)new UnknowableFunction());
        functionMap.put("CURRENT_DATE", (Function)new UnknowableFunction());
        functionMap.put("ADDDATE", (Function)new UnknowableFunction());
        functionMap.put("ASCII", (Function)new UnknowableFunction());
        functionMap.put("NEXTVAL", (Function)new UnknowableFunction());
        functionMap.put("INSERT", (Function)new UnknowableFunction());
        functionMap.put("INSTR", (Function)new UnknowableFunction());
        functionMap.put("SUBSTRING", (Function)new UnknowableFunction());
        functionMap.put("DATABASE", (Function)new UnknowableFunction());
        functionMap.put("LAST_INSERT_ID", (Function)new UnknowableFunction());
        cacheInfo = new LRUMap(1024);
    }
}

