/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.common.service.dal.routing;

import com.xiaomi.common.service.dal.routing.Router;
import com.xiaomi.common.service.dal.routing.RoutingDescriptor;
import com.xiaomi.common.service.dal.routing.RoutingDescriptorImpl;
import com.xiaomi.common.service.dal.routing.router.DirectRouter;
import com.xiaomi.common.service.dal.routing.router.HashRouter;
import com.xiaomi.common.service.dal.routing.router.HexHashRouter;
import com.xiaomi.common.service.dal.routing.router.RangeRouter;
import com.xiaomi.common.service.dal.routing.router.RoundRouter;
import com.xiaomi.common.service.dal.routing.router.XmHashRouter;
import com.xiaomi.common.service.dal.routing.router.XmStringHashRouter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RoutingConfigurator {
    static Log logger = LogFactory.getLog(RoutingConfigurator.class);
    protected ConcurrentHashMap<String, RoutingDescriptor> map = new ConcurrentHashMap();
    private List<String> partitions;
    protected ReadWriteLock rwLock = new ReentrantReadWriteLock();
    boolean inited = false;
    public static final String DIRECT = "direct";
    public static final String ROUND = "round";
    public static final String RANGE = "range";
    public static final String HASH = "hash";
    public static final String XM_HASH = "xm-hash";
    public static final String XM_STRING_HASH = "xm-str-hash";
    public static final String HEX_HASH = "hex-hash";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutingDescriptor getDescriptor(String name) {
        if (!this.inited) {
            this.initPartitions();
        }
        String keyword = name;
        Lock lock = this.rwLock.readLock();
        try {
            RoutingDescriptor descriptor;
            lock.lock();
            RoutingDescriptor routingDescriptor = descriptor = this.map.get(keyword);
            return routingDescriptor;
        }
        finally {
            lock.unlock();
        }
    }

    private void initPartitions() {
        List<String> partitions = this.getPartitions();
        for (int i = 0; i < partitions.size(); ++i) {
            String[] conf = partitions.get(i).split(":");
            this.map.put(conf[1], new RoutingDescriptorImpl().setPartitionRouter(this.createRouter(conf)));
        }
        this.inited = true;
    }

    public void setPartitions(List<String> partitions) {
        this.partitions = partitions;
    }

    public List<String> getPartitions() {
        return this.partitions;
    }

    private Router createRouter(String[] conf) {
        if (HASH.equalsIgnoreCase(conf[0])) {
            RouterFactory factory = new RouterFactory(HASH){

                @Override
                public Router onCreateRouter(String column, String pattern, int partitions) {
                    return new HashRouter(column, pattern, partitions);
                }
            };
            return factory.setColumn(conf[2]).setPattern(conf[3]).setPartition(conf[4]).createRouter();
        }
        if (RANGE.equalsIgnoreCase(conf[0])) {
            RouterFactory factory = new RouterFactory(RANGE){

                @Override
                public Router onCreateRouter(String column, String pattern, int partitions) {
                    return new RangeRouter(column, pattern);
                }
            };
            return factory.setColumn(conf[2]).setPattern(conf[3]).createRouter();
        }
        if (DIRECT.equalsIgnoreCase(conf[0])) {
            RouterFactory factory = new RouterFactory(DIRECT){

                @Override
                public Router onCreateRouter(String column, String pattern, int partitions) {
                    return new DirectRouter(column, pattern);
                }
            };
            return factory.setColumn(conf[2]).setPattern(conf[3]).createRouter();
        }
        if (ROUND.equalsIgnoreCase(conf[0])) {
            RouterFactory factory = new RouterFactory(ROUND){

                @Override
                public Router onCreateRouter(String column, String pattern, int partitions) {
                    return new RoundRouter(pattern, partitions);
                }
            };
            return factory.setPattern(conf[3]).setPartition(conf[4]).createRouter();
        }
        if (HEX_HASH.equalsIgnoreCase(conf[0])) {
            RouterFactory factory = new RouterFactory(HEX_HASH){

                @Override
                public Router onCreateRouter(String column, String pattern, int partitions) {
                    return new HexHashRouter(column, pattern, partitions);
                }
            };
            return factory.setColumn(conf[2]).setPattern(conf[3]).setPartition(conf[4]).createRouter();
        }
        if (XM_HASH.equalsIgnoreCase(conf[0])) {
            RouterFactory factory = new RouterFactory(XM_HASH){

                @Override
                public Router onCreateRouter(String column, String pattern, int partitions) {
                    return new XmHashRouter(column, pattern, partitions);
                }
            };
            return factory.setColumn(conf[2]).setPattern(conf[3]).setPartition(conf[4]).createRouter();
        }
        if (XM_STRING_HASH.equalsIgnoreCase(conf[0])) {
            RouterFactory factory = new RouterFactory(XM_STRING_HASH){

                @Override
                public Router onCreateRouter(String column, String pattern, int partitions) {
                    return new XmStringHashRouter(column, pattern, partitions);
                }
            };
            return factory.setColumn(conf[2]).setPattern(conf[3]).setPartition(conf[4]).createRouter();
        }
        return null;
    }

    private static abstract class RouterFactory {
        private String name;
        private Map<String, String> values = new HashMap<String, String>();
        public static final String KEY_COLUMN = "by-column";
        public static final String KEY_PATTERN = "target-pattern";
        public static final String KEY_PARTITION = "partitions";

        public RouterFactory(String name) {
            this.name = name;
        }

        public RouterFactory add(String key, String value) {
            this.values.put(key, value);
            return this;
        }

        public RouterFactory setColumn(String column) {
            return this.add(KEY_COLUMN, column);
        }

        public RouterFactory setPattern(String pattern) {
            return this.add(KEY_PATTERN, pattern);
        }

        public RouterFactory setPartition(String partition) {
            return this.add(KEY_PARTITION, partition);
        }

        public Router createRouter() {
            for (Map.Entry<String, String> entry : this.values.entrySet()) {
                if (entry.getValue() != null) continue;
                if (logger.isErrorEnabled()) {
                    logger.error((Object)String.format("Router '%s' must have '%s' property.", this.name, entry.getKey()));
                }
                return null;
            }
            String column = this.values.get(KEY_COLUMN);
            String pattern = this.values.get(KEY_PATTERN);
            String partition = this.values.get(KEY_PARTITION);
            int count = 0;
            if (partition != null) {
                try {
                    count = NumberUtils.toInt((String)partition.trim());
                }
                catch (NumberFormatException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)String.format("Router '%s' property '%s' must be number.", this.name, KEY_PARTITION));
                    }
                    return null;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Creating router '%s' [ %s ]", this.name, this.values));
            }
            return this.onCreateRouter(column, pattern, count);
        }

        public abstract Router onCreateRouter(String var1, String var2, int var3);
    }
}

