/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.common.service.dal.routing;

import com.meidusa.amoeba.parser.dbobject.Column;
import com.meidusa.amoeba.parser.dbobject.Table;
import com.xiaomi.common.service.dal.routing.Router;
import com.xiaomi.common.service.dal.routing.RoutingConfigurator;
import com.xiaomi.common.service.dal.routing.RoutingDescriptor;
import com.xiaomi.common.service.dal.routing.SQLParseInfo;
import com.xiaomi.common.service.dal.routing.SqlRewriter;
import java.util.Map;
import net.paoding.rose.jade.statement.Interpreter;
import net.paoding.rose.jade.statement.StatementRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.BadSqlGrammarException;

@Order(value=9000)
public class RewriteSQLInterpreter
implements Interpreter {
    private static final Log logger = LogFactory.getLog(RewriteSQLInterpreter.class);
    private RoutingConfigurator routingConfigurator;

    public void interpret(StatementRuntime runtime) {
        String sqlRewrited;
        if (runtime.getMetaData().getShardByIndex() < 0) {
            return;
        }
        String sql = runtime.getSQL();
        SQLParseInfo parseInfo = SQLParseInfo.getParseInfo(sql);
        Table[] tables = parseInfo.getTables();
        RoutingInfo routingInfo = null;
        if (tables != null) {
            int beginIndex = 0;
            if (parseInfo.isInsert() && tables.length > 1) {
                beginIndex = 1;
            }
            for (int i = beginIndex; i < tables.length; ++i) {
                RoutingDescriptor descriptor = this.routingConfigurator.getDescriptor(tables[i].getName());
                if (descriptor == null) continue;
                routingInfo = new RoutingInfo(tables[i], descriptor);
                break;
            }
        }
        if (routingInfo == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Find routing info: " + routingInfo.byTable + ", " + routingInfo.getDbRouterColumn()));
        }
        String forwardTableName = null;
        if (routingInfo.getTableRouter() != null) {
            Column column = routingInfo.getTableRouterColumn();
            Object columnValue = null;
            if (column != null && (columnValue = RewriteSQLInterpreter.findShardParamValue(runtime, column)) == null) {
                throw new BadSqlGrammarException("sharding", parseInfo.getSQL(), null);
            }
            forwardTableName = routingInfo.getTableRouter().doRoute(columnValue);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("table router is null for sql \"" + sql + "\""));
        }
        String byTableName = routingInfo.byTable.getName();
        if (forwardTableName != null && !forwardTableName.equals(byTableName)) {
            sqlRewrited = SqlRewriter.rewriteSqlTable(sql, byTableName, forwardTableName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Rewriting SQL: \n  From: " + sql + "\n  To:   " + sqlRewrited));
            }
        } else {
            sqlRewrited = sql;
        }
        runtime.setSQL(sqlRewrited);
    }

    protected static Object findShardParamValue(StatementRuntime runtime, Column column) {
        if (runtime.getMetaData().getShardByIndex() < 0) {
            throw new BadSqlGrammarException("interpreter.findShardParamValue@ShardByIndex < 0", "SQL [" + runtime.getSQL() + "] shardByIndex: " + runtime.getMetaData().getShardByIndex(), null);
        }
        Object value = null;
        int sqlIndex = runtime.getMetaData().getShardByIndex() + 1;
        Map parameters = runtime.getParameters();
        value = parameters.get(":" + sqlIndex);
        if (value == null) {
            throw new BadSqlGrammarException("interpreter.findShardParamValue@ShardParam", "SQL [" + runtime.getSQL() + "] Query without shard parameter: " + runtime.getParameters().toString(), null);
        }
        return value;
    }

    public RoutingConfigurator getRoutingConfigurator() {
        return this.routingConfigurator;
    }

    public void setRoutingConfigurator(RoutingConfigurator routingConfigurator) {
        this.routingConfigurator = routingConfigurator;
    }

    class RoutingInfo {
        private Table byTable;
        private RoutingDescriptor descriptor;
        private Column dbRouterColumn;
        private Column tableRouterColumn;

        public RoutingInfo(Table table, RoutingDescriptor descriptor) {
            this.byTable = table;
            this.descriptor = descriptor;
        }

        public Router getDbRouter() {
            return this.descriptor.getDbRouter();
        }

        public Router getTableRouter() {
            return this.descriptor.getTableRouter();
        }

        public Column getDbRouterColumn() {
            if (this.dbRouterColumn != null) {
                return this.dbRouterColumn;
            }
            Router dbRouter = this.getDbRouter();
            if (dbRouter == null) {
                return null;
            }
            String columnName = dbRouter.getColumn();
            if (columnName != null) {
                Column columnForDBPartition = new Column();
                columnForDBPartition.setName(columnName.toUpperCase());
                columnForDBPartition.setTable(this.byTable);
                this.dbRouterColumn = columnForDBPartition;
            }
            return this.dbRouterColumn;
        }

        public Column getTableRouterColumn() {
            if (this.tableRouterColumn != null) {
                return this.tableRouterColumn;
            }
            Router tableRouter = this.getTableRouter();
            if (tableRouter == null) {
                return null;
            }
            String columnName = tableRouter.getColumn();
            if (columnName != null) {
                Column tableRouterColumn = new Column();
                tableRouterColumn.setName(columnName.toUpperCase());
                tableRouterColumn.setTable(this.byTable);
                this.tableRouterColumn = tableRouterColumn;
            }
            return this.tableRouterColumn;
        }
    }
}

