/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.util;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    public static final int TIMESTAMP = 1;
    public static final int DATE = 2;
    public static final int TIME = 3;

    public static Date parseDateTime(String original, int type) throws SQLException {
        String s = original;
        if (s == null) {
            return null;
        }
        try {
            long time;
            int timeStart = 0;
            TimeZone tz = null;
            if (type == 3) {
                timeStart = 0;
            } else {
                timeStart = s.indexOf(32) + 1;
                if (timeStart <= 0) {
                    timeStart = s.indexOf(84) + 1;
                }
            }
            int year = 1970;
            int month = 1;
            int day = 1;
            if (type != 3) {
                if (s.startsWith("+")) {
                    s = s.substring(1);
                }
                int s1 = s.indexOf(45, 1);
                int s2 = s.indexOf(45, s1 + 1);
                if (s1 <= 0 || s2 <= s1) {
                    throw new SQLException("error format:" + s + " must format yyyy-mm-dd");
                }
                year = Integer.parseInt(s.substring(0, s1));
                month = Integer.parseInt(s.substring(s1 + 1, s2));
                int end = timeStart == 0 ? s.length() : timeStart - 1;
                day = Integer.parseInt(s.substring(s2 + 1, end));
            }
            int hour = 0;
            int minute = 0;
            int second = 0;
            int nano = 0;
            if (type != 2) {
                int s1 = s.indexOf(58, timeStart);
                int s2 = s.indexOf(58, s1 + 1);
                int s3 = s.indexOf(46, s2 + 1);
                if (s1 <= 0 || s2 <= s1) {
                    throw new SQLException("error format:" + s + " must format hh:mm:ss");
                }
                if (s.endsWith("Z")) {
                    s = s.substring(0, s.length() - 1);
                    tz = TimeZone.getTimeZone("UTC");
                } else {
                    int timeZoneStart = s.indexOf(43, s2 + 1);
                    if (timeZoneStart < 0) {
                        timeZoneStart = s.indexOf(45, s2 + 1);
                    }
                    if (timeZoneStart >= 0) {
                        String tzName = "GMT" + s.substring(timeZoneStart);
                        tz = TimeZone.getTimeZone(tzName);
                        if (!tz.getID().equals(tzName)) {
                            throw new SQLException("time zone name error :" + tz.getID() + " <>" + tzName);
                        }
                        s = s.substring(0, timeZoneStart).trim();
                    }
                }
                hour = Integer.parseInt(s.substring(timeStart, s1));
                minute = Integer.parseInt(s.substring(s1 + 1, s2));
                if (s3 < 0) {
                    second = Integer.parseInt(s.substring(s2 + 1));
                } else {
                    second = Integer.parseInt(s.substring(s2 + 1, s3));
                    String n = (s + "000000000").substring(s3 + 1, s3 + 10);
                    nano = Integer.parseInt(n);
                }
            }
            if (hour < 0 || hour > 23) {
                throw new IllegalArgumentException("hour: " + hour);
            }
            try {
                time = TimeUtil.getTime(false, tz, year, month, day, hour, minute, second, type != 1, nano);
            }
            catch (IllegalArgumentException e) {
                if (e.toString().indexOf("HOUR_OF_DAY") > 0) {
                    time = TimeUtil.getTime(true, tz, year, month, day, hour, minute, second, type != 1, nano);
                }
                throw e;
            }
            switch (type) {
                case 2: {
                    return new java.sql.Date(time);
                }
                case 3: {
                    return new Time(time);
                }
                case 1: {
                    Timestamp ts = new Timestamp(time);
                    ts.setNanos(nano);
                    return ts;
                }
            }
            throw new SQLException("error type:" + type);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("IllegalArgumentException");
        }
    }

    private static long getTime(boolean lenient, TimeZone tz, int year, int month, int day, int hour, int minute, int second, boolean setMillis, int nano) {
        Calendar c = tz == null ? Calendar.getInstance() : Calendar.getInstance(tz);
        c.setLenient(lenient);
        if (year <= 0) {
            c.set(0, 0);
            c.set(1, 1 - year);
        } else {
            c.set(1, year);
        }
        c.set(2, month - 1);
        c.set(5, day);
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        if (setMillis) {
            c.set(14, nano / 1000000);
        }
        return c.getTime().getTime();
    }

    public static void main(String[] args) {
        try {
            System.out.println(TimeUtil.parseDateTime("1998-02-03 22:23:00", 3));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

