/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.util;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Random;

public class StringUtil {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final char[] c = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm', 'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'Z', 'X', 'C', 'V', 'B', 'N', 'M'};

    public static String getRandomString(int size) {
        Random random = new Random();
        StringBuffer sb = new StringBuffer(size);
        for (int i = 0; i < size; ++i) {
            sb.append(c[Math.abs(random.nextInt()) % c.length]);
        }
        return sb.toString();
    }

    public static String safeToString(Object object) {
        try {
            return object.toString();
        }
        catch (Throwable t) {
            return "<toString() failure: " + t + ">";
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String intervalToString(long millis) {
        StringBuilder buf = new StringBuilder();
        boolean started = false;
        long days = millis / 86400000L;
        if (days != 0L) {
            buf.append(days).append("d ");
            started = true;
        }
        long hours = millis / 3600000L % 24L;
        if (started || hours != 0L) {
            buf.append(hours).append("h ");
        }
        long minutes = millis / 60000L % 60L;
        if (started || minutes != 0L) {
            buf.append(minutes).append("m ");
        }
        long seconds = millis / 1000L % 60L;
        if (started || seconds != 0L) {
            buf.append(seconds).append("s ");
        }
        buf.append(millis % 1000L).append("ms");
        return buf.toString();
    }

    public static final String dumpAsHex(byte[] byteBuffer, int length) {
        int i;
        StringBuffer outputBuf = new StringBuffer(length * 4);
        int p = 0;
        int rows = length / 8;
        for (int i2 = 0; i2 < rows && p < length; ++i2) {
            int j;
            int ptemp = p;
            for (j = 0; j < 8; ++j) {
                String hexVal = Integer.toHexString(byteBuffer[ptemp] & 0xFF);
                if (hexVal.length() == 1) {
                    hexVal = "0" + hexVal;
                }
                outputBuf.append(hexVal + " ");
                ++ptemp;
            }
            outputBuf.append("    ");
            for (j = 0; j < 8; ++j) {
                int b = 0xFF & byteBuffer[p];
                if (b > 32 && b < 127) {
                    outputBuf.append((char)b + " ");
                } else {
                    outputBuf.append(". ");
                }
                ++p;
            }
            outputBuf.append("\n");
        }
        int n = 0;
        for (i = p; i < length; ++i) {
            String hexVal = Integer.toHexString(byteBuffer[i] & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            outputBuf.append(hexVal + " ");
            ++n;
        }
        for (i = n; i < 8; ++i) {
            outputBuf.append("   ");
        }
        outputBuf.append("    ");
        for (i = p; i < length; ++i) {
            int b = 0xFF & byteBuffer[i];
            if (b > 32 && b < 127) {
                outputBuf.append((char)b + " ");
                continue;
            }
            outputBuf.append(". ");
        }
        outputBuf.append("\n");
        return outputBuf.toString();
    }

    public static byte[] escapeEasternUnicodeByteStream(byte[] origBytes, String origString, int offset, int length) {
        if (origBytes == null || origBytes.length == 0) {
            return origBytes;
        }
        int bytesLen = origBytes.length;
        int bufIndex = 0;
        int strIndex = 0;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(bytesLen);
        while (true) {
            if (origString.charAt(strIndex) == '\\') {
                bytesOut.write(origBytes[bufIndex++]);
            } else {
                int hiByte;
                int loByte = origBytes[bufIndex];
                if (loByte < 0) {
                    loByte += 256;
                }
                bytesOut.write(loByte);
                if (loByte >= 128) {
                    if (bufIndex < bytesLen - 1) {
                        hiByte = origBytes[bufIndex + 1];
                        if (hiByte < 0) {
                            hiByte += 256;
                        }
                        bytesOut.write(hiByte);
                        ++bufIndex;
                        if (hiByte == 92) {
                            bytesOut.write(hiByte);
                        }
                    }
                } else if (loByte == 92 && bufIndex < bytesLen - 1) {
                    hiByte = origBytes[bufIndex + 1];
                    if (hiByte < 0) {
                        hiByte += 256;
                    }
                    if (hiByte == 98) {
                        bytesOut.write(92);
                        bytesOut.write(98);
                        ++bufIndex;
                    }
                }
                ++bufIndex;
            }
            if (bufIndex >= bytesLen) break;
            ++strIndex;
        }
        return bytesOut.toByteArray();
    }

    public static String toString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (byte byt : bytes) {
            buffer.append((char)byt);
        }
        return buffer.toString();
    }

    public static String toString(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "[]";
        }
        StringBuffer buffer = new StringBuffer("[");
        for (int i = 0; i < objs.length; ++i) {
            buffer.append(String.valueOf(objs[i]));
            if (i == objs.length - 1) continue;
            buffer.append(",");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static String[] split(String str) {
        return StringUtil.split(str, null, -1);
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < length) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String str, String separatorChars) {
        return StringUtil.split(str, separatorChars, -1);
    }

    public static String[] split(String str, String separatorChars, int max) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        if (separatorChars == null) {
            while (i < length) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = length;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < length) {
                if (str.charAt(i) == sep) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = length;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else {
            while (i < length) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = length;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String replaceOnce(String text, String repl, String with) {
        return StringUtil.replace(text, repl, with, 1);
    }

    public static String replace(String text, String repl, String with) {
        return StringUtil.replace(text, repl, with, -1);
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null || repl == null || with == null || repl.length() == 0 || max == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String replaceChars(String str, char searchChar, char replaceChar) {
        if (str == null) {
            return null;
        }
        return str.replace(searchChar, replaceChar);
    }

    public static String replaceChars(String str, String searchChars, String replaceChars) {
        if (str == null || str.length() == 0 || searchChars == null || searchChars.length() == 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        boolean modified = false;
        int isize = searchChars.length();
        for (int i = 0; i < isize; ++i) {
            char searchChar = searchChars.charAt(i);
            if (replaceChars == null || i >= replaceChars.length()) {
                int pos = 0;
                for (int j = 0; j < len; ++j) {
                    if (chars[j] != searchChar) {
                        chars[pos++] = chars[j];
                        continue;
                    }
                    modified = true;
                }
                len = pos;
                continue;
            }
            for (int j = 0; j < len; ++j) {
                if (chars[j] != searchChar) continue;
                chars[j] = replaceChars.charAt(i);
                modified = true;
            }
        }
        if (!modified) {
            return str;
        }
        return new String(chars, 0, len);
    }
}

