/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.util;

public class Queue<T> {
    protected static final int MIN_SHRINK_SIZE = 1024;
    protected T[] _items;
    protected int _count = 0;
    protected int _start = 0;
    protected int _end = 0;
    protected int _suggestedSize;
    protected int _size = 0;

    public Queue(int suggestedSize) {
        this._size = this._suggestedSize = suggestedSize;
        this._items = this.newArray(this._size);
    }

    public Queue() {
        this(4);
    }

    public synchronized void clear() {
        this._end = 0;
        this._start = 0;
        this._count = 0;
        this._size = this._suggestedSize;
        this._items = this.newArray(this._size);
    }

    public synchronized boolean hasElements() {
        return this._count != 0;
    }

    public synchronized int size() {
        return this._count;
    }

    public synchronized void prepend(T item) {
        if (this._count == this._size) {
            this.makeMoreRoom();
        }
        this._start = this._start == 0 ? this._size - 1 : --this._start;
        this._items[this._start] = item;
        ++this._count;
        if (this._count == 1) {
            this.notify();
        }
    }

    public synchronized void append(T item) {
        this.append0(item, this._count == 0);
    }

    public synchronized void appendSilent(T item) {
        this.append0(item, false);
    }

    public synchronized void appendLoud(T item) {
        this.append0(item, true);
    }

    protected void append0(T item, boolean notify) {
        if (this._count == this._size) {
            this.makeMoreRoom();
        }
        this._items[this._end] = item;
        this._end = (this._end + 1) % this._size;
        ++this._count;
        if (notify) {
            this.notify();
        }
    }

    public synchronized T getNonBlocking() {
        if (this._count == 0) {
            return null;
        }
        T retval = this._items[this._start];
        this._items[this._start] = null;
        this._start = (this._start + 1) % this._size;
        --this._count;
        return retval;
    }

    public synchronized void waitForItem() {
        while (this._count == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized T get(long maxwait) {
        if (this._count == 0) {
            try {
                this.wait(maxwait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this._count == 0) {
                return null;
            }
        }
        return this.get();
    }

    public synchronized T get() {
        while (this._count == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        T retval = this._items[this._start];
        this._items[this._start] = null;
        this._start = (this._start + 1) % this._size;
        --this._count;
        if (this._size > 1024 && this._size > this._suggestedSize && this._count < this._size >> 3) {
            this.shrink();
        }
        return retval;
    }

    private void makeMoreRoom() {
        T[] items = this.newArray(this._size * 2);
        System.arraycopy(this._items, this._start, items, 0, this._size - this._start);
        System.arraycopy(this._items, 0, items, this._size - this._start, this._end);
        this._start = 0;
        this._end = this._size;
        this._size *= 2;
        this._items = items;
    }

    private void shrink() {
        T[] items = this.newArray(this._size / 2);
        if (this._start > this._end) {
            System.arraycopy(this._items, this._start, items, 0, this._size - this._start);
            System.arraycopy(this._items, 0, items, this._size - this._start, this._end + 1);
        } else {
            System.arraycopy(this._items, this._start, items, 0, this._end - this._start + 1);
        }
        this._size /= 2;
        this._start = 0;
        this._end = this._count;
        this._items = items;
    }

    private T[] newArray(int size) {
        return new Object[size];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[count=").append(this._count);
        buf.append(", size=").append(this._size);
        buf.append(", start=").append(this._start);
        buf.append(", end=").append(this._end);
        buf.append(", elements={");
        for (int i = 0; i < this._count; ++i) {
            int pos = (i + this._start) % this._size;
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this._items[pos]);
        }
        return buf.append("}]").toString();
    }
}

