/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.util;

import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.log4j.Logger;

public class MappedByteBufferUtil {
    private static Logger logger = Logger.getLogger(MappedByteBufferUtil.class);
    private static Method GetCleanerMethod;
    private static Method cleanMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmap(final MappedByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        MappedByteBuffer mappedByteBuffer = buffer;
        synchronized (mappedByteBuffer) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Object cleaner = GetCleanerMethod.invoke((Object)buffer, new Object[0]);
                        cleanMethod.invoke(cleaner, new Object[0]);
                    }
                    catch (Exception e) {
                        logger.error((Object)"unmap  MappedByteBuffer error", (Throwable)e);
                    }
                    return null;
                }
            });
        }
    }

    static {
        try {
            if (GetCleanerMethod == null) {
                Method getCleanerMethod = Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
                getCleanerMethod.setAccessible(true);
                GetCleanerMethod = getCleanerMethod;
                cleanMethod = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

