/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.util;

import com.meidusa.amoeba.util.Histogram;
import com.meidusa.amoeba.util.LoopingThread;
import com.meidusa.amoeba.util.Queue;
import com.meidusa.amoeba.util.RunQueue;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class Invoker
extends LoopingThread {
    private static Logger log = Logger.getLogger(Invoker.class);
    protected Queue<Unit> _queue = new Queue();
    protected RunQueue _receiver;
    protected HashMap<Object, UnitProfile> _tracker = new HashMap();
    protected int _unitsRun;
    protected long _longThreshold = 500L;
    protected static final boolean PERF_TRACK = true;

    public Invoker(String name, RunQueue resultReceiver) {
        super(name);
        this._receiver = resultReceiver;
    }

    public void setLongThresholds(long longThreshold) {
        this._longThreshold = longThreshold;
    }

    public void postUnit(Unit unit) {
        unit.queueStamp = System.currentTimeMillis();
        this._queue.append(unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterate() {
        Unit unit = this._queue.get();
        long start = System.currentTimeMillis();
        Invoker invoker = this;
        synchronized (invoker) {
            ++this._unitsRun;
        }
        this.recordMetrics("queue_wait_time", start - unit.queueStamp);
        try {
            this.willInvokeUnit(unit, start);
            if (unit.invoke()) {
                this._receiver.postRunnable(unit);
            }
            this.didInvokeUnit(unit, start);
        }
        catch (Throwable t) {
            log.warn((Object)("Invocation unit failed [unit=" + unit + "]."), t);
        }
    }

    @Override
    public void shutdown() {
        this._queue.append(new Unit(){

            @Override
            public boolean invoke() {
                Invoker.this._running = false;
                return false;
            }
        });
    }

    protected void willInvokeUnit(Unit unit, long start) {
    }

    protected void didInvokeUnit(Unit unit, long start) {
        long duration = System.currentTimeMillis() - start;
        Class<?> key = unit.getClass();
        this.recordMetrics(key, duration);
        if (duration > this._longThreshold) {
            String howLong = duration >= 10L * this._longThreshold ? "Really long" : "Long";
            log.warn((Object)(howLong + " invoker unit [unit=" + unit + " (" + key + "), time=" + duration + "ms]."));
        }
    }

    protected void recordMetrics(Object key, long duration) {
        UnitProfile prof = this._tracker.get(key);
        if (prof == null) {
            prof = new UnitProfile();
            this._tracker.put(key, prof);
        }
        prof.record(duration);
    }

    public int size() {
        return this._queue.size();
    }

    protected static class UnitProfile {
        protected Histogram _histo = new Histogram(0, 50, 10);
        protected long _totalElapsed;

        protected UnitProfile() {
        }

        public void record(long duration) {
            this._totalElapsed += duration;
            this._histo.addValue((int)duration);
        }

        public void clear() {
            this._totalElapsed = 0L;
            this._histo.clear();
        }

        public String toString() {
            int count = this._histo.size();
            return this._totalElapsed + "ms/" + count + " = " + this._totalElapsed / (long)count + "ms avg " + Arrays.toString(this._histo.getBuckets());
        }
    }

    public static abstract class Unit
    implements Runnable {
        public long queueStamp;
        protected String _name = "Unknown";

        public Unit() {
        }

        public Unit(String name) {
            this._name = name;
        }

        public abstract boolean invoke();

        public void handleResult() {
        }

        @Override
        public void run() {
            this.handleResult();
        }

        public String toString() {
            return this._name;
        }
    }
}

