/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.util;

import java.util.Arrays;

public class Histogram {
    protected int _minValue;
    protected int _maxValue;
    protected int _bucketWidth;
    protected int _count;
    protected int[] _buckets;

    public Histogram(int minValue, int bucketWidth, int bucketCount) {
        this._minValue = minValue;
        this._maxValue = minValue + bucketWidth * bucketCount;
        this._bucketWidth = bucketWidth;
        this._buckets = new int[bucketCount];
    }

    public void addValue(int value) {
        if (value < this._minValue) {
            this._buckets[0] = this._buckets[0] + 1;
        } else if (value >= this._maxValue) {
            int n = this._buckets.length - 1;
            this._buckets[n] = this._buckets[n] + 1;
        } else {
            int n = (value - this._minValue) / this._bucketWidth;
            this._buckets[n] = this._buckets[n] + 1;
        }
        ++this._count;
    }

    public int size() {
        return this._count;
    }

    public void clear() {
        Arrays.fill(this._buckets, 0);
    }

    public int[] getBuckets() {
        return this._buckets;
    }

    public String summarize() {
        StringBuilder buf = new StringBuilder();
        buf.append(this._count).append(":");
        for (int ii = 0; ii < this._buckets.length; ++ii) {
            if (ii > 0) {
                buf.append(",");
            }
            buf.append(this._buckets[ii]);
        }
        return buf.toString();
    }

    public String toString() {
        return "[min=" + this._minValue + ", max=" + this._maxValue + ", bwidth=" + this._bucketWidth + ", buckets=" + Arrays.toString(this._buckets);
    }
}

