/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.util;

import com.meidusa.amoeba.util.HashFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHash<T> {
    private final HashFunction hashFunction;
    private final SortedMap<Long, T> circle = new TreeMap<Long, T>();
    private final Map<T, Integer> replicas = new HashMap<T, Integer>();

    public ConsistentHash(HashFunction hashFunction) {
        this.hashFunction = hashFunction;
    }

    public void addAll(Collection<Entry<T>> collection) {
        for (Entry<T> entry : collection) {
            this.add(entry.object, entry.replicas);
        }
    }

    public void add(T node, int numberOfReplicas) {
        for (int i = 0; i < numberOfReplicas; ++i) {
            this.circle.put(this.hashFunction.hash(node.toString() + i), node);
        }
        this.replicas.put(node, numberOfReplicas);
    }

    public void remove(T node) {
        Integer numberOfReplicas = this.replicas.get(node);
        if (numberOfReplicas == null) {
            return;
        }
        for (int i = 0; i < numberOfReplicas; ++i) {
            this.circle.remove(this.hashFunction.hash(node.toString() + i));
        }
    }

    public T get(Object key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        long hash = this.hashFunction.hash(key);
        if (!this.circle.containsKey(hash)) {
            SortedMap<Long, T> tailMap = this.circle.tailMap(hash);
            hash = tailMap.isEmpty() ? this.circle.firstKey() : tailMap.firstKey();
        }
        return (T)this.circle.get(hash);
    }

    public static void main(String[] args) {
        ArrayList coll = new ArrayList();
        coll.add(new Entry<String>("asdfqwer"));
        coll.add(new Entry<String>("b"));
        coll.add(new Entry<String>("c"));
        coll.add(new Entry<String>("d"));
        coll.add(new Entry<String>("e"));
        coll.add(new Entry<String>("f"));
        coll.add(new Entry<String>("g"));
        coll.add(new Entry<String>("h"));
        coll.add(new Entry<String>("i"));
        coll.add(new Entry<String>("j"));
        coll.add(new Entry<String>("k"));
        coll.add(new Entry<String>("l"));
        ConsistentHash hash = new ConsistentHash(new HashFunction(){

            @Override
            public long hash(Object string) {
                return string.hashCode() % 1024;
            }
        });
        hash.addAll(coll);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            hash.get(i);
        }
        System.out.println(System.currentTimeMillis() - start);
    }

    public static class Entry<T> {
        T object;
        int replicas;

        Entry() {
        }

        Entry(T obj, int replicas) {
            this.object = obj;
            this.replicas = replicas;
        }

        Entry(T obj) {
            this.object = obj;
            this.replicas = 1;
        }
    }
}

