/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.ASTFunNode;
import com.meidusa.amoeba.sqljep.JepRuntime;
import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.function.OracleNumberFormat;
import com.meidusa.amoeba.sqljep.function.OracleTimestampFormat;
import com.meidusa.amoeba.sqljep.function.PostfixCommand;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;

public class ToChar
extends PostfixCommand {
    static final String PARAM_EXCEPTION = "Format should be string";
    static final String TYPE_EXCEPTION = "Unsupported type";

    @Override
    public final int getNumberOfParameters() {
        return -1;
    }

    @Override
    public Comparable<?>[] evaluate(ASTFunNode node, JepRuntime runtime) throws ParseException {
        node.childrenAccept(runtime.ev, null);
        int num = node.jjtGetNumChildren();
        if (num == 1) {
            Comparable param1 = runtime.stack.pop();
            return new Comparable[]{param1};
        }
        if (num == 2) {
            Comparable param2 = runtime.stack.pop();
            Comparable param1 = runtime.stack.pop();
            return new Comparable[]{param1, param2};
        }
        this.removeParams(runtime.stack, num);
        throw new ParseException("Wrong number of parameters for instr");
    }

    public static String to_char(Comparable<?> param1) {
        String res = param1 == null ? null : (param1 instanceof BigDecimal ? ((BigDecimal)param1).toPlainString() : param1.toString());
        return res;
    }

    public static String to_char(Comparable<?> param1, Comparable<?> param2, Calendar cal, DateFormatSymbols symb) throws ParseException {
        if (param1 == null || param2 == null) {
            return null;
        }
        if (param1 instanceof String && ((String)((Object)param1)).length() == 0) {
            return null;
        }
        if (!(param2 instanceof String)) {
            throw new ParseException(PARAM_EXCEPTION);
        }
        if (param1 instanceof String) {
            return (String)((Object)param1);
        }
        if (param1 instanceof Number) {
            try {
                OracleNumberFormat format = new OracleNumberFormat((String)((Object)param2));
                return format.format((Number)((Object)param1));
            }
            catch (java.text.ParseException e) {
                throw new ParseException(e.getMessage());
            }
        }
        if (param1 instanceof Date) {
            try {
                OracleTimestampFormat format = new OracleTimestampFormat((String)((Object)param2), cal, symb);
                return format.format((Timestamp)param1);
            }
            catch (java.text.ParseException e) {
                throw new ParseException(e.getMessage());
            }
        }
        throw new ParseException(TYPE_EXCEPTION);
    }

    @Override
    public Comparable<?> getResult(Comparable<?> ... comparables) throws ParseException {
        if (comparables.length == 1) {
            return ToChar.to_char(comparables[0]);
        }
        return ToChar.to_char(comparables[0], comparables[1], JepRuntime.getCalendar(), JepRuntime.getDateFormatSymbols());
    }
}

