/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.ASTFunNode;
import com.meidusa.amoeba.sqljep.JepRuntime;
import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.function.Add;
import com.meidusa.amoeba.sqljep.function.PostfixCommand;
import java.math.BigDecimal;
import java.sql.Timestamp;

public final class Subtract
extends PostfixCommand {
    @Override
    public final int getNumberOfParameters() {
        return 2;
    }

    @Override
    public Comparable<?>[] evaluate(ASTFunNode node, JepRuntime runtime) throws ParseException {
        node.childrenAccept(runtime.ev, null);
        Comparable param2 = runtime.stack.pop();
        Comparable param1 = runtime.stack.pop();
        return new Comparable[]{param1, param2};
    }

    public static Comparable<?> sub(Comparable<?> param1, Comparable<?> param2) throws ParseException {
        if (param1 == null || param2 == null) {
            return null;
        }
        if (param1 instanceof String) {
            param1 = Subtract.parse((String)((Object)param1));
        }
        if (param2 instanceof String) {
            param2 = Subtract.parse((String)((Object)param2));
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            long l2;
            long r;
            if (param1 instanceof BigDecimal || param2 instanceof BigDecimal) {
                BigDecimal b1 = Subtract.getBigDecimal((Number)((Object)param1));
                BigDecimal b2 = Subtract.getBigDecimal((Number)((Object)param2));
                return b1.subtract(b2);
            }
            if (param1 instanceof Double || param2 instanceof Double || param1 instanceof Float || param2 instanceof Float) {
                return ((Number)((Object)param1)).doubleValue() - ((Number)((Object)param2)).doubleValue();
            }
            long l1 = ((Number)((Object)param1)).longValue();
            if (l1 >= (r = l1 - (l2 = ((Number)((Object)param2)).longValue()))) {
                return r;
            }
            BigDecimal b1 = new BigDecimal(l1);
            BigDecimal b2 = new BigDecimal(l2);
            return b1.subtract(b2);
        }
        if (param1 instanceof Timestamp || param2 instanceof Timestamp) {
            if (param1 instanceof Timestamp && param2 instanceof Timestamp) {
                Timestamp d1 = (Timestamp)param1;
                Timestamp d2 = (Timestamp)param2;
                BigDecimal d = new BigDecimal(d1.getTime() - d2.getTime());
                return d.divide(Add.DAY_MILIS, 40, 4);
            }
            if (param1 instanceof Timestamp) {
                Timestamp d = (Timestamp)param1;
                if (!(param2 instanceof Number)) {
                    throw new ParseException("Wrong operation");
                }
                Number n = (Number)((Object)param2);
                return new Timestamp(d.getTime() - Add.toDay(n));
            }
            if (param2 instanceof Timestamp) {
                Timestamp d = (Timestamp)param2;
                if (!(param1 instanceof Number)) {
                    throw new ParseException("Wrong operation");
                }
                Number n = (Number)((Object)param1);
                return new Timestamp(d.getTime() - Add.toDay(n));
            }
            throw new ParseException("Internal error");
        }
        throw new ParseException("Wrong type  (" + param1.getClass() + "-" + param2.getClass() + ")");
    }

    @Override
    public Comparable<?> getResult(Comparable<?> ... comparables) throws ParseException {
        return Subtract.sub(comparables[0], comparables[1]);
    }
}

