/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.ASTFunNode;
import com.meidusa.amoeba.sqljep.JepRuntime;
import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.function.PostfixCommand;

public class Substring
extends PostfixCommand {
    private static final String PARAM_EXCEPTION = "BeginIndex and CountChars in substr shoud be integers";

    @Override
    public final int getNumberOfParameters() {
        return -1;
    }

    @Override
    public Comparable<?>[] evaluate(ASTFunNode node, JepRuntime runtime) throws ParseException {
        node.childrenAccept(runtime.ev, null);
        int num = node.jjtGetNumChildren();
        if (num == 2) {
            Comparable param2 = runtime.stack.pop();
            Comparable param1 = runtime.stack.pop();
            return new Comparable[]{param1, param2};
        }
        if (num == 3) {
            Comparable param3 = runtime.stack.pop();
            Comparable param2 = runtime.stack.pop();
            Comparable param1 = runtime.stack.pop();
            return new Comparable[]{param1, param2, param3};
        }
        this.removeParams(runtime.stack, num);
        throw new ParseException("Wrong number of parameters for substr");
    }

    public static String substr(Comparable<?> param1, Comparable<?> param2) throws ParseException {
        if (param1 == null) {
            return null;
        }
        try {
            int beginIndex = Substring.getInteger(param2) - 1;
            return param1.toString().substring(beginIndex);
        }
        catch (ParseException e) {
            throw new ParseException(PARAM_EXCEPTION);
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static String substr(Comparable<?> param1, Comparable<?> param2, Comparable<?> param3) throws ParseException {
        if (param1 == null) {
            return null;
        }
        try {
            int beginIndex = Substring.getInteger(param2) - 1;
            int count = Substring.getInteger(param3);
            String source = param1.toString();
            if (beginIndex < 0) {
                beginIndex += source.length() + 1;
            }
            return source.substring(beginIndex, beginIndex + count);
        }
        catch (ParseException e) {
            throw new ParseException(PARAM_EXCEPTION);
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public Comparable<?> getResult(Comparable<?> ... comparables) throws ParseException {
        if (comparables.length == 2) {
            return Substring.substr(comparables[0], comparables[1]);
        }
        return Substring.substr(comparables[0], comparables[1], comparables[2]);
    }
}

