/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.ASTFunNode;
import com.meidusa.amoeba.sqljep.JepRuntime;
import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.function.PostfixCommand;

public class Rpad
extends PostfixCommand {
    private static final String PARAM_EXCEPTION = "Length in rpad shoud be integer";

    @Override
    public final int getNumberOfParameters() {
        return -1;
    }

    @Override
    public Comparable<?>[] evaluate(ASTFunNode node, JepRuntime runtime) throws ParseException {
        node.childrenAccept(runtime.ev, null);
        int num = node.jjtGetNumChildren();
        if (num == 2) {
            Comparable param2 = runtime.stack.pop();
            Comparable param1 = runtime.stack.pop();
            return new Comparable[]{param1, param2, " "};
        }
        if (num == 3) {
            Comparable param3 = runtime.stack.pop();
            Comparable param2 = runtime.stack.pop();
            Comparable param1 = runtime.stack.pop();
            return new Comparable[]{param1, param2, param3};
        }
        this.removeParams(runtime.stack, num);
        throw new ParseException("Wrong number of parameters for rpad");
    }

    public static String rpad(Comparable<?> param1, Comparable<?> param2, Comparable<?> param3) throws ParseException {
        int length;
        if (param1 == null || param2 == null || param3 == null) {
            return null;
        }
        String inputStr = param1.toString();
        String chars = param3.toString();
        try {
            length = Rpad.getInteger(param2);
        }
        catch (ParseException e) {
            throw new ParseException(PARAM_EXCEPTION);
        }
        if (length == inputStr.length()) {
            return inputStr;
        }
        if (length < inputStr.length()) {
            return inputStr.substring(0, length);
        }
        int count = (length -= inputStr.length()) / chars.length();
        int remainder = length % chars.length();
        StringBuilder output = new StringBuilder();
        output.append(inputStr);
        for (int i = 0; i < count; ++i) {
            output.append(chars);
        }
        output.append(chars.substring(0, remainder));
        return output.toString();
    }

    @Override
    public Comparable<?> getResult(Comparable<?> ... comparables) throws ParseException {
        return Rpad.rpad(comparables[0], comparables[1], comparables[2]);
    }
}

