/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.ASTFunNode;
import com.meidusa.amoeba.sqljep.JepRuntime;
import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.function.PostfixCommand;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class Round
extends PostfixCommand {
    private static final String PARAM_EXCEPTION = "Scale in round shoud be integer";

    @Override
    public final int getNumberOfParameters() {
        return -1;
    }

    @Override
    public Comparable<?>[] evaluate(ASTFunNode node, JepRuntime runtime) throws ParseException {
        node.childrenAccept(runtime.ev, null);
        int num = node.jjtGetNumChildren();
        if (num == 1) {
            Comparable param1 = runtime.stack.pop();
            return new Comparable[]{param1};
        }
        if (num == 2) {
            Comparable param2 = runtime.stack.pop();
            Comparable param1 = runtime.stack.pop();
            return new Comparable[]{param1, param2};
        }
        this.removeParams(runtime.stack, num);
        throw new ParseException("Wrong number of parameters for trunc");
    }

    public static Comparable<?> round(Comparable<?> param, Calendar cal) throws ParseException {
        if (param == null) {
            return null;
        }
        if (param instanceof String) {
            param = Round.parse((String)((Object)param));
        }
        if (param instanceof BigDecimal) {
            BigDecimal b = ((BigDecimal)param).setScale(0, 4);
            try {
                return b.longValueExact();
            }
            catch (ArithmeticException e) {
                return b;
            }
        }
        if (param instanceof Double || param instanceof Float) {
            return Math.round(((Number)((Object)param)).doubleValue());
        }
        if (param instanceof Number) {
            return param;
        }
        if (param instanceof Timestamp) {
            Timestamp ts = (Timestamp)param;
            cal.setTimeInMillis(ts.getTime());
            int year = cal.get(1);
            int month = cal.get(2);
            int date = cal.get(5);
            int hour = cal.get(11);
            cal.clear();
            if (hour > 11) {
                ++date;
            }
            cal.set(year, month, date);
            return new Timestamp(cal.getTimeInMillis());
        }
        throw new ParseException("Wrong type round(" + param.getClass() + ")");
    }

    public static Comparable<?> round(Comparable<?> param1, Comparable<?> param2, Calendar cal) throws ParseException {
        if (param1 == null || param2 == null) {
            return null;
        }
        if (param1 instanceof String) {
            param1 = Round.parse((String)((Object)param1));
        }
        if (param1 instanceof Number) {
            int scale;
            try {
                scale = Round.getInteger(param2);
            }
            catch (ParseException e) {
                throw new ParseException(PARAM_EXCEPTION);
            }
            if (scale < 0) {
                return ZERO;
            }
            if (param1 instanceof BigDecimal) {
                return ((BigDecimal)param1).setScale(scale, 4);
            }
            if (param1 instanceof Double || param1 instanceof Float) {
                double d = ((Number)((Object)param1)).doubleValue();
                long mult = 1L;
                for (int i = 0; i < scale; ++i) {
                    mult *= 10L;
                }
                return Math.round(d *= (double)mult) / mult;
            }
            if (param1 instanceof Number) {
                return param1;
            }
            throw new ParseException("Wrong type round(" + param1.getClass() + "," + param2.getClass() + ")");
        }
        if (param1 instanceof Date && param2 instanceof String) {
            String s = (String)((Object)param2);
            Date d = (Date)param1;
            cal.setTimeInMillis(d.getTime());
            if (s.equalsIgnoreCase("CC") || s.equalsIgnoreCase("SCC")) {
                int year1;
                if (d instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int year = cal.get(1);
                if (year - (year1 = year / 100 * 100) > 50) {
                    year1 += 100;
                }
                cal.clear();
                cal.set(year1 + 1, 0, 1);
                return new Timestamp(cal.getTimeInMillis());
            }
            if (s.equalsIgnoreCase("SYYYY") || s.equalsIgnoreCase("YYYY") || s.equalsIgnoreCase("YYY") || s.equalsIgnoreCase("Y") || s.equalsIgnoreCase("YEAR") || s.equalsIgnoreCase("SYEAR")) {
                if (d instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int year = cal.get(1);
                int month = cal.get(2);
                if (month > 6) {
                    ++year;
                }
                cal.clear();
                cal.set(year, 0, 1);
                return new Timestamp(cal.getTimeInMillis());
            }
            if (s.equalsIgnoreCase("IYYY") || s.equalsIgnoreCase("IY") || s.equalsIgnoreCase("I")) {
                throw new ParseException("Not implimented");
            }
            if (s.equalsIgnoreCase("Q")) {
                int day;
                int q;
                if (d instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int year = cal.get(1);
                int month = cal.get(2);
                if (month > (q = month / 3 * 3) + 1) {
                    ++q;
                } else if (month > q && (day = cal.get(5)) > 15) {
                    ++q;
                }
                cal.clear();
                cal.set(year, q, 1);
                return new Timestamp(cal.getTimeInMillis());
            }
            if (s.equalsIgnoreCase("MONTH") || s.equalsIgnoreCase("MON") || s.equalsIgnoreCase("MM") || s.equalsIgnoreCase("RM")) {
                if (d instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int year = cal.get(1);
                int month = cal.get(2);
                int day = cal.get(5);
                if (day > 15) {
                    ++month;
                }
                cal.clear();
                cal.set(year, month, 1);
                return new Timestamp(cal.getTimeInMillis());
            }
            if (s.equalsIgnoreCase("WW")) {
                int delta;
                if (d instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int year = cal.get(1);
                int month = cal.get(2);
                int day = cal.get(5);
                int dw = cal.get(7);
                cal.clear();
                cal.set(year, 0, 1);
                int dayOfWeek = cal.get(7);
                int n = delta = dw < dayOfWeek ? 7 - (dayOfWeek - dw) : dw - dayOfWeek;
                if (delta > 2) {
                    delta -= 7;
                }
                cal.set(year, month, day - delta);
                return new Timestamp(cal.getTimeInMillis());
            }
            if (s.equalsIgnoreCase("W")) {
                int delta;
                if (d instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int year = cal.get(1);
                int month = cal.get(2);
                int day = cal.get(5);
                int dw = cal.get(7);
                cal.clear();
                cal.set(year, month, 1);
                int dayOfWeek = cal.get(7);
                int n = delta = dw < dayOfWeek ? 7 - (dayOfWeek - dw) : dw - dayOfWeek;
                if (delta > 2) {
                    delta -= 7;
                }
                cal.set(year, month, day - delta);
                return new Timestamp(cal.getTimeInMillis());
            }
            if (s.equalsIgnoreCase("IW")) {
                throw new ParseException("Not implimented");
            }
            if (s.equalsIgnoreCase("DAY") || s.equalsIgnoreCase("DY") || s.equalsIgnoreCase("D")) {
                if (d instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int year = cal.get(1);
                int month = cal.get(2);
                int day = cal.get(5);
                int dw = cal.get(7);
                int delta = dw - cal.getFirstDayOfWeek();
                if (delta > 2) {
                    delta -= 7;
                }
                cal.clear();
                cal.set(year, month, day - delta);
                return new Timestamp(cal.getTimeInMillis());
            }
            if (s.equalsIgnoreCase("HH") || s.equalsIgnoreCase("HH12") || s.equalsIgnoreCase("HH24")) {
                if (d instanceof java.sql.Date) {
                    throw new ParseException("Can't use DATE here");
                }
                int minute = cal.get(12);
                if (minute >= 30) {
                    cal.get(11);
                    cal.add(11, 1);
                }
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                return new Timestamp(cal.getTimeInMillis());
            }
            if (s.equalsIgnoreCase("MI")) {
                if (d instanceof java.sql.Date) {
                    throw new ParseException("Can't use DATE here");
                }
                int second = cal.get(13);
                if (second >= 30) {
                    cal.get(12);
                    cal.add(12, 1);
                }
                cal.set(13, 0);
                cal.set(14, 0);
                return new Timestamp(cal.getTimeInMillis());
            }
            throw new ParseException("Unknown format");
        }
        throw new ParseException("Wrong type trunc(" + param1.getClass() + "," + param2.getClass() + ")");
    }

    @Override
    public Comparable<?> getResult(Comparable<?> ... comparables) throws ParseException {
        if (comparables.length == 1) {
            return Round.round(comparables[0], JepRuntime.getCalendar());
        }
        return Round.round(comparables[0], comparables[2], JepRuntime.getCalendar());
    }
}

