/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.ASTFunNode;
import com.meidusa.amoeba.sqljep.JepRuntime;
import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.function.PostfixCommand;
import java.math.BigDecimal;

public class Power
extends PostfixCommand {
    @Override
    public final int getNumberOfParameters() {
        return 2;
    }

    @Override
    public Comparable<?>[] evaluate(ASTFunNode node, JepRuntime runtime) throws ParseException {
        node.childrenAccept(runtime.ev, null);
        Comparable param2 = runtime.stack.pop();
        Comparable param1 = runtime.stack.pop();
        return new Comparable[]{param1, param2};
    }

    public static Comparable<?> power(Comparable<?> param1, Comparable<?> param2) throws ParseException {
        if (param1 == null || param2 == null) {
            return null;
        }
        if (param1 instanceof String) {
            param1 = Power.parse((String)((Object)param1));
        }
        if (param2 instanceof String) {
            param2 = Power.parse((String)((Object)param2));
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            double d;
            int i = ((Number)((Object)param2)).intValue();
            if ((double)i == (d = ((Number)((Object)param2)).doubleValue())) {
                long l1;
                int p2;
                if (param1 instanceof BigDecimal) {
                    try {
                        return ((BigDecimal)param1).pow(p2);
                    }
                    catch (ArithmeticException e) {
                        throw new ParseException(e.getMessage());
                    }
                }
                if (param1 instanceof Double || param1 instanceof Float) {
                    return Math.pow(((Number)((Object)param1)).doubleValue(), p2);
                }
                long res = l1 = ((Number)((Object)param1)).longValue();
                for (p2 = i; p2 > 1; --p2) {
                    long old;
                    if ((res *= l1) >= (old = res)) continue;
                    return Math.pow(l1, p2);
                }
                if (res >= 0L) {
                    return res;
                }
            }
            throw new ParseException("Power should be integer value");
        }
        throw new ParseException("Wrong type  power(" + param1.getClass() + "," + param2.getClass() + ")");
    }

    @Override
    public Comparable<?> getResult(Comparable<?> ... comparables) throws ParseException {
        return Power.power(comparables[0], comparables[1]);
    }
}

