/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.ASTFunNode;
import com.meidusa.amoeba.sqljep.JepRuntime;
import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.function.PostfixCommandI;
import java.math.BigDecimal;
import java.util.Stack;

public abstract class PostfixCommand
implements PostfixCommandI {
    protected static final Integer ZERO = new Integer(0);
    public static final String PARAMS_NUMBER = "Wrong number of parameters";
    public static final String WRONG_TYPE = "Wrong type";
    public static final String INTERNAL_ERROR = "Internal error";
    public static final String NOT_IMPLIMENTED_EXCEPTION = "Not implimented";
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public abstract int getNumberOfParameters();

    @Override
    public abstract Comparable<?>[] evaluate(ASTFunNode var1, JepRuntime var2) throws ParseException;

    @Override
    public boolean isAutoBox() {
        return true;
    }

    protected final void removeParams(Stack<Comparable> s, int num) {
        s.pop();
        for (int i = 1; i < num; ++i) {
            s.pop();
        }
        s.push(null);
    }

    public static Comparable<?> parse(String param) throws ParseException {
        try {
            return Long.valueOf(param);
        }
        catch (NumberFormatException e) {
            try {
                BigDecimal d = new BigDecimal(param);
                if (d.scale() < 0) {
                    d = d.setScale(0);
                }
                return d;
            }
            catch (NumberFormatException ex) {
                throw new ParseException(param + " Not a number");
            }
        }
    }

    public static BigDecimal getBigDecimal(Number param) {
        if (param instanceof BigDecimal) {
            return (BigDecimal)param;
        }
        if (param instanceof Double || param instanceof Float) {
            return new BigDecimal(param.doubleValue());
        }
        return new BigDecimal(param.longValue());
    }

    public static int getInteger(Comparable<?> param) throws ParseException {
        if (param instanceof Number) {
            return ((Number)((Object)param)).intValue();
        }
        if (param instanceof String) {
            try {
                BigDecimal d = new BigDecimal((String)((Object)param));
                return d.intValueExact();
            }
            catch (Exception e) {
                throw new ParseException("Cant parse integer: '" + (String)((Object)param) + "'");
            }
        }
        throw new ParseException("Not Integer: " + (param != null ? param.getClass() : "null"));
    }

    public static double getDouble(Comparable<?> param) throws ParseException {
        if (param instanceof Number) {
            Number n = (Number)((Object)param);
            return n.doubleValue();
        }
        if (param instanceof String) {
            try {
                return Double.valueOf((String)((Object)param));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Cant parse double: '" + (String)((Object)param) + "'");
            }
        }
        throw new ParseException("Not Double: " + (param != null ? param.getClass() : "null"));
    }

    @Override
    public boolean isDeclare() {
        return false;
    }
}

