/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.function.OracleDateFormat;
import com.meidusa.amoeba.sqljep.function.OracleTimeFormat;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;

public class OracleTimestampFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private static final String PATTERN_EXCEPTION = "Wrong pattern";
    private static final String FORMAT_EXCEPTION = "Wrong pattern";
    private static final String NOT_IMPLIMENTED_EXCEPTION = "Not implimented";
    private static final String BAD_INPUT_PATTERN = "Format code cannot appear in date input format";
    private static final String BAD_HH12 = "Hour must be between 1 and 12";
    protected static final Hashtable<String, ArrayList<Object>> formatsCache = new Hashtable();
    protected static final ArrayList<DATE> dateSymbols = new ArrayList();
    protected static final ArrayList<DATE> timeSymbols = new ArrayList();
    protected ArrayList<Object> format = null;
    protected Calendar cal;
    protected DateFormatSymbols symb;

    protected OracleTimestampFormat() {
    }

    public OracleTimestampFormat(String pattern) throws ParseException {
        this.cal = Calendar.getInstance();
        this.symb = new DateFormatSymbols();
        this.format = formatsCache.get(pattern);
        if (this.format == null) {
            this.format = new ArrayList();
            ArrayList symb = (ArrayList)dateSymbols.clone();
            symb.addAll(timeSymbols);
            OracleTimestampFormat.compilePattern(this.format, symb, pattern);
            formatsCache.put(pattern, this.format);
        }
    }

    public OracleTimestampFormat(String pattern, Calendar calendar, DateFormatSymbols dateSymb) throws ParseException {
        this.cal = calendar;
        this.symb = dateSymb;
        this.format = formatsCache.get(pattern);
        if (this.format == null) {
            this.format = new ArrayList();
            ArrayList symb = (ArrayList)dateSymbols.clone();
            symb.addAll(timeSymbols);
            OracleTimestampFormat.compilePattern(this.format, symb, pattern);
            formatsCache.put(pattern, this.format);
        }
    }

    public OracleTimeFormat getTimeFormat() {
        int i;
        ArrayList<Object> f = new ArrayList<Object>();
        int first = 0;
        int last = f.size();
        for (i = 0; i < f.size(); ++i) {
            Object obj = this.format.get(i);
            if (!(obj instanceof TIME)) continue;
            if (i > first) {
                first = i;
                continue;
            }
            if (i >= last) continue;
            last = i;
        }
        for (i = first; i < last; ++i) {
            f.add(this.format.get(i));
        }
        return new OracleTimeFormat(f, this.cal, this.symb);
    }

    public OracleDateFormat getDateFormat() {
        int i;
        ArrayList<Object> f = new ArrayList<Object>();
        int first = 0;
        int last = f.size();
        for (i = 0; i < f.size(); ++i) {
            Object obj = this.format.get(i);
            if (!(obj instanceof DATE)) continue;
            if (i > first) {
                first = i;
                continue;
            }
            if (i >= last) continue;
            last = i;
        }
        for (i = first; i < last; ++i) {
            f.add(this.format.get(i));
        }
        return new OracleDateFormat(f, this.cal, this.symb);
    }

    public String toString() {
        if (this.format != null) {
            StringBuilder str = new StringBuilder();
            for (Object obj : this.format) {
                str.append(obj.toString());
            }
            return str.toString();
        }
        return "null";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OracleTimestampFormat other = (OracleTimestampFormat)obj;
        return this.format != null ? this.format.equals(other.format) : false;
    }

    protected static void compilePattern(ArrayList<Object> format, ArrayList<DATE> symbols, String pattern) throws ParseException {
        if (pattern == null) {
            throw new ParseException("Wrong pattern", 0);
        }
        StringBuilder fill = new StringBuilder();
        int plen = pattern.length();
        int i = 0;
        while (i < plen) {
            boolean f = false;
            for (DATE d : symbols) {
                String symb = d.toString();
                if (i + symb.length() > plen || !pattern.regionMatches(true, i, symb, 0, symb.length())) continue;
                if (fill.length() > 0) {
                    format.add(fill.toString());
                    fill.setLength(0);
                }
                format.add(d);
                i += symb.length();
                f = true;
                break;
            }
            if (f) continue;
            char c = pattern.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                fill.append(c);
                ++i;
                continue;
            }
            throw new ParseException("Wrong pattern", i);
        }
        if (fill.length() > 0) {
            format.add(fill.toString());
        }
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer str, FieldPosition fieldPosition) {
        if (obj instanceof Date) {
            Date date = (Date)obj;
            this.cal.setTime(date);
            if (this.format != null) {
                for (Object f : this.format) {
                    if (f instanceof String) {
                        str.append((String)f);
                        continue;
                    }
                    DATE d = (DATE)f;
                    try {
                        d.toString(str, this.cal, this.symb);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return str;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return new Timestamp(this.parseInMillis(source, pos));
    }

    protected long parseInMillis(String source, ParsePosition pos) {
        int year = this.cal.get(1);
        int month = this.cal.get(2);
        this.cal.clear();
        this.cal.set(1, year);
        this.cal.set(2, month);
        int slen = source.length();
        try {
            if (this.format != null) {
                for (Object obj : this.format) {
                    if (!(obj instanceof DATE)) continue;
                    DATE d = (DATE)obj;
                    d.parse(this.cal, this.symb, source, pos);
                }
                for (int i = pos.getIndex(); i < slen; ++i) {
                    char c = source.charAt(i);
                    if (!Character.isLetterOrDigit(c)) continue;
                    throw new ParseException("Wrong pattern", 0);
                }
                pos.setIndex(slen);
            }
        }
        catch (Exception e) {
            pos.setErrorIndex(pos.getIndex());
            pos.setIndex(0);
            return 0L;
        }
        return this.cal.getTimeInMillis();
    }

    private static char getSign(String source, ParsePosition pos) throws ParseException {
        int i;
        int len = source.length();
        for (i = pos.getIndex(); i < len; ++i) {
            char c = source.charAt(i);
            if (c == '-' || c == '+') {
                pos.setIndex(i);
                return c;
            }
            if (Character.isDigit(c)) {
                pos.setIndex(i);
                return '+';
            }
            if (!Character.isLetter(c)) continue;
            pos.setIndex(i);
            throw new ParseException("", i);
        }
        throw new ParseException("", i);
    }

    private static int getNumber(String source, ParsePosition pos, int digits) throws ParseException, NumberFormatException {
        char c;
        int i;
        int len = source.length();
        String d = "";
        for (i = pos.getIndex(); i < len && !Character.isDigit(c = source.charAt(i)); ++i) {
            if (!Character.isLetter(c)) continue;
            pos.setIndex(i);
            throw new ParseException("", i);
        }
        while (i < len) {
            c = source.charAt(i);
            if (Character.isDigit(c)) {
                if ((d = d + c).length() == digits) {
                    pos.setIndex(i + 1);
                    return Integer.valueOf(d);
                }
            } else {
                if (!Character.isLetter(c)) break;
                pos.setIndex(i);
                throw new ParseException("", i);
            }
            ++i;
        }
        pos.setIndex(i);
        return Integer.valueOf(d);
    }

    static {
        dateSymbols.add(new fBC());
        dateSymbols.add(new fAD());
        dateSymbols.add(new BdCd());
        dateSymbols.add(new AdDd());
        dateSymbols.add(new SCC());
        dateSymbols.add(new CC());
        dateSymbols.add(new SYYYY());
        dateSymbols.add(new YYYY());
        dateSymbols.add(new YcYYY());
        dateSymbols.add(new YYY());
        dateSymbols.add(new YY());
        dateSymbols.add(new Y());
        dateSymbols.add(new SYEAR());
        dateSymbols.add(new YEAR());
        dateSymbols.add(new IYYY());
        dateSymbols.add(new IY());
        dateSymbols.add(new I());
        dateSymbols.add(new RRRR());
        dateSymbols.add(new RR());
        dateSymbols.add(new Q());
        dateSymbols.add(new MONTH());
        dateSymbols.add(new MON());
        dateSymbols.add(new MM());
        dateSymbols.add(new RM());
        dateSymbols.add(new WW());
        dateSymbols.add(new IW());
        dateSymbols.add(new DAY());
        dateSymbols.add(new DY());
        dateSymbols.add(new DDD());
        dateSymbols.add(new DD());
        dateSymbols.add(new D());
        dateSymbols.add(new J());
        timeSymbols.add(new HH12());
        timeSymbols.add(new HH24());
        timeSymbols.add(new HH());
        timeSymbols.add(new fAM());
        timeSymbols.add(new fPM());
        timeSymbols.add(new PdMd());
        timeSymbols.add(new AdMd());
        timeSymbols.add(new MI());
        timeSymbols.add(new SSSSS());
        timeSymbols.add(new SS());
    }

    public static final class SS
    extends TIME {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int second = cal.get(13);
            String s = Integer.toString(second);
            if (s.length() == 1) {
                str.append('0');
            }
            str.append(s);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int second = OracleTimestampFormat.getNumber(source, pos, 2);
            cal.set(13, second);
        }

        public String toString() {
            return "SS";
        }
    }

    public static final class SSSSS
    extends TIME {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int hour = cal.get(10);
            int minute = cal.get(12);
            int second = cal.get(13);
            String s = Integer.toString(hour * 60 * 60 + minute * 60 + second);
            for (int i = s.length(); i < 5; ++i) {
                str.append('0');
            }
            str.append(s);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int sssss = OracleTimestampFormat.getNumber(source, pos, 5);
            int hour = sssss / 3600;
            int minute = (sssss -= hour) / 60;
            int second = sssss - minute;
            cal.set(10, hour);
            cal.set(12, minute);
            cal.set(13, second);
        }

        public String toString() {
            return "SSSSS";
        }
    }

    public static final class MI
    extends TIME {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int minute = cal.get(12);
            String m = Integer.toString(minute);
            if (m.length() == 1) {
                str.append('0');
            }
            str.append(m);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int minute = OracleTimestampFormat.getNumber(source, pos, 2);
            cal.set(12, minute);
        }

        public String toString() {
            return "MI";
        }
    }

    public static final class AdMd
    extends TIME {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int am = cal.get(9);
            str.append(am == 0 ? "a.m." : "p.m.");
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int i = pos.getIndex();
            String t = source.substring(i, i + 4);
            if (this.toString().equals(t.toUpperCase())) {
                pos.setIndex(i + 4);
                cal.set(9, 0);
            } else if (t.toUpperCase().equals("P.M.")) {
                pos.setIndex(i + 4);
                cal.set(9, 1);
            } else {
                throw new ParseException("", 0);
            }
        }

        public String toString() {
            return "A.M.";
        }
    }

    public static final class PdMd
    extends TIME {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int am = cal.get(9);
            str.append(am == 0 ? "a.m." : "p.m.");
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int i = pos.getIndex();
            String t = source.substring(i, i + 4);
            if (this.toString().equals(t.toUpperCase())) {
                pos.setIndex(i + 4);
                cal.set(9, 1);
            } else if (t.toUpperCase().equals("A.M.")) {
                pos.setIndex(i + 4);
                cal.set(9, 0);
            } else {
                throw new ParseException("", 0);
            }
        }

        public String toString() {
            return "P.M.";
        }
    }

    public static final class fPM
    extends TIME {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            String[] ampm = symb.getAmPmStrings();
            int am = cal.get(9);
            str.append(ampm[am]);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            String[] ampm = symb.getAmPmStrings();
            int idx = pos.getIndex();
            for (int i = 0; i < ampm.length; ++i) {
                int len = ampm[i].length();
                if (!source.regionMatches(true, idx, ampm[i], 0, len)) continue;
                pos.setIndex(idx + len);
                cal.set(0, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "PM";
        }
    }

    public static final class fAM
    extends TIME {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            String[] ampm = symb.getAmPmStrings();
            int am = cal.get(9);
            str.append(ampm[am]);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            String[] ampm = symb.getAmPmStrings();
            int idx = pos.getIndex();
            for (int i = 0; i < ampm.length; ++i) {
                int len = ampm[i].length();
                if (!source.regionMatches(true, idx, ampm[i], 0, len)) continue;
                pos.setIndex(idx + len);
                cal.set(0, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "AM";
        }
    }

    public static final class HH
    extends TIME {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int hour = cal.get(10);
            String h = Integer.toString(hour);
            if (h.length() == 1) {
                str.append('0');
            }
            str.append(h);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int hour = OracleTimestampFormat.getNumber(source, pos, 2);
            if (hour <= 0 || hour >= 13) {
                throw new ParseException(OracleTimestampFormat.BAD_HH12, 0);
            }
            cal.set(10, hour);
        }

        public String toString() {
            return "HH";
        }
    }

    public static final class HH24
    extends TIME {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int hour = cal.get(11);
            String h = Integer.toString(hour);
            if (h.length() == 1) {
                str.append('0');
            }
            str.append(h);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int hour = OracleTimestampFormat.getNumber(source, pos, 2);
            cal.set(11, hour);
        }

        public String toString() {
            return "HH24";
        }
    }

    public static final class HH12
    extends TIME {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int hour = cal.get(10);
            String h = Integer.toString(hour);
            if (h.length() == 1) {
                str.append('0');
            }
            str.append(h);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int hour = OracleTimestampFormat.getNumber(source, pos, 2);
            if (hour <= 0 || hour >= 13) {
                throw new ParseException(OracleTimestampFormat.BAD_HH12, 0);
            }
            cal.set(10, hour);
        }

        public String toString() {
            return "HH12";
        }
    }

    public static final class J
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public String toString() {
            return "J";
        }
    }

    public static final class D
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int day = cal.get(7);
            int t = day - cal.getFirstDayOfWeek();
            String d = Integer.toString(t < 0 ? 7 : t + 1);
            str.append(d);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            OracleTimestampFormat.getNumber(source, pos, 1);
        }

        public String toString() {
            return "D";
        }
    }

    public static final class DD
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int day = cal.get(5);
            String d = Integer.toString(day);
            if (d.length() == 1) {
                str.append('0');
            }
            str.append(d);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int day = OracleTimestampFormat.getNumber(source, pos, 2);
            cal.set(5, day);
        }

        public String toString() {
            return "DD";
        }
    }

    public static final class DDD
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int day = cal.get(6);
            String d = Integer.toString(day);
            for (int i = d.length(); i < 3; ++i) {
                str.append('0');
            }
            str.append(d);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int month = OracleTimestampFormat.getNumber(source, pos, 3);
            cal.set(6, month);
        }

        public String toString() {
            return "DDD";
        }
    }

    public static final class DY
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int day = cal.get(7);
            String[] week = symb.getShortWeekdays();
            str.append(week[day]);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            String[] months = symb.getShortWeekdays();
            int idx = pos.getIndex();
            for (int i = 0; i < months.length; ++i) {
                int len = months[i].length();
                if (!source.regionMatches(true, idx, months[i], 0, len)) continue;
                pos.setIndex(idx + len);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "DY";
        }
    }

    public static final class DAY
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int day = cal.get(7);
            String[] week = symb.getWeekdays();
            str.append(week[day]);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            String[] months = symb.getWeekdays();
            int idx = pos.getIndex();
            for (int i = 0; i < months.length; ++i) {
                int len = months[i].length();
                if (!source.regionMatches(true, idx, months[i], 0, len)) continue;
                pos.setIndex(idx + len);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "DAY";
        }
    }

    public static final class IW
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "IW";
        }
    }

    public static final class WW
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int month = cal.get(3);
            String m = Integer.toString(month);
            if (m.length() == 1) {
                str.append('0');
            }
            str.append(m);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "WW";
        }
    }

    public static final class RM
    extends DATE {
        private static final String[] rmonths = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII"};

        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int month = cal.get(2);
            str.append(rmonths[month]);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int idx = pos.getIndex();
            for (int i = 0; i < rmonths.length; ++i) {
                int len = rmonths[i].length();
                if (!source.regionMatches(true, idx, rmonths[i], 0, len)) continue;
                pos.setIndex(idx + len);
                cal.set(2, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "RM";
        }
    }

    public static final class MM
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int month = cal.get(2) + 1;
            String m = Integer.toString(month);
            if (m.length() == 1) {
                str.append('0');
            }
            str.append(m);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int month = OracleTimestampFormat.getNumber(source, pos, 2) - 1;
            cal.set(2, month);
        }

        public String toString() {
            return "MM";
        }
    }

    public static final class MON
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int month = cal.get(2);
            String[] months = symb.getShortMonths();
            str.append(months[month]);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            String[] months = symb.getShortMonths();
            int idx = pos.getIndex();
            for (int i = 0; i < months.length; ++i) {
                int len = months[i].length();
                if (!source.regionMatches(true, idx, months[i], 0, len)) continue;
                pos.setIndex(idx + len);
                cal.set(2, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "MON";
        }
    }

    public static final class MONTH
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int month = cal.get(2);
            String[] months = symb.getMonths();
            str.append(months[month]);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            String[] months = symb.getMonths();
            int idx = pos.getIndex();
            for (int i = 0; i < months.length; ++i) {
                int len = months[i].length();
                if (!source.regionMatches(true, idx, months[i], 0, len)) continue;
                pos.setIndex(idx + len);
                cal.set(2, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "MONTH";
        }
    }

    public static final class Q
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int month = cal.get(2);
            String y = Integer.toString(month / 3 * 3);
            str.append(y);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "Q";
        }
    }

    public static final class RR
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public String toString() {
            return "RR";
        }
    }

    public static final class RRRR
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public String toString() {
            return "RRRR";
        }
    }

    public static final class I
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public String toString() {
            return "I";
        }
    }

    public static final class IY
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public String toString() {
            return "IY";
        }
    }

    public static final class IYYY
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public String toString() {
            return "IYYY";
        }
    }

    public static final class YEAR
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "YEAR";
        }
    }

    public static final class SYEAR
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "SYEAR";
        }
    }

    public static final class Y
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int year = cal.get(1);
            String y = Integer.toString(year - year / 10 * 10);
            str.append(y);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int year = OracleTimestampFormat.getNumber(source, pos, 1);
            int y = cal.get(1) / 10 * 10;
            cal.set(1, y + year);
        }

        public String toString() {
            return "Y";
        }
    }

    public static final class YY
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int year = cal.get(1);
            String y = Integer.toString(year - year / 100 * 100);
            for (int i = y.length(); i < 2; ++i) {
                str.append('0');
            }
            str.append(y);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int year = OracleTimestampFormat.getNumber(source, pos, 2);
            int y = cal.get(1) / 100 * 100;
            cal.set(1, y + year);
        }

        public String toString() {
            return "YY";
        }
    }

    public static final class YYY
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int year = cal.get(1);
            String y = Integer.toString(year - year / 1000 * 1000);
            for (int i = y.length(); i < 3; ++i) {
                str.append('0');
            }
            str.append(y);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int year = OracleTimestampFormat.getNumber(source, pos, 3);
            int y = cal.get(1) / 1000 * 1000;
            cal.set(1, y + year);
        }

        public String toString() {
            return "YYY";
        }
    }

    public static final class YcYYY
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int year = cal.get(1);
            String y = Integer.toString(year / 1000);
            str.append(y + ',');
            String yyy = Integer.toString(year - year / 1000 * 1000);
            for (int i = y.length(); i < 3; ++i) {
                str.append('0');
            }
            str.append(yyy);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int year;
            OracleTimestampFormat.getNumber(source, pos, 1);
            int i = pos.getIndex();
            String d = source.charAt(i - 1) + "";
            if (source.charAt(i) == ',') {
                pos.setIndex(++i);
                OracleTimestampFormat.getNumber(source, pos, 3);
                d = d + source.substring(i, pos.getIndex());
                year = Integer.valueOf(d);
            } else {
                pos.setIndex(i - 1);
                year = OracleTimestampFormat.getNumber(source, pos, 4);
            }
            cal.set(1, year);
        }

        public String toString() {
            return "Y,YYY";
        }
    }

    public static final class YYYY
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int year = cal.get(1);
            String y = Integer.toString(Math.abs(year));
            for (int i = y.length(); i < 4; ++i) {
                str.append('0');
            }
            str.append(y);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int year = OracleTimestampFormat.getNumber(source, pos, 4);
            cal.set(1, year);
        }

        public String toString() {
            return "YYYY";
        }
    }

    public static final class SYYYY
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int year = cal.get(1);
            String y = Integer.toString(year);
            for (int i = y.length(); i < 4; ++i) {
                str.append('0');
            }
            str.append(y);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            boolean negate = false;
            if (OracleTimestampFormat.getSign(source, pos) == '-') {
                negate = true;
            }
            int year = OracleTimestampFormat.getNumber(source, pos, 4);
            if (negate) {
                year = -year;
            }
            cal.set(1, year);
        }

        public String toString() {
            return "SYYYY";
        }
    }

    public static final class CC
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int year = cal.get(1);
            String cc = Integer.toString(Math.abs(year / 100 * 100));
            if (cc.length() == 1) {
                str.append('0');
            }
            str.append(cc);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "CC";
        }
    }

    public static final class SCC
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int year = cal.get(1);
            String cc = Integer.toString(year / 100 * 100);
            if (cc.length() == 1) {
                str.append('0');
            }
            str.append(cc);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "SCC";
        }
    }

    public static final class AdDd
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int era = cal.get(0);
            str.append(era == 1 ? "a.d." : "b.c.");
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int i = pos.getIndex();
            String t = source.substring(i, i + 4);
            if (this.toString().equals(t.toUpperCase())) {
                pos.setIndex(i + 4);
                cal.set(0, 1);
            } else if (t.toUpperCase().equals("B.C.")) {
                pos.setIndex(i + 4);
                cal.set(0, 0);
            } else {
                throw new ParseException("", 0);
            }
        }

        public String toString() {
            return "A.D.";
        }
    }

    public static final class BdCd
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            int era = cal.get(0);
            str.append(era == 0 ? "b.c." : "a.d.");
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            int i = pos.getIndex();
            String t = source.substring(i, i + 4);
            if (this.toString().equals(t.toUpperCase())) {
                pos.setIndex(i + 4);
                cal.set(0, 0);
            } else if (t.toUpperCase().equals("A.D.")) {
                pos.setIndex(i + 4);
                cal.set(0, 1);
            } else {
                throw new ParseException("", 0);
            }
        }

        public String toString() {
            return "B.C.";
        }
    }

    public static final class fAD
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            String[] eras = symb.getEras();
            int era = cal.get(0);
            str.append(eras[era]);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            String[] eras = symb.getEras();
            int idx = pos.getIndex();
            for (int i = 0; i < eras.length; ++i) {
                int len = eras[i].length();
                if (!source.regionMatches(true, idx, eras[i], 0, len)) continue;
                pos.setIndex(idx + len);
                cal.set(0, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "AD";
        }
    }

    public static final class fBC
    extends DATE {
        @Override
        public StringBuffer toString(StringBuffer str, Calendar cal, DateFormatSymbols symb) throws ParseException {
            String[] eras = symb.getEras();
            int era = cal.get(0);
            str.append(eras[era]);
            return str;
        }

        @Override
        public void parse(Calendar cal, DateFormatSymbols symb, String source, ParsePosition pos) throws ParseException {
            String[] eras = symb.getEras();
            int idx = pos.getIndex();
            for (int i = 0; i < eras.length; ++i) {
                int len = eras[i].length();
                if (!source.regionMatches(false, idx, eras[i], 0, len)) continue;
                pos.setIndex(idx + len);
                cal.set(0, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "BC";
        }
    }

    public static abstract class TIME
    extends DATE {
    }

    public static abstract class DATE {
        public abstract StringBuffer toString(StringBuffer var1, Calendar var2, DateFormatSymbols var3) throws ParseException;

        public abstract void parse(Calendar var1, DateFormatSymbols var2, String var3, ParsePosition var4) throws ParseException;

        public boolean equals(Comparable<?> obj) {
            if (obj == null) {
                return false;
            }
            return obj.getClass() == this.getClass();
        }
    }
}

