/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Hashtable;

public final class OracleNumberFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private static final String PATTERN_EXCEPTION = "Wrong pattern";
    public static final String NOT_IMPLIMENTED_EXCEPTION = "Not implimented";
    static final char DOT = '.';
    static final char GROUP = ' ';
    private static final Hashtable<String, FORMAT> formatsCache = new Hashtable();
    private FORMAT format = null;

    public OracleNumberFormat(String pattern) throws ParseException {
        this.format = formatsCache.get(pattern);
        if (this.format == null) {
            this.format = OracleNumberFormat.compilePattern(pattern);
            formatsCache.put(pattern, this.format);
        }
    }

    public String toString() {
        return this.format != null ? this.format.toString() : "null";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OracleNumberFormat other = (OracleNumberFormat)obj;
        return this.format != null ? this.format.equals(other.format) : false;
    }

    private static FORMAT compilePattern(String pattern) throws ParseException {
        String prefix;
        int i;
        if (pattern == null) {
            throw new ParseException(PATTERN_EXCEPTION, 0);
        }
        if (pattern.equals("RN") || pattern.equals("rn")) {
            throw new ParseException(NOT_IMPLIMENTED_EXCEPTION, 0);
        }
        FORMAT format = new FORMAT();
        if (pattern.length() == 0) {
            return format;
        }
        char c = (pattern = pattern.toUpperCase()).charAt(0);
        boolean n = c == '0' || c == '9';
        int flen = pattern.length();
        if (!n) {
            for (i = 1; i < flen && (c = pattern.charAt(i)) != '0' && c != '9'; ++i) {
            }
            prefix = pattern.substring(0, i);
        } else {
            prefix = "";
            i = 0;
        }
        StringBuilder numbers = new StringBuilder();
        boolean stop = false;
        boolean leadZero = true;
        boolean definedGroups = false;
        while (i < flen) {
            c = pattern.charAt(i);
            stop = true;
            if (c == 'G') {
                if (definedGroups && !format.localGroups) {
                    throw new ParseException(PATTERN_EXCEPTION, 0);
                }
                definedGroups = true;
                format.localGroups = true;
                stop = false;
                numbers.append('G');
            } else if (c == ',') {
                if (definedGroups && format.localGroups) {
                    throw new ParseException(PATTERN_EXCEPTION, i);
                }
                definedGroups = true;
                format.localGroups = true;
                stop = false;
                numbers.append('G');
            } else if (leadZero) {
                if (c == '0') {
                    numbers.append('0');
                    ++format.digits;
                    stop = false;
                } else if (c == '9') {
                    stop = false;
                    leadZero = false;
                    format.firstNine = numbers.length();
                    numbers.append('9');
                    ++format.digits;
                }
            } else if (c == '0' || c == '9') {
                stop = false;
                numbers.append('9');
                ++format.digits;
            }
            if (stop) break;
            ++i;
        }
        if (leadZero) {
            format.firstNine = numbers.length();
        }
        if (c == 'V') {
            ++i;
            while (i < flen && ((c = pattern.charAt(i)) == '0' || c == '9')) {
                ++i;
                ++format.v;
            }
        } else if (c == '.' || c == 'D') {
            if (definedGroups) {
                if (format.localGroups && c == '.' || !format.localGroups && c == 'D') {
                    throw new ParseException(PATTERN_EXCEPTION, i);
                }
            } else {
                format.localGroups = c == 'D';
            }
            ++i;
            while (i < flen && ((c = pattern.charAt(i)) == '0' || c == '9')) {
                ++i;
                ++format.dot;
            }
        }
        format.numbers = numbers.toString();
        if (i == prefix.length()) {
            throw new ParseException(PATTERN_EXCEPTION, i);
        }
        String suffix = pattern.substring(i);
        int suf_offset = 0;
        if (suffix.startsWith("EEEE")) {
            format.sci = true;
            suf_offset = 4;
        }
        if (suffix.startsWith("S", suf_offset)) {
            format.sign = SIGN._S;
            ++suf_offset;
        } else if (suffix.startsWith("MI", suf_offset)) {
            format.sign = SIGN.MI;
            suf_offset += 2;
        } else if (suffix.startsWith("PR", suf_offset)) {
            format.sign = SIGN.PR;
            suf_offset += 2;
        }
        if (suf_offset < suffix.length()) {
            throw new ParseException(PATTERN_EXCEPTION, i);
        }
        int pref_offset = 0;
        if (format.sign == SIGN.DEFAULT && prefix.startsWith("S")) {
            format.sign = SIGN.S_;
            ++pref_offset;
        }
        if (prefix.startsWith("FM", pref_offset)) {
            format.fm = true;
            pref_offset += 2;
        }
        if (prefix.startsWith("B", pref_offset)) {
            format.b = true;
            ++pref_offset;
        }
        if (format.sign == SIGN.DEFAULT && prefix.startsWith("S", pref_offset)) {
            format.sign = SIGN.S_;
            ++suf_offset;
        }
        if (prefix.startsWith("$", pref_offset)) {
            format.cur = CURRENCY.DOLLARS;
            ++pref_offset;
        } else if (prefix.startsWith("L", pref_offset)) {
            format.cur = CURRENCY.LOCAL;
            ++pref_offset;
        } else if (prefix.startsWith("C", pref_offset)) {
            format.cur = CURRENCY.ISO;
            ++pref_offset;
        }
        if (pref_offset < prefix.length()) {
            throw new ParseException(PATTERN_EXCEPTION, 0);
        }
        return format;
    }

    @Override
    public StringBuffer format(Object number, StringBuffer str, FieldPosition fieldPosition) {
        if (number instanceof Number) {
            BigDecimal d = number instanceof BigDecimal ? (BigDecimal)number : (number instanceof Double || number instanceof Float ? new BigDecimal(((Number)number).doubleValue()) : new BigDecimal(((Number)number).longValue()));
            if (this.format.sci) {
                int len = d.unscaledValue().abs().toString().toCharArray().length;
                int scale = d.scale();
                this.format.getPrefix(str, d);
                d = new BigDecimal(d.unscaledValue(), len - 1);
                d = d.setScale(this.format.dot + this.format.v, 6);
                char[] coeff = d.unscaledValue().abs().toString().toCharArray();
                if (coeff.length > 1 + this.format.v) {
                    str.append(coeff, 0, 1 + this.format.v);
                    if (coeff.length > 1) {
                        str.append('.');
                        str.append(coeff, 1 + this.format.v, coeff.length - 1);
                    }
                } else {
                    str.append(coeff);
                    for (int i = 0; i < this.format.v + 1 - coeff.length; ++i) {
                        str.append('0');
                    }
                }
                int adjusted = len - scale - 1;
                str.append('E');
                str.append(adjusted >= 0 ? (char)'+' : '-');
                String m = Integer.toString(Math.abs(adjusted));
                if (m.length() == 1) {
                    str.append('0');
                }
                str.append(m);
                this.format.getSuffix(str, d);
            } else if (this.format.b && d.signum() == 0) {
                if (!this.format.fm) {
                    for (int i = 0; i < this.format.numbers.length() + this.format.v + 1; ++i) {
                        str.append(' ');
                    }
                }
            } else if (d.precision() - d.scale() > this.format.digits) {
                for (int i = 0; i < this.format.numbers.length() + this.format.v + 1; ++i) {
                    str.append('#');
                }
            } else {
                int i;
                this.format.getPrefix(str, d);
                int scale = d.scale();
                int digits = this.format.digits;
                if (this.format.v > 0 && scale > 0) {
                    int v;
                    if (this.format.v > scale) {
                        v = 0;
                        this.format.v -= scale;
                    } else {
                        v = scale - this.format.v;
                        this.format.v = 0;
                    }
                    digits += scale;
                    d = new BigDecimal(d.unscaledValue(), v);
                }
                char[] coeff = d.unscaledValue().abs().toString().toCharArray();
                int len = coeff.length;
                if (this.format.dot < d.scale()) {
                    d = d.setScale(this.format.dot, 6);
                    coeff = d.unscaledValue().abs().toString().toCharArray();
                    len = coeff.length;
                }
                int j = 0;
                int prec = len - d.scale();
                int i1 = 0;
                int n = this.format.numbers.length();
                for (i = 0; i < n; ++i) {
                    if (this.format.numbers.charAt(i) == 'G') {
                        str.append(' ');
                        continue;
                    }
                    if (i1 < digits - prec) {
                        if (this.format.firstNine != 0) {
                            str.append('0');
                        } else if (!this.format.fm) {
                            str.append(' ');
                        }
                        ++i1;
                        continue;
                    }
                    str.append(coeff[j++]);
                    ++i1;
                }
                while (j < coeff.length) {
                    str.append(coeff[j]);
                    ++j;
                }
                for (i = 0; i < this.format.v; ++i) {
                    str.append('0');
                }
                if (this.format.dot > 0) {
                    str.append('.');
                }
                for (i = 0; i < this.format.dot; ++i) {
                    if (i < d.scale()) {
                        str.append(coeff[prec + i]);
                        continue;
                    }
                    str.append('0');
                }
                this.format.getSuffix(str, d);
            }
        }
        return str;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object parseObject(String source, ParsePosition pos) {
        int start;
        StringBuilder d = new StringBuilder(pos != null ? source.substring(pos.getIndex()) : source);
        try {
            void var14_22;
            int i;
            char s;
            boolean negate = false;
            int len = d.length();
            for (start = 0; start < len && d.charAt(start) == ' '; ++start) {
            }
            if (this.format.sign == SIGN.PR) {
                if (d.charAt(start) == '<' && d.charAt(len - 1) == '>') {
                    d.setCharAt(start++, ' ');
                    d.setLength(--len);
                    negate = true;
                }
            } else if (this.format.sign == SIGN.MI) {
                if (d.charAt(len - 1) == '-') {
                    d.setLength(--len);
                    negate = true;
                }
            } else if (this.format.sign == SIGN._S) {
                s = d.charAt(len - 1);
                if (s == '-') {
                    d.setLength(--len);
                    negate = true;
                } else {
                    if (s != '+') {
                        pos.setErrorIndex(start);
                        return null;
                    }
                    d.setLength(--len);
                }
            } else if (this.format.sign == SIGN.S_) {
                s = d.charAt(start);
                if (s == '-') {
                    d.setCharAt(start++, ' ');
                    negate = true;
                } else {
                    if (s != '+') {
                        pos.setErrorIndex(start);
                        return null;
                    }
                    d.setCharAt(start++, ' ');
                }
            } else if (this.format.sign == SIGN.DEFAULT) {
                s = d.charAt(start);
                if (s == '-') {
                    d.setCharAt(start++, ' ');
                    negate = true;
                } else if (s == '+') {
                    d.setCharAt(start++, ' ');
                }
            }
            while (start < len && d.charAt(start) == ' ') {
                ++start;
            }
            int e = d.indexOf("E");
            if (e == -1) {
                e = d.indexOf("e");
            }
            int dot = source.indexOf(46);
            int coefflen = len - start;
            if (negate) {
                ++coefflen;
            }
            char[] coeff = new char[coefflen];
            int scale = 0;
            int precision = 0;
            if (negate) {
                ++precision;
                coeff[0] = 45;
            }
            if (this.format.sci) {
                if (this.format.numbers.length() == 0 || this.format.numbers.indexOf(71) != -1) {
                    pos.setErrorIndex(start);
                    return null;
                }
                if (e == -1) {
                    pos.setErrorIndex(start);
                    return null;
                }
                coeff[precision++] = d.charAt(start);
                scale = -Integer.valueOf(d.substring(e + 1)).intValue();
                if (dot == -1) {
                    if (start + 1 != e) {
                        pos.setErrorIndex(start);
                        return null;
                    }
                } else {
                    if (this.format.dot < e - dot - 1) {
                        pos.setErrorIndex(dot);
                        return null;
                    }
                    if (start + 1 != dot) {
                        pos.setErrorIndex(start);
                        return null;
                    }
                    scale += e - dot - 1;
                    for (i = dot + 1; i < e; ++i) {
                        coeff[precision++] = d.charAt(i);
                    }
                }
            } else {
                if (e >= 0) {
                    pos.setErrorIndex(e);
                    return null;
                }
                if (dot != -1) {
                    --coefflen;
                    scale = len - dot - 1;
                    if (this.format.dot < scale) {
                        pos.setErrorIndex(dot);
                        return null;
                    }
                }
                try {
                    void var14_18;
                    int end = dot < 0 ? len : dot;
                    int n = this.format.numbers.length() - 1;
                    for (int i2 = start; i2 < end; ++i2, --var14_18) {
                        char c = d.charAt(i2);
                        if (this.format.numbers.charAt((int)var14_18) == 'G') {
                            if (c == ' ') continue;
                            pos.setErrorIndex(i2);
                            return null;
                        }
                        if (!Character.isDigit(c)) {
                            pos.setErrorIndex(i2);
                            return null;
                        }
                        coeff[precision++] = c;
                    }
                }
                catch (Exception ex) {
                    pos.setErrorIndex(start);
                    ex.printStackTrace();
                    return null;
                }
                if (dot != -1) {
                    for (i = dot + 1; i < len; ++i) {
                        char c = d.charAt(i);
                        if (!Character.isDigit(c)) {
                            pos.setErrorIndex(i);
                            return null;
                        }
                        coeff[precision++] = c;
                    }
                }
            }
            String str = new String(coeff, 0, precision);
            if (scale == 0 && precision < 10) {
                Integer n = new Integer(Integer.valueOf(str));
            } else {
                BigDecimal bigDecimal = new BigDecimal(new BigInteger(str), scale);
            }
            pos.setIndex(len);
            return var14_22;
        }
        catch (Exception e) {
            pos.setErrorIndex(start);
            e.printStackTrace();
            return null;
        }
    }

    private static class FORMAT {
        boolean sci;
        boolean localGroups = true;
        String numbers = "";
        int digits = 0;
        int firstNine = -1;
        SIGN sign = SIGN.DEFAULT;
        boolean fm = false;
        boolean b = false;
        CURRENCY cur = CURRENCY.NON;
        int v = 0;
        int dot = 0;

        private FORMAT() {
        }

        public void getPrefix(StringBuffer s, BigDecimal n) {
            if (this.sci && !this.fm) {
                s.append(' ');
            }
            if (n.signum() == 1) {
                if (this.sign == SIGN.S_) {
                    s.append('+');
                } else if (!this.fm && this.sign != SIGN._S && this.sign != SIGN.MI) {
                    s.append(' ');
                }
            } else if (n.signum() == -1) {
                if (this.sign == SIGN.PR) {
                    s.append('<');
                } else if (this.sign != SIGN._S && this.sign != SIGN.MI) {
                    s.append('-');
                }
            } else if (!this.fm) {
                s.append(' ');
            }
            if (this.cur == CURRENCY.DOLLARS) {
                s.append("$");
            } else if (this.cur == CURRENCY.ISO) {
                s.append("RUR");
            }
        }

        public void getSuffix(StringBuffer s, BigDecimal n) {
            if (this.cur == CURRENCY.LOCAL) {
                s.append("\u75fc?");
            }
            if (n.signum() == 1) {
                if (this.sign == SIGN._S) {
                    s.append('+');
                } else if (this.sign == SIGN.MI) {
                    s.append(' ');
                }
            } else if (n.signum() == -1) {
                if (this.sign == SIGN.PR) {
                    s.append('>');
                } else if (this.sign == SIGN.MI || this.sign == SIGN._S) {
                    s.append('-');
                }
            }
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            if (this.sign == SIGN.S_) {
                s.append('S');
            }
            if (this.fm) {
                s.append("FM");
            }
            if (this.b) {
                s.append('B');
            }
            if (this.cur == CURRENCY.DOLLARS) {
                s.append('$');
            } else if (this.cur == CURRENCY.LOCAL) {
                s.append('L');
            } else if (this.cur == CURRENCY.ISO) {
                s.append('C');
            }
            s.append(this.numbers);
            if (this.dot > 0) {
                s.append('D');
                for (int i = 0; i < this.dot; ++i) {
                    s.append('9');
                }
            } else if (this.v > 0) {
                s.append('V');
                for (int i = 0; i < this.v; ++i) {
                    s.append('9');
                }
            }
            if (this.sci) {
                s.append("EEEE");
            }
            if (this.sign == SIGN._S) {
                s.append('S');
            } else if (this.sign == SIGN.MI) {
                s.append("MI");
            }
            return s.toString();
        }

        public boolean equals(Comparable<?> obj) {
            if (obj == null) {
                return false;
            }
            FORMAT other = (FORMAT)((Object)obj);
            return this.sci == other.sci && this.localGroups == other.localGroups && this.numbers.equals(other.numbers) && this.digits == other.digits && this.firstNine == other.firstNine && this.sign == other.sign && this.fm == other.fm && this.b == other.b && this.cur == other.cur && this.v == other.v && this.dot == other.dot;
        }
    }

    public static enum CURRENCY {
        NON,
        DOLLARS,
        LOCAL,
        ISO;

    }

    public static enum SIGN {
        DEFAULT,
        MI,
        _S,
        S_,
        PR;

    }
}

