/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.ASTFunNode;
import com.meidusa.amoeba.sqljep.JepRuntime;
import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.function.PostfixCommand;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class NextDay
extends PostfixCommand {
    @Override
    public final int getNumberOfParameters() {
        return 2;
    }

    @Override
    public Comparable<?>[] evaluate(ASTFunNode node, JepRuntime runtime) throws ParseException {
        node.childrenAccept(runtime.ev, null);
        Comparable param2 = runtime.stack.pop();
        Comparable param1 = runtime.stack.pop();
        return new Comparable[]{param1, param2};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Date nextDay(Comparable<?> param1, Comparable<?> param2, Calendar cal) throws ParseException {
        if (param1 == null && param2 == null) {
            return null;
        }
        try {
            Object d;
            int dayOfWeek;
            if (param2 instanceof Number) {
                dayOfWeek = ((Number)((Object)param2)).intValue();
            } else {
                if (!(param2 instanceof String)) throw new ParseException();
                d = (String)((Object)param2);
                if (d == "SUNDAY") {
                    dayOfWeek = 1;
                } else if (d == "MONDAY") {
                    dayOfWeek = 2;
                } else if (d == "TUESDAY") {
                    dayOfWeek = 3;
                } else if (d == "WEDNESDAY") {
                    dayOfWeek = 4;
                } else if (d == "THURSDAY") {
                    dayOfWeek = 5;
                } else if (d == "FRIDAY") {
                    dayOfWeek = 6;
                } else {
                    if (d != "SATURDAY") throw new ParseException();
                    dayOfWeek = 7;
                }
            }
            if (!(param1 instanceof Timestamp) && !(param1 instanceof java.sql.Date)) throw new ParseException();
            d = (Date)param1;
            cal.setTimeInMillis(((Date)d).getTime());
            int day = cal.get(7);
            cal.add(5, day < dayOfWeek ? dayOfWeek - day : 7 + dayOfWeek - day);
            return new Date(cal.getTimeInMillis());
        }
        catch (ParseException e) {
            throw new ParseException("Wrong type  next_day(" + param1.getClass() + "," + param2.getClass() + ")");
        }
    }

    @Override
    public Comparable<?> getResult(Comparable<?> ... comparables) throws ParseException {
        return NextDay.nextDay(comparables[0], comparables[1], JepRuntime.getCalendar());
    }
}

