/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.ASTFunNode;
import com.meidusa.amoeba.sqljep.JepRuntime;
import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.function.PostfixCommand;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;

public class MonthsBetween
extends PostfixCommand {
    private static final BigDecimal DAYS_IN_MONTH = new BigDecimal(31);

    @Override
    public final int getNumberOfParameters() {
        return 2;
    }

    @Override
    public Comparable<?>[] evaluate(ASTFunNode node, JepRuntime runtime) throws ParseException {
        node.childrenAccept(runtime.ev, null);
        Comparable param2 = runtime.stack.pop();
        Comparable param1 = runtime.stack.pop();
        return new Comparable[]{param1, param2};
    }

    public static BigDecimal monthsBetween(Comparable<?> param1, Comparable<?> param2, Calendar cal) throws ParseException {
        if (param1 == null && param2 == null) {
            return null;
        }
        try {
            if (param1 instanceof Date && param2 instanceof Date) {
                if (param1 instanceof Time || param2 instanceof Time) {
                    throw new ParseException();
                }
                Date d1 = (Date)param1;
                Date d2 = (Date)param2;
                cal.setTimeInMillis(d1.getTime());
                int y1 = cal.get(1);
                int m1 = cal.get(2);
                int dt1 = cal.get(5);
                cal.setTimeInMillis(d2.getTime());
                int y2 = cal.get(1);
                int m2 = cal.get(2);
                int dt2 = cal.get(5);
                BigDecimal m = new BigDecimal((y1 - y2) * 12 + (m1 - m2));
                BigDecimal d = new BigDecimal(dt1 - dt2);
                d = d.divide(DAYS_IN_MONTH, 40, 4);
                return m.add(d);
            }
            throw new ParseException();
        }
        catch (ParseException e) {
            throw new ParseException("Wrong type  month_between(" + param1.getClass() + "," + param2.getClass() + ")");
        }
    }

    @Override
    public Comparable<?> getResult(Comparable<?> ... comparables) throws ParseException {
        return MonthsBetween.monthsBetween(comparables[0], comparables[1], JepRuntime.getCalendar());
    }
}

