/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.ASTFunNode;
import com.meidusa.amoeba.sqljep.JepRuntime;
import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.function.Comparative;
import com.meidusa.amoeba.sqljep.function.PostfixCommand;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Like
extends PostfixCommand {
    protected static final Integer ZERO_OR_MORE_CHARS = 0;
    protected static final Integer ONE_CHAR = 1;
    protected static Hashtable<String, Pattern> patterns = new Hashtable();

    @Override
    public final int getNumberOfParameters() {
        return 2;
    }

    @Override
    public Comparable<?>[] evaluate(ASTFunNode node, JepRuntime runtime) throws ParseException {
        node.childrenAccept(runtime.ev, null);
        Comparable param2 = runtime.stack.pop();
        Comparable param1 = runtime.stack.pop();
        return new Comparable[]{param1, param2};
    }

    public static boolean like(Comparable<?> param1, Comparable<?> param2) {
        if (param1 == null || param2 == null) {
            return false;
        }
        String source = param1.toString();
        String match = param2.toString();
        Pattern pattern = patterns.get(match);
        if (pattern == null) {
            ArrayList<Object> p = Like.compile(match);
            String regexp = Like.toRegExp(p);
            pattern = Pattern.compile(regexp);
            patterns.put(match, pattern);
        }
        Matcher m = pattern.matcher(source);
        return m.find();
    }

    protected static ArrayList<Object> compile(String pattern) {
        ArrayList<Object> format = new ArrayList<Object>();
        StringBuilder fill = new StringBuilder();
        int plen = pattern.length();
        Character lastSymbol = null;
        if (pattern.length() > 2 && pattern.charAt(0) == '/' && pattern.charAt(pattern.length() - 1) == '/') {
            format.add(pattern.substring(1, pattern.length() - 2));
        } else {
            for (int i = 0; i < plen; ++i) {
                char c = pattern.charAt(i);
                if (lastSymbol != null && lastSymbol.charValue() == '\\') {
                    lastSymbol = null;
                    fill.append(c);
                    continue;
                }
                if (c == '%') {
                    if (fill.length() > 0) {
                        format.add(fill.toString());
                        fill.setLength(0);
                    }
                    format.add(ZERO_OR_MORE_CHARS);
                } else if (c == '_') {
                    if (fill.length() > 0) {
                        format.add(fill.toString());
                        fill.setLength(0);
                    }
                    format.add(ONE_CHAR);
                } else {
                    fill.append(c);
                }
                lastSymbol = Character.valueOf(c);
            }
            if (fill.length() > 0) {
                format.add(fill.toString());
            }
        }
        return format;
    }

    public static String toRegExp(ArrayList<Object> pattern) {
        if (pattern != null) {
            StringBuilder str = new StringBuilder("^");
            for (Object o : pattern) {
                if (o == ZERO_OR_MORE_CHARS) {
                    str.append(".*?");
                    continue;
                }
                if (o == ONE_CHAR) {
                    str.append(".?");
                    continue;
                }
                str.append((String)o);
            }
            return str.toString();
        }
        return null;
    }

    public static String toString(ArrayList<Object> pattern) {
        if (pattern != null) {
            StringBuilder str = new StringBuilder();
            for (Object o : pattern) {
                if (o == ZERO_OR_MORE_CHARS) {
                    str.append('%');
                    continue;
                }
                if (o == ONE_CHAR) {
                    str.append('_');
                    continue;
                }
                str.append((String)o);
            }
            return str.toString();
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(Like.like("%asdf", "%asdf%"));
        Comparative one = new Comparative(4, (Comparable)((Object)"%abc"));
        Comparative two = new Comparative(4, (Comparable)((Object)"%bc"));
        System.out.println(Like.like(one, two));
    }

    @Override
    public Comparable<?> getResult(Comparable<?> ... comparables) throws ParseException {
        return Like.like(comparables[0], comparables[1]);
    }
}

