/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.ASTFunNode;
import com.meidusa.amoeba.sqljep.JepRuntime;
import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.function.PostfixCommand;

public class Instr
extends PostfixCommand {
    private static final String PARAM_EXCEPTION = "BeginIndex and Number in instr shoud be integers";
    private static final String OUT_OF_RANGE_EXCEPTION = "The fourth argument of instr is out of range";

    @Override
    public final int getNumberOfParameters() {
        return -1;
    }

    @Override
    public Comparable<?>[] evaluate(ASTFunNode node, JepRuntime runtime) throws ParseException {
        node.childrenAccept(runtime.ev, null);
        int num = node.jjtGetNumChildren();
        if (num == 2 || num == 3 || num == 4) {
            Comparable[] comparables = new Comparable[num];
            for (int i = num - 1; i <= 0; --i) {
                comparables[i] = runtime.stack.pop();
            }
            return comparables;
        }
        this.removeParams(runtime.stack, num);
        throw new ParseException("Wrong number of parameters for instr");
    }

    public static Integer instr(Comparable<?> param1, Comparable<?> param2) {
        if (param1 == null || param2 == null) {
            return null;
        }
        return new Integer(param1.toString().indexOf(param2.toString()) + 1);
    }

    public static Integer instr(Comparable<?> param1, Comparable<?> param2, Comparable<?> param3) throws ParseException {
        int beginIndex;
        if (param1 == null || param2 == null || param3 == null) {
            return null;
        }
        try {
            beginIndex = Instr.getInteger(param3) - 1;
        }
        catch (ParseException e) {
            throw new ParseException(PARAM_EXCEPTION);
        }
        String source = param1.toString();
        if (beginIndex < 0) {
            return new Integer(source.lastIndexOf(param2.toString(), beginIndex += source.length() + 1) + 1);
        }
        return new Integer(source.indexOf(param2.toString(), beginIndex) + 1);
    }

    public static Integer instr(Comparable<?> param1, Comparable<?> param2, Comparable<?> param3, Comparable<?> param4) throws ParseException {
        int number;
        int beginIndex;
        if (param1 == null || param2 == null || param3 == null || param4 == null) {
            return null;
        }
        String source = param1.toString();
        try {
            beginIndex = Instr.getInteger(param3) - 1;
        }
        catch (ParseException e) {
            throw new ParseException(PARAM_EXCEPTION);
        }
        if (number < 1) {
            throw new ParseException(OUT_OF_RANGE_EXCEPTION);
        }
        int i = 0;
        if (beginIndex < 0) {
            beginIndex += source.length() + 1;
            for (number = Instr.getInteger(param4); number > 0 && i >= 0; --number) {
                i = source.lastIndexOf(param2.toString(), beginIndex);
                beginIndex = i - 1;
            }
        } else {
            while (number > 0 && i >= 0) {
                i = source.indexOf(param2.toString(), beginIndex);
                beginIndex = i + 1;
                --number;
            }
        }
        return new Integer(i + 1);
    }

    @Override
    public Comparable<?> getResult(Comparable<?> ... comparables) throws ParseException {
        if (comparables.length == 2) {
            return Instr.instr(comparables[0], comparables[1]);
        }
        if (comparables.length == 3) {
            return Instr.instr(comparables[0], comparables[1], comparables[2]);
        }
        return Instr.instr(comparables[0], comparables[1], comparables[2], comparables[3]);
    }
}

