/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.function.Comparative;
import com.meidusa.amoeba.sqljep.function.Intersector;
import com.meidusa.amoeba.sqljep.function.PostfixCommand;
import java.math.BigDecimal;
import java.util.Comparator;

class ComparativeComparator
implements Comparator {
    protected static ComparativeComparator comparator = new ComparativeComparator();

    ComparativeComparator() {
    }

    public int compare(Object o1, Object o2) {
        try {
            return ComparativeComparator.compareTo((Comparable)o1, (Comparable)o2);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int compareTo(Comparable s1, Comparable s2) throws ParseException {
        Comparative comparative;
        if (s1 instanceof Comparative) {
            comparative = (Comparative)s1;
            s1 = comparative.getValue();
        }
        if (s2 instanceof Comparative) {
            comparative = (Comparative)s2;
            s2 = comparative.getValue();
        }
        if (s1 == null || s2 == null) {
            return -1;
        }
        if (s1.getClass() == s2.getClass() || s1.getClass().isAssignableFrom(s2.getClass()) || s2.getClass().isAssignableFrom(s1.getClass())) {
            return s1.compareTo(s2);
        }
        if (s2 instanceof Number && s1 instanceof String) {
            s1 = PostfixCommand.parse((String)((Object)s1));
        } else if (s1 instanceof Number && s2 instanceof String) {
            s2 = PostfixCommand.parse((String)((Object)s2));
        }
        if (s1 instanceof Number && s2 instanceof Number) {
            long anotherVal;
            Number n1 = (Number)((Object)s1);
            Number n2 = (Number)((Object)s2);
            if (n1 instanceof BigDecimal || n2 instanceof BigDecimal) {
                BigDecimal d1 = PostfixCommand.getBigDecimal(n1);
                BigDecimal d2 = PostfixCommand.getBigDecimal(n2);
                return d1.compareTo(d2);
            }
            if (n1 instanceof Double || n2 instanceof Double || n1 instanceof Float || n2 instanceof Float) {
                return Double.compare(n1.doubleValue(), n2.doubleValue());
            }
            long thisVal = n1.longValue();
            return thisVal < (anotherVal = n2.longValue()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
        throw new ParseException("Not comparable");
    }

    public static boolean intersect(Comparative param1, Comparative param2) {
        return param1.intersect(param2, comparator);
    }

    public static boolean intersect(Comparative param1, int function2, Comparable<?> comparable2) {
        return param1.intersect(function2, comparable2, comparator);
    }

    public static boolean intersect(int function1, Comparable<?> param1, int function2, Comparable<?> param2) {
        return Intersector.intersect(function1, param1, function2, param2, comparator);
    }

    public static boolean intersect(Comparable<?> param1, Comparable<?> param2) {
        int function1 = 3;
        int function2 = 3;
        return Intersector.intersect(function1, param1, function2, param2, comparator);
    }
}

