/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.function.Comparative;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class ComparativeBaseList
extends Comparative {
    protected List<Comparative> list = new ArrayList<Comparative>();

    public ComparativeBaseList(int function, Comparable<?> value) {
        super(function, value);
        this.list.add(new Comparative(function, value));
    }

    protected ComparativeBaseList() {
    }

    public ComparativeBaseList(Comparative item) {
        super(item.getComparison(), item.getValue());
        this.list.add(item);
    }

    public List<Comparative> getList() {
        return this.list;
    }

    public void addComparative(Comparative item) {
        this.list.add(item);
    }

    @Override
    public abstract boolean intersect(int var1, Comparable var2, Comparator var3);

    @Override
    public abstract boolean intersect(Comparative var1, Comparator var2);

    @Override
    public Object clone() {
        try {
            Constructor<?> con = this.getClass().getConstructor(null);
            ComparativeBaseList compList = (ComparativeBaseList)con.newInstance(null);
            for (Comparative com : this.list) {
                compList.addComparative((Comparative)com.clone());
            }
            compList.setComparison(this.getComparison());
            compList.setValue(this.getValue());
            return compList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        int index = 0;
        for (Comparative comp : this.list) {
            buffer.append(comp.toString());
            if (index < this.list.size() - 1) {
                buffer.append(",");
            }
            ++index;
        }
        buffer.append("]");
        return buffer.toString();
    }
}

