/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep.function;

import com.meidusa.amoeba.sqljep.ASTFunNode;
import com.meidusa.amoeba.sqljep.JepRuntime;
import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.function.PostfixCommand;
import java.math.BigDecimal;
import java.sql.Timestamp;

public final class Add
extends PostfixCommand {
    static final String DATE_ADDITION = "Wrong operation";
    static final BigDecimal DAY_MILIS = new BigDecimal(86400000);

    @Override
    public final int getNumberOfParameters() {
        return 2;
    }

    @Override
    public Comparable<?>[] evaluate(ASTFunNode node, JepRuntime runtime) throws ParseException {
        node.childrenAccept(runtime.ev, null);
        Comparable param2 = runtime.stack.pop();
        Comparable param1 = runtime.stack.pop();
        return new Comparable[]{param1, param2};
    }

    public static Comparable<?> add(Comparable<?> param1, Comparable<?> param2) throws ParseException {
        if (param1 == null || param2 == null) {
            return null;
        }
        if (param1 instanceof String) {
            param1 = Add.parse((String)((Object)param1));
        }
        if (param2 instanceof String) {
            param2 = Add.parse((String)((Object)param2));
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            long l2;
            long r;
            Number n1 = (Number)((Object)param1);
            Number n2 = (Number)((Object)param2);
            if (n1 instanceof BigDecimal || n2 instanceof BigDecimal) {
                BigDecimal b1 = Add.getBigDecimal(n1);
                BigDecimal b2 = Add.getBigDecimal(n2);
                return b1.add(b2);
            }
            if (n1 instanceof Double || n2 instanceof Double || n1 instanceof Float || n2 instanceof Float) {
                return n1.doubleValue() + n2.doubleValue();
            }
            long l1 = n1.longValue();
            if (l1 <= (r = l1 + (l2 = n2.longValue())) && l2 <= r) {
                return r;
            }
            BigDecimal b1 = new BigDecimal(l1);
            BigDecimal b2 = new BigDecimal(l2);
            return b1.add(b2);
        }
        if (param1 instanceof Timestamp || param2 instanceof Timestamp) {
            if (param1 instanceof Timestamp && param2 instanceof Timestamp) {
                throw new ParseException(DATE_ADDITION);
            }
            if (param1 instanceof Timestamp) {
                Timestamp d = (Timestamp)param1;
                if (!(param2 instanceof Number)) {
                    throw new ParseException(DATE_ADDITION);
                }
                Number n = (Number)((Object)param2);
                return new Timestamp(d.getTime() + Add.toDay(n));
            }
            if (param2 instanceof Timestamp) {
                Timestamp d = (Timestamp)param2;
                if (!(param1 instanceof Number)) {
                    throw new ParseException(DATE_ADDITION);
                }
                Number n = (Number)((Object)param1);
                return new Timestamp(d.getTime() + Add.toDay(n));
            }
            throw new ParseException("Internal error");
        }
        throw new ParseException("Wrong type  (" + param1.getClass() + "+" + param2.getClass() + ")");
    }

    static long toDay(Number n) {
        if (n instanceof BigDecimal) {
            BigDecimal dec = (BigDecimal)n;
            BigDecimal t = dec.multiply(DAY_MILIS);
            t = t.setScale(0, 4);
            return t.longValue();
        }
        return n.longValue() * 86400000L;
    }

    @Override
    public Comparable<?> getResult(Comparable<?> ... comparables) throws ParseException {
        return Add.add(comparables[0], comparables[1]);
    }
}

