/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.sqljep;

import com.meidusa.amoeba.sqljep.ASTArray;
import com.meidusa.amoeba.sqljep.ASTConstant;
import com.meidusa.amoeba.sqljep.ASTFunNode;
import com.meidusa.amoeba.sqljep.ASTStart;
import com.meidusa.amoeba.sqljep.ASTVarNode;
import com.meidusa.amoeba.sqljep.JepRuntime;
import com.meidusa.amoeba.sqljep.Node;
import com.meidusa.amoeba.sqljep.ParseException;
import com.meidusa.amoeba.sqljep.Parser;
import com.meidusa.amoeba.sqljep.ParserVisitor;
import com.meidusa.amoeba.sqljep.SimpleNode;
import com.meidusa.amoeba.sqljep.function.Comparative;
import com.meidusa.amoeba.sqljep.function.ComparativeBaseList;
import com.meidusa.amoeba.sqljep.function.Declare;
import com.meidusa.amoeba.sqljep.function.PostfixCommand;
import com.meidusa.amoeba.sqljep.function.PostfixCommandI;
import com.meidusa.amoeba.sqljep.variable.Variable;
import com.meidusa.amoeba.util.ThreadLocalMap;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BaseJEP
implements ParserVisitor {
    public static final boolean debug = false;
    protected final List<String> errorList = new ArrayList<String>();
    protected Node[] nodes;
    protected String expression;

    public BaseJEP(String exp) {
        if (exp == null) {
            throw new IllegalArgumentException("expression can be null");
        }
        this.expression = exp;
        this.nodes = null;
    }

    public void clear() {
        this.nodes = null;
        this.errorList.clear();
    }

    public boolean isValid() {
        return this.nodes != null;
    }

    public Node getTopNode() {
        return this.nodes[this.nodes.length - 1];
    }

    public abstract Comparable getColumnObject(int var1) throws ParseException;

    boolean hasError() {
        return !this.errorList.isEmpty();
    }

    String getErrorInfo() {
        if (this.hasError()) {
            String str = "";
            for (String err : this.errorList) {
                str = str + err + "\n";
            }
            return str;
        }
        return null;
    }

    public final void parseExpression(Map<String, Integer> columnMapping, Map<String, Variable> variableMapping, final Map<String, PostfixCommand> funMap) throws ParseException {
        StringReader reader = new StringReader(this.expression);
        Parser parser = new Parser(reader){

            @Override
            public boolean containsKey(String key) {
                return funMap.containsKey(key);
            }

            @Override
            public PostfixCommandI getFunction(String name) {
                return (PostfixCommandI)funMap.get(name);
            }
        };
        parser.setColumnMapping(columnMapping);
        parser.setVariableMapping(variableMapping);
        try {
            this.nodes = parser.parseStream(reader);
            this.errorList.clear();
            this.errorList.addAll(parser.getErrorList());
        }
        catch (ParseException e) {
            this.nodes = null;
            this.errorList.add(e.getMessage());
        }
        catch (Throwable e) {
            throw new ParseException(this.toString(), e);
        }
        if (this.hasError()) {
            throw new ParseException(this.getErrorInfo());
        }
    }

    public Comparable<?> getValue(Comparable<?>[] row) throws ParseException {
        JepRuntime runtime = BaseJEP.getThreadJepRuntime(this);
        runtime.row = row;
        for (Comparable comparable : runtime.row) {
            if (!(comparable instanceof ComparativeBaseList)) continue;
            runtime.isMultValue = true;
        }
        try {
            if (!this.isValid()) {
                throw new ParseException("Parser is not prepared");
            }
            if (!this.hasError()) {
                runtime.stack.setSize(0);
                for (Node node : this.nodes) {
                    node.jjtAccept(this, null);
                }
                if (runtime.stack.size() != 1) {
                    throw new ParseException("Wrong stack state. Stack size: " + runtime.stack.size());
                }
                Comparable comparable = runtime.stack.pop();
                return comparable;
            }
            throw new ParseException(this.getErrorInfo());
        }
        finally {
            runtime.vars.clear();
            runtime.stack.setSize(0);
            runtime.isMultValue = false;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseJEP) {
            BaseJEP f = (BaseJEP)obj;
            return this.expression.equals(f.expression);
        }
        return false;
    }

    public String toString() {
        return this.expression;
    }

    @Override
    public final Object visit(SimpleNode node, Object data) throws ParseException {
        return null;
    }

    @Override
    public final Object visit(ASTStart node, Object data) throws ParseException {
        return null;
    }

    @Override
    public final Object visit(ASTFunNode node, Object data) throws ParseException {
        JepRuntime runtime = BaseJEP.getThreadJepRuntime(this);
        PostfixCommandI pfmc = node.getPFMC();
        if (pfmc == null) {
            throw new ParseException("No function class associated with " + node.getName());
        }
        Comparable<?>[] parameters = pfmc.evaluate(node, runtime);
        if (pfmc.isAutoBox()) {
            int i;
            ComparativeBaseList list = null;
            int index = -1;
            for (i = 0; i < parameters.length; ++i) {
                if (!(parameters[i] instanceof ComparativeBaseList)) continue;
                index = i;
                list = (ComparativeBaseList)parameters[i];
                break;
            }
            if (index >= 0) {
                for (i = 0; i < parameters.length; ++i) {
                    if (i == index || !(parameters[i] instanceof Comparative)) continue;
                    parameters[i] = ((Comparative)parameters[i]).getValue();
                }
                for (Comparative comp : list.getList()) {
                    parameters[index] = comp.getValue();
                    Comparable<?> value = pfmc.getResult(parameters);
                    if (value instanceof Comparative) {
                        comp.setComparison(((Comparative)value).getComparison());
                        comp.setValue(((Comparative)value).getValue());
                        continue;
                    }
                    comp.setValue(value);
                }
                if (pfmc instanceof Declare) {
                    Declare declare = (Declare)((Object)pfmc);
                    declare.declare(runtime, list);
                } else {
                    runtime.stack.push(list);
                }
            } else {
                Comparative lastComparative = null;
                for (int i2 = 0; i2 < parameters.length; ++i2) {
                    if (!(parameters[i2] instanceof Comparative)) continue;
                    lastComparative = (Comparative)parameters[i2];
                    parameters[i2] = ((Comparative)parameters[i2]).getValue();
                }
                Comparative result = pfmc.getResult(parameters);
                if (lastComparative != null) {
                    lastComparative.setValue(result);
                    result = lastComparative;
                }
                if (pfmc instanceof Declare) {
                    Declare declare = (Declare)((Object)pfmc);
                    declare.declare(runtime, result);
                } else {
                    runtime.stack.push(result);
                }
            }
        } else if (pfmc instanceof Declare) {
            Declare declare = (Declare)((Object)pfmc);
            declare.declare(runtime, pfmc.getResult(parameters));
        } else {
            runtime.stack.push(pfmc.getResult(parameters));
        }
        return null;
    }

    @Override
    public final Object visit(ASTVarNode node, Object data) throws ParseException {
        JepRuntime runtime = BaseJEP.getThreadJepRuntime(this);
        if (node.index >= 0) {
            Comparable value = this.getColumnObject(node.index);
            if (value instanceof Comparative) {
                value = (Comparable)((Comparative)value).clone();
            }
            runtime.stack.push(value);
        } else if (node.variable == null) {
            Comparable<?> comparable = runtime.vars.get(node.ident);
            runtime.stack.push(comparable);
        } else {
            runtime.stack.push(node.variable.getValue());
        }
        return null;
    }

    @Override
    public final Object visit(ASTConstant node, Object data) throws ParseException {
        JepRuntime runtime = BaseJEP.getThreadJepRuntime(this);
        runtime.stack.push(node.value);
        return null;
    }

    @Override
    public final Object visit(ASTArray node, Object data) throws ParseException {
        node.childrenAccept(this, null);
        return null;
    }

    public static JepRuntime getThreadJepRuntime(BaseJEP baseJep) {
        JepRuntime runtime = (JepRuntime)ThreadLocalMap.get("JEP_RUNTIME");
        if (runtime == null) {
            runtime = new JepRuntime(baseJep);
            ThreadLocalMap.put("JEP_RUNTIME", runtime);
        } else {
            runtime.ev = baseJep;
        }
        return runtime;
    }
}

