/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.parser.statement;

import com.meidusa.amoeba.parser.dbobject.Column;
import com.meidusa.amoeba.parser.dbobject.Table;
import com.meidusa.amoeba.parser.expression.AndExpression;
import com.meidusa.amoeba.parser.expression.BaseExpressionList;
import com.meidusa.amoeba.parser.expression.ColumnExpression;
import com.meidusa.amoeba.parser.expression.Expression;
import com.meidusa.amoeba.parser.statement.AbstractStatement;
import com.meidusa.amoeba.sqljep.function.Comparative;
import com.meidusa.amoeba.sqljep.function.ComparativeAND;
import com.meidusa.amoeba.sqljep.function.ComparativeBaseList;
import com.meidusa.amoeba.sqljep.function.ComparativeOR;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class DMLStatement
extends AbstractStatement {
    private static Logger logger = Logger.getLogger(DMLStatement.class);
    protected boolean preparedStatment;
    protected Expression expression;
    private Map<Table, Map<Column, Comparative>> evaluatedTableMap;
    private Map<String, Column> selectColumnMap = new HashMap<String, Column>();
    protected String sql;

    public void setSql(String sql) {
        this.sql = sql;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public void addSelectColumn(String key, Column value) {
        this.selectColumnMap.put(key, value);
    }

    public Map<String, Column> getSelectColumnMap() {
        return this.selectColumnMap;
    }

    public abstract boolean isReadStatement();

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    public boolean isPreparedStatment() {
        return this.preparedStatment;
    }

    public void setPreparedStatment(boolean preparedStatment) {
        this.preparedStatment = preparedStatment;
    }

    public Map<Table, Map<Column, Comparative>> evaluate(Object[] parameters) {
        Map<Table, Map<Column, Comparative>> currentEvaluatedTableMap = null;
        if (this.evaluatedTableMap == null) {
            currentEvaluatedTableMap = new HashMap<Table, Map<Column, Comparative>>();
            if (this.expression != null) {
                DMLStatement.evaluateExpression(this.expression, currentEvaluatedTableMap, parameters);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("expression:[" + this.expression + "] evaluated"));
                }
            }
            for (Table table : this.getTables()) {
                if (currentEvaluatedTableMap.get(table) != null) continue;
                currentEvaluatedTableMap.put(table, null);
            }
            if (this.expression == null || !this.expression.isRealtime()) {
                this.evaluatedTableMap = currentEvaluatedTableMap;
            }
        } else {
            currentEvaluatedTableMap = this.evaluatedTableMap;
        }
        return currentEvaluatedTableMap;
    }

    protected static void evaluateExpression(Expression expression, Map<Table, Map<Column, Comparative>> tablesMap, Object[] parameters) {
        if (expression instanceof BaseExpressionList) {
            DMLStatement.evaluateExpression((BaseExpressionList)expression, tablesMap, parameters);
        } else if (expression instanceof ColumnExpression) {
            ColumnExpression colExpression = (ColumnExpression)expression;
            Table table = colExpression.getColumn().getTable();
            Map<Column, Comparative> columnMap = tablesMap.get(table);
            if (columnMap == null) {
                columnMap = new HashMap<Column, Comparative>();
                tablesMap.put(table, columnMap);
            }
            columnMap.put(colExpression.getColumn(), (Comparative)colExpression.evaluate(parameters));
        }
    }

    protected static void evaluateExpression(BaseExpressionList elist, Map<Table, Map<Column, Comparative>> tablesMap, Object[] parameters) {
        boolean and = false;
        if (elist instanceof AndExpression) {
            and = true;
        }
        List<Expression> blist = elist.getAllExpression();
        for (Expression e : blist) {
            if (e instanceof BaseExpressionList) {
                DMLStatement.evaluateExpression((BaseExpressionList)e, tablesMap, parameters);
                continue;
            }
            if (!(e instanceof ColumnExpression)) continue;
            ColumnExpression colExpression = (ColumnExpression)e;
            Table table = colExpression.getColumn().getTable();
            Map<Column, Comparative> columnMap = tablesMap.get(table);
            if (columnMap == null) {
                columnMap = new HashMap<Column, Comparative>();
                tablesMap.put(table, columnMap);
            }
            Comparative col = columnMap.get(colExpression.getColumn());
            Comparative newComparative = (Comparative)colExpression.evaluate(parameters);
            if (col != null) {
                if (col instanceof ComparativeBaseList) {
                    ComparativeBaseList source = (ComparativeBaseList)col;
                    if (source instanceof ComparativeAND && and || source instanceof ComparativeOR && !and) {
                        source.addComparative(newComparative);
                        continue;
                    }
                    ComparativeBaseList comparativeBaseList = null;
                    comparativeBaseList = and ? new ComparativeAND(col) : new ComparativeOR(col);
                    comparativeBaseList.addComparative(newComparative);
                    columnMap.put(colExpression.getColumn(), comparativeBaseList);
                    continue;
                }
                ComparativeBaseList comparativeBaseList = null;
                comparativeBaseList = and ? new ComparativeAND(col) : new ComparativeOR(col);
                comparativeBaseList.addComparative(newComparative);
                columnMap.put(colExpression.getColumn(), comparativeBaseList);
                continue;
            }
            columnMap.put(colExpression.getColumn(), newComparative);
        }
    }
}

