/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.parser.expression;

import com.meidusa.amoeba.parser.expression.Expression;
import com.meidusa.amoeba.parser.function.Function;
import com.meidusa.amoeba.parser.function.RealtimeCalculator;
import com.meidusa.amoeba.sqljep.ParseException;
import java.util.ArrayList;
import java.util.List;

public class FunctionExpression
extends Expression {
    private Function function;
    private List<Expression> argList = new ArrayList<Expression>();

    public List<Expression> getArgList() {
        return this.argList;
    }

    public void setArgList(List<Expression> argList) {
        this.argList = argList;
    }

    public void addArgExpression(Expression expression) {
        this.argList.add(expression);
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    @Override
    public boolean isRealtime() {
        boolean isRealTime = this.function instanceof RealtimeCalculator;
        if (isRealTime) {
            return true;
        }
        for (Expression e : this.argList) {
            if (!e.isRealtime()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Comparable evaluate(Object[] parameters) {
        try {
            return this.function.evaluate(this.argList, parameters);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Expression reverse() {
        return this;
    }

    @Override
    protected void toString(StringBuilder builder) {
        this.function.toString(this.argList, builder);
    }
}

