/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.parser.expression;

import com.meidusa.amoeba.parser.expression.Expression;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseExpressionList
extends Expression {
    protected List<Expression> eList = new ArrayList<Expression>();

    public BaseExpressionList() {
    }

    public BaseExpressionList(Expression expression) {
        if (expression != null) {
            this.addExpression(expression);
        }
    }

    public List<Expression> getAllExpression() {
        return this.eList;
    }

    @Override
    public boolean isRealtime() {
        for (Expression e : this.eList) {
            if (!e.isRealtime()) continue;
            return true;
        }
        return false;
    }

    protected abstract BaseExpressionList getReverseObject();

    @Override
    public Expression reverse() {
        BaseExpressionList list = this.getReverseObject();
        for (Expression e : this.eList) {
            Expression reversedExpression = e.reverse();
            list.addExpression(reversedExpression);
        }
        return list;
    }

    public void addExpression(Expression expression) {
        this.eList.add(expression);
    }

    public int getSize() {
        if (this.eList == null) {
            return 0;
        }
        return this.eList.size();
    }

    protected void toString(StringBuilder builder, String concatString) {
        int current = 0;
        if (this.eList.size() >= 2) {
            builder.append("(");
        }
        for (Expression e : this.eList) {
            e.toString(builder);
            if (++current == this.eList.size()) continue;
            builder.append(concatString);
        }
        if (this.eList.size() >= 2) {
            builder.append(")");
        }
    }
}

