/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.amoeba.mysql.parser.sql;

import com.meidusa.amoeba.mysql.parser.sql.JJTMysqlParserState;
import com.meidusa.amoeba.mysql.parser.sql.MysqlParserConstants;
import com.meidusa.amoeba.mysql.parser.sql.MysqlParserTokenManager;
import com.meidusa.amoeba.mysql.parser.sql.MysqlParserTreeConstants;
import com.meidusa.amoeba.mysql.parser.sql.Node;
import com.meidusa.amoeba.mysql.parser.sql.ParseException;
import com.meidusa.amoeba.mysql.parser.sql.SimpleCharStream;
import com.meidusa.amoeba.mysql.parser.sql.Token;
import com.meidusa.amoeba.parser.Parser;
import com.meidusa.amoeba.parser.dbobject.Column;
import com.meidusa.amoeba.parser.dbobject.Schema;
import com.meidusa.amoeba.parser.dbobject.Table;
import com.meidusa.amoeba.parser.expression.AndExpression;
import com.meidusa.amoeba.parser.expression.BaseExpressionList;
import com.meidusa.amoeba.parser.expression.ColumnExpression;
import com.meidusa.amoeba.parser.expression.ComparisonExpression;
import com.meidusa.amoeba.parser.expression.ConstantExpression;
import com.meidusa.amoeba.parser.expression.Expression;
import com.meidusa.amoeba.parser.expression.FunctionExpression;
import com.meidusa.amoeba.parser.expression.OrExpression;
import com.meidusa.amoeba.parser.expression.ParameterExpression;
import com.meidusa.amoeba.parser.function.Function;
import com.meidusa.amoeba.parser.function.ThreadLocalSettingFunction;
import com.meidusa.amoeba.parser.function.TimeConverter;
import com.meidusa.amoeba.parser.statement.AbstractStatement;
import com.meidusa.amoeba.parser.statement.CommitStatement;
import com.meidusa.amoeba.parser.statement.DMLStatement;
import com.meidusa.amoeba.parser.statement.DeleteStatement;
import com.meidusa.amoeba.parser.statement.InsertStatement;
import com.meidusa.amoeba.parser.statement.PropertyStatement;
import com.meidusa.amoeba.parser.statement.RollbackStatement;
import com.meidusa.amoeba.parser.statement.SelectStatement;
import com.meidusa.amoeba.parser.statement.ShowStatement;
import com.meidusa.amoeba.parser.statement.StartTansactionStatement;
import com.meidusa.amoeba.parser.statement.Statement;
import com.meidusa.amoeba.parser.statement.UpdateStatement;
import com.meidusa.amoeba.sqljep.function.Comparative;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class MysqlParser
implements MysqlParserTreeConstants,
Parser,
MysqlParserConstants {
    protected JJTMysqlParserState jjtree = new JJTMysqlParserState();
    private static final String metachars = "tnrbf\\\"";
    private static final String chars = "\t\n\r\b\f\\\"";
    private int parameterIndex = 0;
    private Map<String, Table> tableAliasMap = new HashMap<String, Table>();
    private Stack<Table> tableStack = new Stack();
    private Statement statement;
    private Schema defaultSchema;
    private Map<String, Function> functionMap;
    private static TimeConverter timeConverter = new TimeConverter();
    public MysqlParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[166];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private final JJCalls[] jj_2_rtns = new JJCalls[28];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    @Override
    public void setFunctionMap(Map<String, Function> map) {
        this.functionMap = map;
    }

    @Override
    public void setDefaultSchema(Schema schema) {
        this.defaultSchema = schema;
    }

    public static void main(String[] args) throws com.meidusa.amoeba.parser.ParseException {
        MysqlParser p = null;
        if (args.length < 1) {
            System.out.println("Reading from stdin");
            p = new MysqlParser(System.in);
        } else {
            try {
                p = new MysqlParser(new DataInputStream(new FileInputStream(args[0])));
            }
            catch (FileNotFoundException e) {
                System.out.println("File " + args[0] + " not found. Reading from stdin");
                p = new MysqlParser(System.in);
            }
        }
        if (args.length > 0) {
            System.out.println(args[0]);
        }
        Statement statement = p.doParse();
        System.out.println(statement.getExpression());
    }

    void jjtreeOpenNodeScope(Node n) {
    }

    void jjtreeCloseNodeScope(Node n) {
    }

    Function getFunction(String indent) {
        if (this.functionMap == null) {
            return null;
        }
        Function function = this.functionMap.get(indent);
        if (function instanceof ThreadLocalSettingFunction) {
            ((ThreadLocalSettingFunction)((Object)function)).invoke();
        }
        return function;
    }

    @Override
    public Statement doParse() throws com.meidusa.amoeba.parser.ParseException {
        try {
            Statement statement = this.parse();
            if (statement != null) {
                statement.setParameterCount(this.parameterIndex);
            }
            return statement;
        }
        catch (Exception e) {
            throw new com.meidusa.amoeba.parser.ParseException(e);
        }
    }

    public Statement getParsedStatement() {
        return this.statement;
    }

    private Expression reverseExpression(boolean not, Expression expression) {
        if (not) {
            if (expression != null) {
                return expression.reverse();
            }
            return null;
        }
        return expression;
    }

    private static String replaceEscape(String inputStr) {
        int i;
        int len = inputStr.length();
        int p = 0;
        StringBuilder output = new StringBuilder();
        while ((i = inputStr.indexOf(92, p)) != -1) {
            output.append(inputStr.substring(p, i));
            if (i + 1 == len) break;
            char metac = inputStr.charAt(i + 1);
            int k = metachars.indexOf(metac);
            if (k == -1) {
                output.append('\\');
                output.append(metac);
            } else {
                output.append(chars.charAt(k));
            }
            p = i + 2;
        }
        if (p < len) {
            output.append(inputStr.substring(p));
        }
        return output.toString();
    }

    public final Statement parse() throws ParseException {
        Object expression = null;
        Statement statement = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                statement = this.DeleteQuery();
                break;
            }
            case 42: 
            case 43: {
                statement = this.InsertQuery();
                break;
            }
            case 73: 
            case 139: {
                statement = this.SelectQuery();
                break;
            }
            case 84: {
                statement = this.UpdateQuery();
                break;
            }
            case 77: 
            case 108: {
                statement = this.ShowQuery();
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                statement = this.PropertySetQuery(new PropertyStatement());
                break;
            }
            case 85: {
                statement = this.SelectSchema();
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                statement = new CommitStatement();
                break;
            }
            case 107: {
                this.jj_consume_token(107);
                statement = new RollbackStatement();
                break;
            }
            case 114: {
                this.jj_consume_token(114);
                statement = new StartTansactionStatement();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 109: 
            case 110: 
            case 171: {
                this.INDEX();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 135: {
                this.jj_consume_token(135);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (statement instanceof AbstractStatement) {
            ArrayList<Table> list = new ArrayList<Table>();
            for (Map.Entry<String, Table> entry : this.tableAliasMap.entrySet()) {
                if (list.contains(entry.getValue())) continue;
                list.add(entry.getValue());
            }
            Table[] tables = new Table[list.size()];
            list.toArray(tables);
            ((AbstractStatement)statement).setTables(tables);
        }
        return statement;
    }

    public final Statement SelectSchema() throws ParseException {
        Token t = null;
        String schema = null;
        this.jj_consume_token(85);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 131: {
                this.token = this.jj_consume_token(131);
                schema = t.image.substring(1, t.image.length() - 1);
                break;
            }
            case 132: {
                t = this.jj_consume_token(132);
                schema = t.image.substring(1, t.image.length() - 1);
                break;
            }
            case 133: {
                t = this.jj_consume_token(133);
                schema = t.image.substring(1, t.image.length() - 1);
                break;
            }
            case 128: {
                t = this.jj_consume_token(128);
                schema = t.image;
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PropertyStatement statement = new PropertyStatement();
        statement.addProperty("schema", new ConstantExpression((Comparable)((Object)schema)));
        return statement;
    }

    public final Statement PropertySetQuery(PropertyStatement statement) throws ParseException {
        Object expression = null;
        Token name = null;
        Token valueToken = null;
        Object value = null;
        String propertyName = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 70: 
            case 115: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 115: {
                        this.jj_consume_token(115);
                        break block0;
                    }
                    case 70: {
                        this.jj_consume_token(70);
                        break block0;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 111: {
                this.jj_consume_token(111);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 116: {
                        this.jj_consume_token(116);
                        value = 2;
                        break;
                    }
                    case 117: {
                        this.jj_consume_token(117);
                        value = 1;
                        break;
                    }
                    case 119: {
                        this.jj_consume_token(119);
                        value = 8;
                        break;
                    }
                    case 118: {
                        this.jj_consume_token(118);
                        value = 4;
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                propertyName = "TRANSACTIONISOLATION";
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                propertyName = "charset";
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 128: {
                        valueToken = this.jj_consume_token(128);
                        value = valueToken.image;
                        break block7;
                    }
                    case 131: {
                        valueToken = this.jj_consume_token(131);
                        value = valueToken.image.substring(1, valueToken.image.length() - 1);
                        break block7;
                    }
                    case 132: {
                        valueToken = this.jj_consume_token(132);
                        value = valueToken.image;
                        break block7;
                    }
                }
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 128: {
                name = this.jj_consume_token(128);
                propertyName = name.image;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 136: {
                        this.jj_consume_token(136);
                        name = this.jj_consume_token(128);
                        propertyName = propertyName + "." + name.image;
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 137: {
                        this.jj_consume_token(137);
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 54: {
                        valueToken = this.jj_consume_token(54);
                        value = "null";
                        break block7;
                    }
                    case 94: {
                        valueToken = this.jj_consume_token(94);
                        value = Boolean.TRUE;
                        break block7;
                    }
                    case 95: {
                        valueToken = this.jj_consume_token(95);
                        value = Boolean.FALSE;
                        break block7;
                    }
                    case 128: {
                        valueToken = this.jj_consume_token(128);
                        value = valueToken.image;
                        break block7;
                    }
                    case 121: {
                        valueToken = this.jj_consume_token(121);
                        value = Long.valueOf(valueToken.image);
                        break block7;
                    }
                    case 131: {
                        valueToken = this.jj_consume_token(131);
                        value = valueToken.image.substring(1, valueToken.image.length() - 1);
                        break block7;
                    }
                    case 132: {
                        valueToken = this.jj_consume_token(132);
                        value = valueToken.image;
                        break block7;
                    }
                }
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 138: {
                this.jj_consume_token(138);
                this.PropertySetQuery(statement);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        if (value != null) {
            ConstantExpression consExp = new ConstantExpression((Comparable)value);
            statement.addProperty(propertyName, consExp);
        }
        return statement;
    }

    public final Statement UpdateQuery() throws ParseException {
        Expression expression = null;
        Table table = null;
        BaseExpressionList andExpression = new AndExpression();
        UpdateStatement statement = new UpdateStatement();
        table = this.UpdateStatement(statement);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 91: {
                expression = this.WhereClause(statement);
                if (expression instanceof BaseExpressionList) {
                    BaseExpressionList list = (BaseExpressionList)expression;
                    andExpression = (BaseExpressionList)expression;
                    break;
                }
                if (expression == null) break;
                andExpression.addExpression(expression);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: {
                this.jj_consume_token(96);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 134: {
                        this.jj_consume_token(134);
                        andExpression.addExpression(new ParameterExpression(this.parameterIndex++));
                        break;
                    }
                    case 121: {
                        this.jj_consume_token(121);
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 71: 
                    case 138: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 138: {
                                this.jj_consume_token(138);
                                break;
                            }
                            case 71: {
                                this.jj_consume_token(71);
                                break;
                            }
                            default: {
                                this.jj_la1[16] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 134: {
                                this.jj_consume_token(134);
                                andExpression.addExpression(new ParameterExpression(this.parameterIndex++));
                                break block3;
                            }
                            case 121: {
                                this.jj_consume_token(121);
                                break block3;
                            }
                        }
                        this.jj_la1[17] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        if (andExpression.getSize() > 0) {
            statement.setExpression(andExpression);
        }
        return statement;
    }

    public final Statement ShowQuery() throws ParseException {
        ShowStatement statement = new ShowStatement();
        Expression expression = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 77: {
                this.jj_consume_token(77);
                break;
            }
            case 108: {
                this.jj_consume_token(108);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.FromItem(statement);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 91: {
                expression = this.WhereClause(statement);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        statement.setExpression(expression);
        return statement;
    }

    public final Table UpdateStatement(Statement statement) throws ParseException {
        Table table = null;
        this.jj_consume_token(84);
        table = this.TableReference();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 138: {
                this.jj_consume_token(138);
                this.TableReference();
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        this.jj_consume_token(74);
        this.AssignmentClause(statement);
        return table;
    }

    public final Expression AssignmentClause(Statement statement) throws ParseException {
        Expression expression = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 128: 
            case 132: 
            case 133: 
            case 141: {
                expression = this.ColumnValues(statement);
                break;
            }
            case 139: {
                this.jj_consume_token(139);
                this.UpdateColumn();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 138: {
                            break;
                        }
                        default: {
                            this.jj_la1[23] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(138);
                    this.UpdateColumn();
                }
                this.jj_consume_token(140);
                this.jj_consume_token(137);
                this.jj_consume_token(139);
                if (this.jj_2_1(2)) {
                    this.UpdateValues(statement);
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 73: 
                        case 139: {
                            this.FullSelectStatement(statement);
                            break;
                        }
                        default: {
                            this.jj_la1[24] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                this.jj_consume_token(140);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final void UpdateColumn() throws ParseException {
        this.ColumnName();
    }

    public final List<Expression> UpdateValues(Statement statement) throws ParseException {
        Expression expression = null;
        ArrayList<Expression> list = new ArrayList<Expression>();
        expression = this.UpdateValue(statement);
        list.add(expression);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(138);
            expression = this.UpdateValue(statement);
            list.add(expression);
        }
        return list;
    }

    public final Expression UpdateValue(Statement statement) throws ParseException {
        Expression expression = null;
        expression = this.SQLSimpleExpression(statement);
        return expression;
    }

    public final Statement DeleteQuery() throws ParseException {
        Expression expression = null;
        Table table = null;
        DeleteStatement statement = new DeleteStatement();
        AndExpression andExpression = new AndExpression();
        table = this.DeleteStatement();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 91: {
                expression = this.WhereClause(statement);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        if (expression != null) {
            andExpression.addExpression(expression);
        }
        statement.setExpression(expression);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                this.OrderByClause(statement);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: {
                this.jj_consume_token(96);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 134: {
                        this.jj_consume_token(134);
                        andExpression.addExpression(new ParameterExpression(this.parameterIndex++));
                        break;
                    }
                    case 121: {
                        this.jj_consume_token(121);
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 71: 
                    case 138: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 138: {
                                this.jj_consume_token(138);
                                break;
                            }
                            case 71: {
                                this.jj_consume_token(71);
                                break;
                            }
                            default: {
                                this.jj_la1[30] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 134: {
                                this.jj_consume_token(134);
                                andExpression.addExpression(new ParameterExpression(this.parameterIndex++));
                                break block6;
                            }
                            case 121: {
                                this.jj_consume_token(121);
                                break block6;
                            }
                        }
                        this.jj_la1[31] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[32] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
            }
        }
        return statement;
    }

    public final Table DeleteStatement() throws ParseException {
        Table table = null;
        this.jj_consume_token(19);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
        table = this.TableReference();
        return table;
    }

    public final Statement InsertQuery() throws ParseException {
        Table table = null;
        InsertStatement statement = new InsertStatement();
        Expression expression = null;
        List<Column> insertColumns = null;
        List<List<Expression>> insertValues = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        table = this.TableName();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: 
            case 87: 
            case 139: {
                if (this.jj_2_2(4)) {
                    this.jj_consume_token(139);
                    insertColumns = this.InsertColumns();
                    this.jj_consume_token(140);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 87: {
                        insertValues = this.InsertValues(statement);
                        break;
                    }
                    case 73: 
                    case 139: {
                        expression = this.FullSelectStatement(statement);
                        break;
                    }
                    default: {
                        this.jj_la1[37] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (insertValues == null || insertValues.size() == 0) {
                    statement.setExpression(expression);
                    break;
                }
                if (insertColumns == null) break;
                AndExpression andExpression = new AndExpression();
                int index = 0;
                for (Column column : insertColumns) {
                    Expression insertExpression = null;
                    if (insertValues.size() > 1) {
                        insertExpression = new OrExpression();
                        for (List<Expression> rowExpression : insertValues) {
                            ColumnExpression colExpression = new ColumnExpression();
                            colExpression.setColumn(column);
                            ComparisonExpression compExp = new ComparisonExpression();
                            compExp.setComparison(3);
                            compExp.setExpression(rowExpression.get(index));
                            colExpression.setExpression(compExp);
                            ((BaseExpressionList)insertExpression).addExpression(colExpression);
                        }
                    } else {
                        ColumnExpression colExpression = new ColumnExpression();
                        colExpression.setColumn(column);
                        ComparisonExpression compExp = new ComparisonExpression();
                        compExp.setComparison(3);
                        compExp.setExpression(insertValues.get(0).get(index));
                        colExpression.setExpression(compExp);
                        insertExpression = colExpression;
                    }
                    andExpression.addExpression(insertExpression);
                    ++index;
                }
                statement.setExpression(andExpression);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                expression = this.AssignmentClause(statement);
                statement.setExpression(expression);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                this.jj_consume_token(112);
                this.jj_consume_token(113);
                this.jj_consume_token(84);
                this.AssignmentClause(statement);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        return statement;
    }

    public final List<Column> InsertColumns() throws ParseException {
        ArrayList<Column> insertColumns = new ArrayList<Column>();
        Column column = null;
        column = this.InsertColumn();
        insertColumns.add(column);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(138);
            column = this.InsertColumn();
            insertColumns.add(column);
        }
        return insertColumns;
    }

    public final Column InsertColumn() throws ParseException {
        Column column = null;
        column = this.ColumnName();
        return column;
    }

    public final List<List<Expression>> InsertValues(Statement statement) throws ParseException {
        ArrayList<List<Expression>> insertValues = new ArrayList<List<Expression>>();
        List<Expression> singleExpressionList = null;
        Object expression = null;
        this.jj_consume_token(87);
        singleExpressionList = this.InsertSingleRowValues(statement);
        if (singleExpressionList != null) {
            insertValues.add(singleExpressionList);
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: 
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    break block6;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    this.jj_consume_token(138);
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                }
            }
            if ((singleExpressionList = this.InsertSingleRowValues(statement)) == null) continue;
            insertValues.add(singleExpressionList);
        }
        return insertValues;
    }

    public final List<Expression> InsertSingleRowValues(Statement statement) throws ParseException {
        ArrayList<Expression> insertValues = new ArrayList<Expression>();
        Expression expression = null;
        this.jj_consume_token(139);
        expression = this.InsertValue(statement);
        if (expression != null) {
            insertValues.add(expression);
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(138);
            expression = this.InsertValue(statement);
            if (expression == null) continue;
            insertValues.add(expression);
        }
        this.jj_consume_token(140);
        if (insertValues.size() > 0) {
            return insertValues;
        }
        return null;
    }

    public final Expression InsertValue(Statement statement) throws ParseException {
        Expression expression = null;
        expression = this.SQLSimpleExpression(statement);
        return expression;
    }

    public final Statement SelectQuery() throws ParseException {
        Expression expression = null;
        SelectStatement statement = new SelectStatement();
        expression = this.FullSelectStatement(statement);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: 
                case 31: 
                case 66: 
                case 67: 
                case 93: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block3;
                }
            }
            this.ExtraClauses(statement);
        }
        statement.setExpression(expression);
        return statement;
    }

    public final Expression ColumnValues(Statement statement) throws ParseException {
        Expression expression = null;
        AndExpression andExpression = new AndExpression();
        expression = this.ColumnValue(statement);
        if (expression != null) {
            andExpression.addExpression(expression);
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(138);
            expression = this.ColumnValue(statement);
            if (expression == null) continue;
            andExpression.addExpression(expression);
        }
        return andExpression;
    }

    public final Expression ColumnValue(Statement statement) throws ParseException {
        ColumnExpression colExpression = new ColumnExpression();
        Expression expression = null;
        Column column = null;
        column = this.ColumnName();
        this.jj_consume_token(137);
        expression = this.UpdatedValue(statement);
        if (expression == null) {
            return null;
        }
        colExpression.setColumn(column);
        ComparisonExpression compExp = new ComparisonExpression();
        compExp.setComparison(3);
        compExp.setExpression(expression);
        colExpression.setExpression(compExp);
        return colExpression;
    }

    public final Expression UpdatedValue(Statement statement) throws ParseException {
        Expression expression = null;
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            this.jj_consume_token(139);
            expression = this.SubSelectStatement(statement);
            this.jj_consume_token(140);
        } else if (this.jj_2_4(1)) {
            expression = this.SQLSimpleExpression(statement);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expression;
    }

    public final ComparisonExpression IsNullClause(Statement statement) throws ParseException {
        int comparison = 3;
        this.jj_consume_token(38);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 52: {
                this.jj_consume_token(52);
                comparison = 6;
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
            }
        }
        this.jj_consume_token(54);
        ComparisonExpression comparativeExpression = new ComparisonExpression();
        comparativeExpression.setComparison(comparison);
        comparativeExpression.setExpression(new ConstantExpression(null));
        return comparativeExpression;
    }

    public final Column ColumnName() throws ParseException {
        String schemaName = null;
        String tableName = null;
        String columnName = null;
        Column column = new Column();
        Table table = null;
        schemaName = this.EntityName();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 136: {
                this.jj_consume_token(136);
                tableName = this.EntityName();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 136: {
                        this.jj_consume_token(136);
                        columnName = this.EntityName();
                        break block0;
                    }
                }
                this.jj_la1[47] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
            }
        }
        if (tableName == null) {
            columnName = schemaName;
            schemaName = null;
            if (this.tableStack.size() > 0) {
                table = this.tableStack.peek();
            }
        } else if (columnName == null) {
            columnName = tableName;
            tableName = schemaName;
            schemaName = null;
            table = this.tableAliasMap.get(tableName);
        }
        column.setTable(table);
        column.setName(columnName);
        return column;
    }

    public final String EntityName() throws ParseException {
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 128: 
            case 141: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 141: {
                        this.jj_consume_token(141);
                        break;
                    }
                    default: {
                        this.jj_la1[49] = this.jj_gen;
                    }
                }
                token = this.jj_consume_token(128);
                return token.image;
            }
            case 132: {
                token = this.jj_consume_token(132);
                return token.image.substring(1, token.image.length() - 1);
            }
            case 133: {
                token = this.jj_consume_token(133);
                return token.image.substring(1, token.image.length() - 1);
            }
        }
        this.jj_la1[51] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String Relop() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 137: {
                token = this.jj_consume_token(137);
                break;
            }
            case 142: {
                token = this.jj_consume_token(142);
                break;
            }
            case 143: {
                token = this.jj_consume_token(143);
                break;
            }
            case 144: {
                token = this.jj_consume_token(144);
                break;
            }
            case 145: {
                token = this.jj_consume_token(145);
                break;
            }
            case 146: {
                token = this.jj_consume_token(146);
                break;
            }
            case 147: {
                token = this.jj_consume_token(147);
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token.image;
    }

    public final Table TableName() throws ParseException {
        String schemaName = null;
        String tableName = null;
        Table table = null;
        Schema schema = null;
        schemaName = this.EntityName();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 136: {
                this.jj_consume_token(136);
                tableName = this.EntityName();
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
            }
        }
        if (tableName == null) {
            tableName = schemaName;
            schemaName = null;
        }
        table = new Table();
        table.setName(tableName);
        if (schemaName != null) {
            schema = new Schema();
            schema.setName(schemaName);
            table.setSchema(schema);
        } else {
            table.setSchema(this.defaultSchema);
        }
        this.tableAliasMap.put(table.getName(), table);
        this.tableStack.push(table);
        return table;
    }

    public final Table TableReference() throws ParseException {
        Table table = null;
        Token token = null;
        table = this.TableName();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 128: 
            case 133: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        this.jj_consume_token(9);
                        break;
                    }
                    default: {
                        this.jj_la1[54] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 133: {
                        token = this.jj_consume_token(133);
                        table.setAlias(token.image.substring(1, token.image.length() - 1));
                        break block0;
                    }
                    case 128: {
                        token = this.jj_consume_token(128);
                        table.setAlias(token.image);
                        break block0;
                    }
                }
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 109: 
            case 110: 
            case 171: {
                this.INDEX();
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
        if (table.getAlias() != null) {
            this.tableAliasMap.put(table.getAlias(), table);
        }
        this.tableAliasMap.put(table.toString(), table);
        return table;
    }

    public final void CaseStatement(Statement statement) throws ParseException {
        this.jj_consume_token(13);
        if (this.jj_2_5(1)) {
            this.SQLSimpleExpression(statement);
        }
        this.WhenStatement(statement);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 90: {
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    break block6;
                }
            }
            this.WhenStatement(statement);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                this.ElseStatement(statement);
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
            }
        }
        this.jj_consume_token(26);
    }

    public final void WhenStatement(Statement statement) throws ParseException {
        this.jj_consume_token(90);
        this.SQLExpression(statement);
        this.jj_consume_token(80);
        this.SQLSimpleExpression(statement);
    }

    public final void ElseStatement(Statement statement) throws ParseException {
        this.jj_consume_token(24);
        this.SQLSimpleExpression(statement);
    }

    public final void ExtraClauses(Statement statement) throws ParseException {
        if (this.jj_2_6(2)) {
            this.ForUpdateClause();
        } else if (this.jj_2_7(2)) {
            this.ReadOnlyClause();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 67: {
                    this.OptimizeForClause();
                    break;
                }
                case 93: {
                    this.WithClause();
                    break;
                }
                case 66: {
                    this.QuerynoClause();
                    break;
                }
                case 29: {
                    this.FetchFirstClause();
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final Expression FullSelectStatement(Statement statement) throws ParseException {
        Expression expression = null;
        Expression unionedExpression = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: {
                expression = this.SubSelectStatement(statement);
                break;
            }
            case 139: {
                this.jj_consume_token(139);
                expression = this.FullSelectStatement(statement);
                this.jj_consume_token(140);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 82: {
                        this.UnionClause();
                        unionedExpression = this.FullSelectStatement(statement);
                        break block0;
                    }
                }
                this.jj_la1[61] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (unionedExpression != null) {
            if (expression == null) {
                return unionedExpression;
            }
            expression = new OrExpression(expression);
            ((OrExpression)expression).addExpression(unionedExpression);
            return expression;
        }
        return expression;
    }

    public final void UnionClause() throws ParseException {
        this.jj_consume_token(82);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
            }
        }
    }

    public final Expression SubSelectStatement(Statement statement) throws ParseException {
        Expression expression = null;
        Expression fromExpression = null;
        AndExpression andExpression = new AndExpression();
        this.SelectClause(statement);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                fromExpression = this.FromClause(statement);
                if (fromExpression == null) break;
                andExpression.addExpression(fromExpression);
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 91: {
                expression = this.WhereClause(statement);
                if (expression == null) break;
                andExpression.addExpression(expression);
                break;
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.GroupByClause(statement);
                break;
            }
            default: {
                this.jj_la1[66] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                this.OrderByClause(statement);
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
            }
        }
        block12 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: {
                this.jj_consume_token(96);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 134: {
                        this.jj_consume_token(134);
                        andExpression.addExpression(new ParameterExpression(this.parameterIndex++));
                        break;
                    }
                    case 121: {
                        this.jj_consume_token(121);
                        break;
                    }
                    default: {
                        this.jj_la1[68] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 71: 
                    case 138: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 138: {
                                this.jj_consume_token(138);
                                break;
                            }
                            case 71: {
                                this.jj_consume_token(71);
                                break;
                            }
                            default: {
                                this.jj_la1[69] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 134: {
                                this.jj_consume_token(134);
                                andExpression.addExpression(new ParameterExpression(this.parameterIndex++));
                                break block12;
                            }
                            case 121: {
                                this.jj_consume_token(121);
                                break block12;
                            }
                        }
                        this.jj_la1[70] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[71] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[72] = this.jj_gen;
            }
        }
        if (andExpression.getSize() > 0) {
            return andExpression;
        }
        return null;
    }

    public final void SelectClause(Statement statement) throws ParseException {
        this.jj_consume_token(73);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 125: {
                this.jj_consume_token(125);
                break;
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 20: 
            case 148: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        this.jj_consume_token(6);
                        break block3;
                    }
                    case 20: {
                        this.jj_consume_token(20);
                        break block3;
                    }
                    case 148: {
                        this.jj_consume_token(148);
                        break block3;
                    }
                }
                this.jj_la1[74] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 149: {
                this.jj_consume_token(149);
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 150: {
                this.jj_consume_token(150);
                break;
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 151: {
                this.jj_consume_token(151);
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 152: {
                this.jj_consume_token(152);
                break;
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 153: {
                this.jj_consume_token(153);
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
            }
        }
        block26 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 154: 
            case 155: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 154: {
                        this.jj_consume_token(154);
                        break block26;
                    }
                    case 155: {
                        this.jj_consume_token(155);
                        break block26;
                    }
                }
                this.jj_la1[81] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[82] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 156: {
                this.jj_consume_token(156);
                break;
            }
            default: {
                this.jj_la1[83] = this.jj_gen;
            }
        }
        this.SelectList(statement);
    }

    public final void SelectList(Statement statement) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 157: {
                this.jj_consume_token(157);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 138: {
                            break;
                        }
                        default: {
                            this.jj_la1[84] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(138);
                    this.SelectItem(statement);
                }
            }
            default: {
                this.jj_la1[86] = this.jj_gen;
                if (this.jj_2_8(1)) {
                    this.SelectItem(statement);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 138: {
                                break;
                            }
                            default: {
                                this.jj_la1[85] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_consume_token(138);
                        this.SelectItem(statement);
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void SelectItem(Statement statement) throws ParseException {
        Token token = null;
        Expression expression = null;
        Column column = null;
        if (this.jj_2_9(2)) {
            this.EntityName();
            this.jj_consume_token(158);
        } else if (this.jj_2_10(4)) {
            this.EntityName();
            this.jj_consume_token(136);
            this.EntityName();
            this.jj_consume_token(158);
        } else if (this.jj_2_11(1)) {
            expression = this.SQLSimpleExpression(statement);
            if (expression instanceof ColumnExpression) {
                column = ((ColumnExpression)expression).getColumn();
                ((DMLStatement)statement).addSelectColumn(column.getName(), column);
            } else if (expression instanceof FunctionExpression) {
                String columnName = ((FunctionExpression)expression).getFunction().getName();
                column = new Column();
                column.setName(columnName);
                ((DMLStatement)statement).addSelectColumn(columnName, column);
            }
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 137: {
                this.jj_consume_token(137);
                this.SQLSimpleExpression(statement);
                break;
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 128: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        this.jj_consume_token(9);
                        break;
                    }
                    default: {
                        this.jj_la1[88] = this.jj_gen;
                    }
                }
                token = this.jj_consume_token(128);
                if (token == null || column == null) break;
                column.setAlias(token.image);
                break;
            }
            default: {
                this.jj_la1[89] = this.jj_gen;
            }
        }
    }

    public final Expression FromClause(Statement statement) throws ParseException {
        Expression expression = null;
        Expression andExpression = null;
        Expression currentExpression = null;
        this.jj_consume_token(32);
        expression = currentExpression = this.FromItem(statement);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(138);
            currentExpression = this.FromItem(statement);
            if (currentExpression == null) continue;
            if (andExpression == null) {
                andExpression = new AndExpression();
            }
            ((BaseExpressionList)andExpression).addExpression(currentExpression);
        }
        if (andExpression != null && expression != null) {
            ((BaseExpressionList)andExpression).addExpression(expression);
            return andExpression;
        }
        return expression == null ? andExpression : expression;
    }

    public final Expression FromItem(Statement statement) throws ParseException {
        Expression expression = null;
        BaseExpressionList andExpression = null;
        Expression currentExpression = null;
        expression = this.TableSpec(statement);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: 
                case 46: 
                case 47: 
                case 97: 
                case 159: 
                case 160: {
                    break;
                }
                default: {
                    this.jj_la1[91] = this.jj_gen;
                    break block3;
                }
            }
            currentExpression = this.JoinedTable(statement);
            if (currentExpression == null) continue;
            if (andExpression == null) {
                andExpression = new AndExpression();
            }
            andExpression.addExpression(currentExpression);
        }
        if (andExpression != null && expression != null) {
            andExpression.addExpression(expression);
            return andExpression;
        }
        return expression == null ? andExpression : expression;
    }

    public final Expression JoinedTable(Statement statement) throws ParseException {
        Expression expression;
        block32: {
            expression = null;
            Object andExpression = null;
            Object currentExpression = null;
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 47: 
                case 97: 
                case 159: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 159: {
                            this.jj_consume_token(159);
                            break;
                        }
                        default: {
                            this.jj_la1[92] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 47: {
                            this.jj_consume_token(47);
                            break;
                        }
                        case 97: {
                            this.jj_consume_token(97);
                            break;
                        }
                        default: {
                            this.jj_la1[93] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 65: {
                            this.jj_consume_token(65);
                            break block0;
                        }
                    }
                    this.jj_la1[94] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[97] = this.jj_gen;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 41: 
                        case 160: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 41: {
                                    this.jj_consume_token(41);
                                    break block0;
                                }
                                case 160: {
                                    this.jj_consume_token(160);
                                    break block0;
                                }
                            }
                            this.jj_la1[95] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_la1[96] = this.jj_gen;
                }
            }
            this.jj_consume_token(46);
            if (this.jj_2_12(2)) {
                expression = this.TableSpec(statement);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 41: 
                        case 46: 
                        case 47: 
                        case 97: 
                        case 159: 
                        case 160: {
                            break;
                        }
                        default: {
                            this.jj_la1[98] = this.jj_gen;
                            break block32;
                        }
                    }
                    this.JoinedTable(statement);
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 139: {
                    this.jj_consume_token(139);
                    expression = this.TableSpec(statement);
                    block30: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 41: 
                            case 46: 
                            case 47: 
                            case 97: 
                            case 159: 
                            case 160: {
                                break;
                            }
                            default: {
                                this.jj_la1[99] = this.jj_gen;
                                break block30;
                            }
                        }
                        this.JoinedTable(statement);
                    }
                    this.jj_consume_token(140);
                    break;
                }
                default: {
                    this.jj_la1[100] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.JoinCondition(statement);
        return expression;
    }

    public final Expression TableSpec(Statement statement) throws ParseException {
        Table table = null;
        Expression expression = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 128: 
            case 132: 
            case 133: 
            case 141: {
                table = this.TableReference();
                break;
            }
            case 76: 
            case 139: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 76: {
                        this.jj_consume_token(76);
                        break;
                    }
                    default: {
                        this.jj_la1[101] = this.jj_gen;
                    }
                }
                this.jj_consume_token(139);
                expression = this.FullSelectStatement(statement);
                this.jj_consume_token(140);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 128: {
                        this.CorrelationClause();
                        break block0;
                    }
                }
                this.jj_la1[102] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[103] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final void JoinCondition(Statement statement) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                this.SQLExpression(statement);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                this.jj_consume_token(139);
                this.SQLExpression(statement);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 138: {
                            break;
                        }
                        default: {
                            this.jj_la1[104] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(138);
                    this.SQLExpression(statement);
                }
                this.jj_consume_token(140);
                break;
            }
            default: {
                this.jj_la1[105] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Expression WhereClause(Statement statement) throws ParseException {
        this.jj_consume_token(91);
        Expression expression = this.SQLExpression(statement);
        return expression;
    }

    public final void CorrelationClause() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[106] = this.jj_gen;
            }
        }
        this.jj_consume_token(128);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 139: {
                this.ColumnNames();
                break;
            }
            default: {
                this.jj_la1[107] = this.jj_gen;
            }
        }
    }

    public final void ColumnNames() throws ParseException {
        block12: {
            this.jj_consume_token(139);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 128: {
                    this.jj_consume_token(128);
                    break;
                }
                case 133: {
                    this.jj_consume_token(133);
                    break;
                }
                default: {
                    this.jj_la1[108] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 138: {
                        break;
                    }
                    default: {
                        this.jj_la1[109] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(138);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 128: {
                        this.jj_consume_token(128);
                        continue block11;
                    }
                    case 133: {
                        this.jj_consume_token(133);
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[110] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(140);
    }

    public final void GroupByClause(Statement statement) throws ParseException {
        this.jj_consume_token(34);
        this.jj_consume_token(12);
        this.GroupByColumn(statement);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    break;
                }
                default: {
                    this.jj_la1[111] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(138);
            this.GroupByColumn(statement);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                this.SQLExpression(statement);
                break;
            }
            default: {
                this.jj_la1[112] = this.jj_gen;
            }
        }
    }

    public final void GroupByColumn(Statement statement) throws ParseException {
        this.SQLRelationalExpression(statement);
    }

    public final void OrderByClause(Statement statement) throws ParseException {
        this.jj_consume_token(64);
        this.jj_consume_token(12);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 161: {
                this.jj_consume_token(161);
                this.jj_consume_token(140);
                break;
            }
            default: {
                this.jj_la1[118] = this.jj_gen;
                if (this.jj_2_13(1)) {
                    this.OrderByColumn(statement);
                    block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 128: 
                        case 133: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 128: {
                                    this.jj_consume_token(128);
                                    break block3;
                                }
                                case 133: {
                                    this.jj_consume_token(133);
                                    break block3;
                                }
                            }
                            this.jj_la1[113] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[114] = this.jj_gen;
                        }
                    }
                    block20: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 138: {
                                break;
                            }
                            default: {
                                this.jj_la1[115] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_consume_token(138);
                        this.OrderByColumn(statement);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 128: 
                            case 133: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 128: {
                                        this.jj_consume_token(128);
                                        continue block20;
                                    }
                                    case 133: {
                                        this.jj_consume_token(133);
                                        continue block20;
                                    }
                                }
                                this.jj_la1[116] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_la1[117] = this.jj_gen;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void OrderByColumn(Statement statement) throws ParseException {
        this.SQLRelationalExpression(statement);
    }

    public final Expression SQLExpression(Statement statement) throws ParseException {
        OrExpression orExpression = null;
        Object andExpression = null;
        Expression expression = null;
        int count = 0;
        expression = this.SQLAndExpression(statement);
        orExpression = new OrExpression(expression);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 62: 
                case 63: {
                    break;
                }
                default: {
                    this.jj_la1[119] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 62: {
                    this.jj_consume_token(62);
                    break;
                }
                case 63: {
                    this.jj_consume_token(63);
                    break;
                }
                default: {
                    this.jj_la1[120] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if ((expression = this.SQLAndExpression(statement)) == null) continue;
            ++count;
            orExpression.addExpression(expression);
        }
        if (count > 0) {
            return orExpression;
        }
        return expression;
    }

    public final Expression SQLAndExpression(Statement statement) throws ParseException {
        BaseExpressionList andExpression = null;
        Expression expression = this.SQLUnaryLogicalExpression(statement);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[121] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(7);
            Expression currentExpression = this.SQLUnaryLogicalExpression(statement);
            if (andExpression == null && currentExpression != null) {
                andExpression = new AndExpression(expression);
            }
            if (currentExpression == null) continue;
            andExpression.addExpression(currentExpression);
        }
        if (andExpression != null) {
            return andExpression;
        }
        return expression;
    }

    public final Expression SQLUnaryLogicalExpression(Statement statement) throws ParseException {
        Expression expression = null;
        boolean not = false;
        if (!this.jj_2_14(2)) {
            if (this.jj_2_15(1)) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 52: {
                        this.jj_consume_token(52);
                        not = true;
                        break;
                    }
                    default: {
                        this.jj_la1[122] = this.jj_gen;
                    }
                }
                expression = this.SQLRelationalExpression(statement);
                return this.reverseExpression(not, expression);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.ExistsClause(statement);
        throw new Error("Missing return statement in function");
    }

    public final Expression ExistsClause(Statement statement) throws ParseException {
        Expression expression = null;
        boolean not = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 52: {
                this.jj_consume_token(52);
                not = true;
                break;
            }
            default: {
                this.jj_la1[123] = this.jj_gen;
            }
        }
        this.jj_consume_token(28);
        this.jj_consume_token(139);
        expression = this.FullSelectStatement(statement);
        this.jj_consume_token(140);
        return this.reverseExpression(not, expression);
    }

    public final Expression SQLRelationalExpression(Statement statement) throws ParseException {
        Expression expression = null;
        Expression otherExpression = null;
        String functionName = null;
        int function = 0;
        if (this.jj_2_16(Integer.MAX_VALUE)) {
            this.jj_consume_token(139);
            this.SQLExpressionList(statement);
            this.jj_consume_token(140);
        } else if (this.jj_2_17(1)) {
            expression = this.SQLSimpleExpression(statement);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 37: 
            case 38: 
            case 48: 
            case 52: 
            case 137: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 137: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: {
                        functionName = this.Relop();
                        function = Comparative.getComparisonByIdent(functionName);
                        otherExpression = this.SQLRelationalOperatorExpression(statement);
                        if (expression == null || otherExpression == null) {
                            return null;
                        }
                        if (expression instanceof ColumnExpression && !(otherExpression instanceof ColumnExpression)) {
                            ColumnExpression colExp = (ColumnExpression)expression;
                            ComparisonExpression comparativeExpression = new ComparisonExpression();
                            comparativeExpression.setComparison(function);
                            comparativeExpression.setExpression(otherExpression);
                            colExp.setExpression(comparativeExpression);
                            return colExp;
                        }
                        if (!(expression instanceof ColumnExpression) && otherExpression instanceof ColumnExpression) {
                            ColumnExpression colExp = (ColumnExpression)otherExpression;
                            ComparisonExpression comparativeExpression = new ComparisonExpression();
                            comparativeExpression.setComparison(Comparative.exchangeComparison(function));
                            comparativeExpression.setExpression(expression);
                            colExp.setExpression(comparativeExpression);
                            return colExp;
                        }
                        return null;
                    }
                }
                this.jj_la1[124] = this.jj_gen;
                if (this.jj_2_18(2)) {
                    otherExpression = this.SQLInClause(expression, statement);
                    return otherExpression;
                }
                if (this.jj_2_19(2)) {
                    otherExpression = this.SQLBetweenClause(expression, statement);
                    return otherExpression;
                }
                if (this.jj_2_20(2)) {
                    otherExpression = this.SQLLikeClause(statement);
                    if (expression instanceof ColumnExpression && otherExpression != null) {
                        ColumnExpression colExp = (ColumnExpression)expression;
                        colExp.setExpression((ComparisonExpression)otherExpression);
                        return colExp;
                    }
                    return null;
                }
                if (this.jj_2_21(2)) {
                    otherExpression = this.IsNullClause(statement);
                    if (expression instanceof ColumnExpression && otherExpression != null) {
                        ColumnExpression colExp = (ColumnExpression)expression;
                        colExp.setExpression((ComparisonExpression)otherExpression);
                        return colExp;
                    }
                    return null;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[125] = this.jj_gen;
        return expression;
    }

    public final List<Expression> SQLExpressionList(Statement statement) throws ParseException {
        ArrayList<Expression> list = new ArrayList<Expression>();
        Expression expression = this.SQLSimpleExpression(statement);
        list.add(expression);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    break;
                }
                default: {
                    this.jj_la1[126] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(138);
            expression = this.SQLSimpleExpression(statement);
            list.add(expression);
        }
        return list;
    }

    public final Expression SQLRelationalOperatorExpression(Statement statement) throws ParseException {
        Expression expression = null;
        if (this.jj_2_22(Integer.MAX_VALUE)) {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 8: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 6: {
                            this.jj_consume_token(6);
                            break block0;
                        }
                        case 8: {
                            this.jj_consume_token(8);
                            break block0;
                        }
                    }
                    this.jj_la1[127] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[128] = this.jj_gen;
                }
            }
            this.jj_consume_token(139);
            this.FullSelectStatement(statement);
            this.jj_consume_token(140);
        } else if (this.jj_2_23(1)) {
            expression = this.SQLSimpleExpression(statement);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expression;
    }

    public final Expression SQLInClause(Expression inputExpression, Statement statement) throws ParseException {
        boolean not = false;
        Expression expression = null;
        List<Expression> list = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 52: {
                this.jj_consume_token(52);
                not = true;
                break;
            }
            default: {
                this.jj_la1[129] = this.jj_gen;
            }
        }
        this.jj_consume_token(37);
        this.jj_consume_token(139);
        if (this.jj_2_24(2)) {
            list = this.SQLExpressionList(statement);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 73: 
                case 139: {
                    expression = this.FullSelectStatement(statement);
                    break;
                }
                default: {
                    this.jj_la1[130] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.jj_consume_token(140);
        if (list == null) {
            return expression;
        }
        if (list.size() == 1) {
            Expression item = list.get(0);
            ComparisonExpression comparativeExpression = new ComparisonExpression();
            comparativeExpression.setExpression(item);
            comparativeExpression.setComparison(not ? 6 : 3);
            if (inputExpression instanceof ColumnExpression) {
                ((ColumnExpression)inputExpression).setExpression(comparativeExpression);
                return inputExpression;
            }
            return comparativeExpression;
        }
        BaseExpressionList baseList = null;
        baseList = not ? new AndExpression(null) : new OrExpression(null);
        for (Expression item : list) {
            ComparisonExpression comparativeExpression = new ComparisonExpression();
            comparativeExpression.setExpression(item);
            comparativeExpression.setComparison(not ? 6 : 3);
            if (inputExpression instanceof ColumnExpression) {
                ColumnExpression columnExpression = new ColumnExpression();
                columnExpression.setExpression(comparativeExpression);
                columnExpression.setColumn(((ColumnExpression)inputExpression).getColumn());
                baseList.addExpression(columnExpression);
                continue;
            }
            baseList.addExpression(comparativeExpression);
        }
        return baseList;
    }

    public final Expression SQLBetweenClause(Expression inputExpression, Statement statement) throws ParseException {
        boolean not = false;
        Expression minExpression = null;
        Expression maxExpression = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 52: {
                this.jj_consume_token(52);
                not = true;
                break;
            }
            default: {
                this.jj_la1[131] = this.jj_gen;
            }
        }
        this.jj_consume_token(10);
        minExpression = this.SQLSimpleExpression(statement);
        this.jj_consume_token(7);
        maxExpression = this.SQLSimpleExpression(statement);
        if (minExpression != null && maxExpression != null) {
            ComparisonExpression comparativeMinExpression = new ComparisonExpression();
            comparativeMinExpression.setExpression(minExpression);
            comparativeMinExpression.setComparison(2);
            ComparisonExpression comparativeMaxExpression = new ComparisonExpression();
            comparativeMaxExpression.setExpression(maxExpression);
            comparativeMaxExpression.setComparison(8);
            AndExpression andExpression = new AndExpression();
            if (inputExpression instanceof ColumnExpression) {
                ColumnExpression columnMinExpression = new ColumnExpression();
                columnMinExpression.setExpression(comparativeMinExpression);
                columnMinExpression.setColumn(((ColumnExpression)inputExpression).getColumn());
                ColumnExpression columnMaxExpression = new ColumnExpression();
                columnMaxExpression.setExpression(comparativeMaxExpression);
                columnMaxExpression.setColumn(((ColumnExpression)inputExpression).getColumn());
                andExpression.addExpression(columnMinExpression);
                andExpression.addExpression(columnMaxExpression);
            } else {
                andExpression.addExpression(comparativeMinExpression);
                andExpression.addExpression(comparativeMaxExpression);
            }
            return this.reverseExpression(not, andExpression);
        }
        return null;
    }

    public final Expression SQLLikeClause(Statement statement) throws ParseException {
        Expression expression = null;
        boolean not = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 52: {
                this.jj_consume_token(52);
                not = true;
                break;
            }
            default: {
                this.jj_la1[132] = this.jj_gen;
            }
        }
        this.jj_consume_token(48);
        expression = this.SQLSimpleExpression(statement);
        ComparisonExpression comparisonExpression = new ComparisonExpression();
        comparisonExpression.setExpression(expression);
        comparisonExpression.setComparison(not ? 5 : 4);
        return comparisonExpression;
    }

    public final Expression SQLSimpleExpression(Statement statement) throws ParseException {
        Expression expression = null;
        Object token = null;
        expression = this.SQLAddSubtractExpression(statement);
        return expression;
    }

    public final Expression SQLAddSubtractExpression(Statement statement) throws ParseException {
        Expression expression = null;
        Expression otherExpression = null;
        Token token = null;
        FunctionExpression superExpression = null;
        expression = this.SQLMultiplicativeExpression(statement);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 162: 
                case 163: 
                case 164: 
                case 165: {
                    break;
                }
                default: {
                    this.jj_la1[133] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 162: {
                    token = this.jj_consume_token(162);
                    break;
                }
                case 163: {
                    token = this.jj_consume_token(163);
                    break;
                }
                case 164: {
                    token = this.jj_consume_token(164);
                    break;
                }
                case 165: {
                    token = this.jj_consume_token(165);
                    break;
                }
                default: {
                    this.jj_la1[134] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            otherExpression = this.SQLMultiplicativeExpression(statement);
            String ident = token.image.toUpperCase();
            Function function = this.getFunction(ident);
            if (function == null) {
                return null;
            }
            FunctionExpression functionExpression = new FunctionExpression();
            functionExpression.setFunction(function);
            if (superExpression == null) {
                functionExpression.addArgExpression(expression);
                functionExpression.addArgExpression(otherExpression);
            } else {
                functionExpression.addArgExpression(superExpression);
                functionExpression.addArgExpression(otherExpression);
            }
            superExpression = functionExpression;
        }
        if (superExpression == null) {
            return expression;
        }
        return superExpression;
    }

    public final Expression SQLMultiplicativeExpression(Statement statement) throws ParseException {
        Expression expression = this.SQLUnaryExpression(statement);
        block10: while (true) {
            Token token;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 78: 
                case 79: 
                case 157: 
                case 166: 
                case 167: {
                    break;
                }
                default: {
                    this.jj_la1[135] = this.jj_gen;
                    break block10;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 157: {
                    token = this.jj_consume_token(157);
                    break;
                }
                case 166: {
                    token = this.jj_consume_token(166);
                    break;
                }
                case 167: {
                    token = this.jj_consume_token(167);
                    break;
                }
                case 78: {
                    token = this.jj_consume_token(78);
                    break;
                }
                case 79: {
                    token = this.jj_consume_token(79);
                    break;
                }
                default: {
                    this.jj_la1[136] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression otherExpression = this.SQLUnaryExpression(statement);
            Function function = this.getFunction(token.image.toUpperCase());
            if (function == null || expression == null || otherExpression == null) continue;
            FunctionExpression functionExpression = new FunctionExpression();
            functionExpression.setFunction(function);
            functionExpression.addArgExpression(expression);
            functionExpression.addArgExpression(otherExpression);
            expression = functionExpression;
        }
        return expression;
    }

    public final Expression SQLUnaryExpression(Statement statement) throws ParseException {
        boolean isSub = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 162: 
            case 163: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 162: {
                        this.jj_consume_token(162);
                        break block0;
                    }
                    case 163: {
                        this.jj_consume_token(163);
                        isSub = true;
                        break block0;
                    }
                }
                this.jj_la1[137] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[138] = this.jj_gen;
            }
        }
        Expression expression = this.SQLPrimaryExpression(statement);
        if (isSub) {
            Function function = this.getFunction("-");
            if (function != null) {
                FunctionExpression funExp = new FunctionExpression();
                ConstantExpression consExp = new ConstantExpression(Integer.valueOf(0));
                funExp.addArgExpression(consExp);
                funExp.addArgExpression(expression);
                funExp.setFunction(function);
                return funExp;
            }
            return null;
        }
        return expression;
    }

    public final Expression SQLPrimaryExpression(Statement statement) throws ParseException {
        Token t = null;
        Column column = null;
        Expression expression = null;
        Number value = null;
        boolean not = false;
        block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                t = this.jj_consume_token(54);
                return new ConstantExpression(null);
            }
            case 94: {
                t = this.jj_consume_token(94);
                return new ConstantExpression(Boolean.TRUE);
            }
            case 95: {
                t = this.jj_consume_token(95);
                return new ConstantExpression(Boolean.FALSE);
            }
            case 121: {
                t = this.jj_consume_token(121);
                try {
                    value = Long.valueOf(t.image);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return new ConstantExpression((Comparable)((Object)value));
            }
            case 122: {
                t = this.jj_consume_token(122);
                try {
                    value = new BigDecimal(t.image);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return new ConstantExpression((Comparable)((Object)value));
            }
            case 131: {
                t = this.jj_consume_token(131);
                int tt = t.image.indexOf("'");
                String temp = t.image.substring(tt + 1, t.image.length() - 1);
                temp = MysqlParser.replaceEscape(temp);
                return new ConstantExpression((Comparable)((Object)temp));
            }
            case 134: {
                t = this.jj_consume_token(134);
                int index = this.parameterIndex++;
                return new ParameterExpression(index);
            }
            case 98: {
                FunctionExpression funExp;
                this.jj_consume_token(98);
                expression = this.SQLExpression(statement);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 99: {
                        this.token = this.jj_consume_token(99);
                        break;
                    }
                    case 104: {
                        this.token = this.jj_consume_token(104);
                        break;
                    }
                    case 102: {
                        this.token = this.jj_consume_token(102);
                        break;
                    }
                    case 105: {
                        this.token = this.jj_consume_token(105);
                        break;
                    }
                    case 103: {
                        this.token = this.jj_consume_token(103);
                        break;
                    }
                    case 101: {
                        this.token = this.jj_consume_token(101);
                        break;
                    }
                    case 100: {
                        this.token = this.jj_consume_token(100);
                        break;
                    }
                    default: {
                        this.jj_la1[139] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (this.token == null) break;
                int field = -1;
                if (this.token.image.equalsIgnoreCase("YEAR")) {
                    field = 1;
                } else if (this.token.image.equalsIgnoreCase("MONTH")) {
                    field = 2;
                } else if (this.token.image.equalsIgnoreCase("DAY")) {
                    field = 5;
                } else if (this.token.image.equalsIgnoreCase("WEEK")) {
                    field = 5;
                    funExp = new FunctionExpression();
                    funExp.setFunction(this.getFunction("*"));
                    funExp.addArgExpression(expression);
                    funExp.addArgExpression(new ConstantExpression(Integer.valueOf(7)));
                    expression = funExp;
                } else if (this.token.image.equalsIgnoreCase("HOUR")) {
                    field = 10;
                } else if (this.token.image.equalsIgnoreCase("MINUTE")) {
                    field = 12;
                } else if (this.token.image.equalsIgnoreCase("SECOND")) {
                    field = 13;
                } else if (this.token.image.equalsIgnoreCase("MICROSECOND")) {
                    field = 14;
                    funExp = new FunctionExpression();
                    funExp.setFunction(this.getFunction("/"));
                    funExp.addArgExpression(expression);
                    funExp.addArgExpression(new ConstantExpression(Integer.valueOf(1000)));
                    expression = funExp;
                }
                funExp = new FunctionExpression();
                funExp.setFunction(timeConverter);
                funExp.addArgExpression(expression);
                return funExp;
            }
            case 14: {
                this.CastFunctionCall(statement);
                break;
            }
            case 13: {
                this.CaseStatement(statement);
                break;
            }
            default: {
                this.jj_la1[141] = this.jj_gen;
                if (this.jj_2_25(1)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 53: {
                            this.jj_consume_token(53);
                            not = true;
                            break;
                        }
                        default: {
                            this.jj_la1[140] = this.jj_gen;
                        }
                    }
                    if (this.getFunction(this.getToken((int)1).image.toUpperCase()) == null) {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    expression = this.OverloadedFunctionCall(statement);
                    if (!not || expression == null) break;
                    expression = this.reverseExpression(not, expression);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 139: {
                        this.jj_consume_token(139);
                        expression = this.SQLExpression(statement);
                        this.jj_consume_token(140);
                        break block2;
                    }
                }
                this.jj_la1[142] = this.jj_gen;
                if (this.jj_2_26(Integer.MAX_VALUE)) {
                    this.FunctionCall(statement);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 128: 
                    case 132: 
                    case 133: 
                    case 141: {
                        column = this.ColumnName();
                        ColumnExpression columnExpression = new ColumnExpression();
                        columnExpression.setColumn(column);
                        return columnExpression;
                    }
                }
                this.jj_la1[143] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final void FunctionCall(Statement statement) throws ParseException {
        this.EntityName();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 136: {
                this.jj_consume_token(136);
                this.EntityName();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 136: {
                        this.jj_consume_token(136);
                        this.EntityName();
                        break block0;
                    }
                }
                this.jj_la1[144] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[145] = this.jj_gen;
            }
        }
        this.jj_consume_token(139);
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 20: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        this.jj_consume_token(20);
                        break block6;
                    }
                    case 6: {
                        this.jj_consume_token(6);
                        break block6;
                    }
                }
                this.jj_la1[146] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[147] = this.jj_gen;
            }
        }
        if (this.jj_2_27(1)) {
            this.SQLExpressionList(statement);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 157: {
                    this.jj_consume_token(157);
                    break;
                }
                default: {
                    this.jj_la1[148] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.jj_consume_token(140);
    }

    public final void CastFunctionCall(Statement statement) throws ParseException {
        this.jj_consume_token(14);
        this.jj_consume_token(139);
        this.SQLSimpleExpression(statement);
        this.jj_consume_token(9);
        this.DataTypes();
        this.jj_consume_token(140);
    }

    public final String FunctionName() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                t = this.jj_consume_token(42);
                break;
            }
            case 78: {
                t = this.jj_consume_token(78);
                break;
            }
            case 100: {
                t = this.jj_consume_token(100);
                break;
            }
            case 99: {
                t = this.jj_consume_token(99);
                break;
            }
            case 102: {
                t = this.jj_consume_token(102);
                break;
            }
            case 103: {
                t = this.jj_consume_token(103);
                break;
            }
            case 104: {
                t = this.jj_consume_token(104);
                break;
            }
            case 105: {
                t = this.jj_consume_token(105);
                break;
            }
            case 101: {
                t = this.jj_consume_token(101);
                break;
            }
            case 43: {
                t = this.jj_consume_token(43);
                break;
            }
            case 128: {
                t = this.jj_consume_token(128);
                break;
            }
            default: {
                this.jj_la1[149] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (t != null) {
            return t.image.toUpperCase();
        }
        return null;
    }

    public final Expression OverloadedFunctionCall(Statement statement) throws ParseException {
        Expression expression = null;
        Function function = null;
        Object functionNameToken = null;
        String functionName = null;
        FunctionExpression funExpression = null;
        boolean nullExp = false;
        functionName = this.FunctionName();
        funExpression = new FunctionExpression();
        function = this.getFunction(functionName);
        funExpression.setFunction(function);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 139: {
                this.jj_consume_token(139);
                if (this.jj_2_28(1)) {
                    expression = this.SQLSimpleExpression(statement);
                    if (funExpression != null) {
                        if (expression == null) {
                            nullExp = true;
                        }
                        funExpression.addArgExpression(expression);
                    }
                }
                block6: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 138: {
                            break;
                        }
                        default: {
                            this.jj_la1[150] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(138);
                    expression = this.SQLSimpleExpression(statement);
                    if (funExpression == null) continue;
                    if (expression == null) {
                        nullExp = true;
                    }
                    funExpression.addArgExpression(expression);
                }
                this.jj_consume_token(140);
                break;
            }
            default: {
                this.jj_la1[151] = this.jj_gen;
            }
        }
        if (nullExp) {
            return null;
        }
        return funExpression;
    }

    public final void DataTypes() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 17: 
            case 30: 
            case 44: 
            case 45: 
            case 56: 
            case 57: 
            case 69: 
            case 88: 
            case 89: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        break;
                    }
                    case 89: {
                        this.jj_consume_token(89);
                        break;
                    }
                    case 88: {
                        this.jj_consume_token(88);
                        break;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        break;
                    }
                    case 44: {
                        this.jj_consume_token(44);
                        break;
                    }
                    case 45: {
                        this.jj_consume_token(45);
                        break;
                    }
                    case 56: {
                        this.jj_consume_token(56);
                        break;
                    }
                    case 57: {
                        this.jj_consume_token(57);
                        break;
                    }
                    case 69: {
                        this.jj_consume_token(69);
                        break;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        break;
                    }
                    default: {
                        this.jj_la1[152] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 139: {
                        this.jj_consume_token(139);
                        this.jj_consume_token(122);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 138: {
                                this.jj_consume_token(138);
                                this.jj_consume_token(122);
                                break;
                            }
                            default: {
                                this.jj_la1[153] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(140);
                        break block0;
                    }
                }
                this.jj_la1[154] = this.jj_gen;
                break;
            }
            case 168: {
                this.jj_consume_token(168);
                break;
            }
            case 169: {
                this.jj_consume_token(169);
                break;
            }
            case 170: {
                this.jj_consume_token(170);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            default: {
                this.jj_la1[155] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ForUpdateClause() throws ParseException {
        this.jj_consume_token(31);
        this.jj_consume_token(84);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                this.jj_consume_token(58);
                this.ColumnName();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 138: {
                            break;
                        }
                        default: {
                            this.jj_la1[156] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(138);
                    this.ColumnName();
                }
            }
            default: {
                this.jj_la1[157] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            default: {
                this.jj_la1[158] = this.jj_gen;
            }
        }
    }

    public final void ReadOnlyClause() throws ParseException {
        this.jj_consume_token(31);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            default: {
                this.jj_la1[159] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(61);
    }

    public final void INDEX() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 110: {
                this.jj_consume_token(110);
                break;
            }
            case 109: {
                this.jj_consume_token(109);
                break;
            }
            case 171: {
                this.jj_consume_token(171);
                break;
            }
            default: {
                this.jj_la1[160] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(139);
        this.jj_consume_token(128);
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    break;
                }
                default: {
                    this.jj_la1[161] = this.jj_gen;
                    break block8;
                }
            }
            this.jj_consume_token(138);
            this.jj_consume_token(128);
        }
        this.jj_consume_token(140);
    }

    public final void OptimizeForClause() throws ParseException {
        this.jj_consume_token(67);
        this.jj_consume_token(31);
        this.jj_consume_token(122);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 128: {
                this.jj_consume_token(128);
                break;
            }
            case 133: {
                this.jj_consume_token(133);
                break;
            }
            default: {
                this.jj_la1[162] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void WithClause() throws ParseException {
        this.jj_consume_token(93);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 128: {
                this.jj_consume_token(128);
                break;
            }
            case 133: {
                this.jj_consume_token(133);
                break;
            }
            default: {
                this.jj_la1[163] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 128: {
                this.jj_consume_token(128);
                this.jj_consume_token(128);
                this.jj_consume_token(128);
                break;
            }
            default: {
                this.jj_la1[164] = this.jj_gen;
            }
        }
    }

    public final void QuerynoClause() throws ParseException {
        this.jj_consume_token(66);
        this.jj_consume_token(122);
    }

    public final void FetchFirstClause() throws ParseException {
        this.jj_consume_token(29);
        this.jj_consume_token(128);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            default: {
                this.jj_la1[165] = this.jj_gen;
            }
        }
        this.jj_consume_token(128);
        this.jj_consume_token(61);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    private boolean jj_3R_175() {
        Token xsp;
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_3R_111()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_177());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_158() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_3R_111();
    }

    private boolean jj_3R_148() {
        Token xsp;
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_156()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_157());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_158()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_35() {
        return this.jj_3R_60();
    }

    private boolean jj_3R_71() {
        Token xsp;
        if (this.jj_3R_78()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_85());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_179() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(128)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(133)) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_180());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_84() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(41)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(160)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_75() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_84()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_70() {
        if (this.jj_3R_33()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_77()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_172() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(128)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_176()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_144() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(154)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(155)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_147() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_3R_111();
    }

    private boolean jj_3R_66() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_174() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        return this.jj_3R_111();
    }

    private boolean jj_3R_171() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_174()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_175()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_43() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_66()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_58() {
        return this.jj_3R_72();
    }

    private boolean jj_3R_54() {
        Token xsp;
        if (this.jj_3R_71()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_76());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_59() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(76)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_3R_73()) {
            return true;
        }
        if (this.jj_scan_token(140)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_169()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_3() {
        Token xsp;
        if (this.jj_scan_token(139)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(139));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(73);
    }

    private boolean jj_3R_34() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_58()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_59()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_178() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_scan_token(128);
    }

    private boolean jj_3_4() {
        return this.jj_3R_29();
    }

    private boolean jj_3_12() {
        Token xsp;
        if (this.jj_3R_34()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_35());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_74() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(159)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(47)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(97)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(65)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_29() {
        return this.jj_3R_54();
    }

    private boolean jj_3R_60() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_74()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_75()) {
                return true;
            }
        }
        if (this.jj_scan_token(46)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_12()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_170()) {
                return true;
            }
        }
        return this.jj_3R_171();
    }

    private boolean jj_3R_163() {
        return this.jj_3R_60();
    }

    private boolean jj_3R_65() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(48)) {
            return true;
        }
        return this.jj_3R_29();
    }

    private boolean jj_3R_142() {
        return this.jj_3R_73();
    }

    private boolean jj_3R_154() {
        Token xsp;
        if (this.jj_3R_34()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_163());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_129() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_scan_token(122);
    }

    private boolean jj_3R_167() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(128);
    }

    private boolean jj_3R_64() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_64()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_29()) {
            return true;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_29();
    }

    private boolean jj_3R_31() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(29)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(68)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_91() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(110)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(109)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(171)) {
                    return true;
                }
            }
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_scan_token(128)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_178());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_162() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_32();
    }

    private boolean jj_3R_53() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_52();
    }

    private boolean jj_3R_155() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_154();
    }

    private boolean jj_3R_30() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_scan_token(84);
    }

    private boolean jj_3R_146() {
        Token xsp;
        if (this.jj_scan_token(32)) {
            return true;
        }
        if (this.jj_3R_154()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_155());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_128() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_scan_token(122)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_129()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(140);
    }

    private boolean jj_3_24() {
        return this.jj_3R_45();
    }

    private boolean jj_3_8() {
        Token xsp;
        if (this.jj_3R_32()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_162());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_114() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_123()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(168)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(169)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(170)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(11)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_123() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(15)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(89)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(88)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(17)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(44)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(45)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(56)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(57)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(69)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(30)) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_128()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_166() {
        if (this.jj_scan_token(137)) {
            return true;
        }
        return this.jj_3R_29();
    }

    private boolean jj_3R_125() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_29();
    }

    private boolean jj_3R_160() {
        return this.jj_scan_token(134);
    }

    private boolean jj_3R_143() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(6)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(20)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(148)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_44() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        return this.jj_scan_token(73);
    }

    private boolean jj_3_11() {
        return this.jj_3R_29();
    }

    private boolean jj_3_10() {
        if (this.jj_3R_33()) {
            return true;
        }
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_33()) {
            return true;
        }
        return this.jj_scan_token(158);
    }

    private boolean jj_3_28() {
        return this.jj_3R_29();
    }

    private boolean jj_3_9() {
        if (this.jj_3R_33()) {
            return true;
        }
        return this.jj_scan_token(158);
    }

    private boolean jj_3R_118() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_125());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_52() {
        return this.jj_3R_70();
    }

    private boolean jj_3R_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_10()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_11()) {
                    return true;
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_166()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_167()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_63() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_40() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_63()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(37)) {
            return true;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_24()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_142()) {
                return true;
            }
        }
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_48() {
        if (this.jj_3R_68()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_118()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_161() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_32();
    }

    private boolean jj_3_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(6)) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_44()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_28() {
        Token xsp;
        if (this.jj_3R_52()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_53());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_151() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(138)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(71)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_160()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(121)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_153() {
        Token xsp;
        if (this.jj_scan_token(157)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_161());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_145() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_153()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_8()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_107() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(125)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_143()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(149)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(150)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(151)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(152)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(153)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_144()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(156)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_145();
    }

    private boolean jj_3R_152() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(6)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(8)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_23() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_141() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_152()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_3R_73()) {
            return true;
        }
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_134() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_141()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_23()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_132() {
        if (this.jj_3R_140()) {
            return true;
        }
        return this.jj_3R_73();
    }

    private boolean jj_3R_117() {
        return this.jj_3R_124();
    }

    private boolean jj_3R_126() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        return this.jj_3R_33();
    }

    private boolean jj_3_27() {
        return this.jj_3R_45();
    }

    private boolean jj_3R_67() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_29();
    }

    private boolean jj_3R_150() {
        return this.jj_scan_token(134);
    }

    private boolean jj_3R_139() {
        if (this.jj_scan_token(96)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_150()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(121)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_151()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_138() {
        return this.jj_3R_149();
    }

    private boolean jj_3R_69() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        return this.jj_3R_33();
    }

    private boolean jj_3R_137() {
        return this.jj_3R_148();
    }

    private boolean jj_3R_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(42)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(78)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(100)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(99)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(102)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(103)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(104)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(105)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(101)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(43)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(128)) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_45() {
        Token xsp;
        if (this.jj_3R_29()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_67());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_119() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_33()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_126()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_136() {
        return this.jj_3R_147();
    }

    private boolean jj_3R_108() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_3R_29()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_3R_114()) {
            return true;
        }
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_135() {
        return this.jj_3R_146();
    }

    private boolean jj_3R_116() {
        return this.jj_3R_115();
    }

    private boolean jj_3_21() {
        return this.jj_3R_43();
    }

    private boolean jj_3R_120() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(20)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(6)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_92() {
        if (this.jj_3R_107()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_135()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_136()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_137()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_138()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_139()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_49() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_33()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_110() {
        if (this.jj_3R_33()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_119()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_120()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(157)) {
                return true;
            }
        }
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_140() {
        if (this.jj_scan_token(82)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(6)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_20() {
        return this.jj_3R_42();
    }

    private boolean jj_3_19() {
        return this.jj_3R_41();
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_3R_28()) {
            return true;
        }
        return this.jj_scan_token(140);
    }

    private boolean jj_3_18() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_47() {
        return false;
    }

    private boolean jj_3_26() {
        if (this.jj_3R_33()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_49()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(139);
    }

    private boolean jj_3R_83() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_3R_73()) {
            return true;
        }
        if (this.jj_scan_token(140)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_132()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_82() {
        return this.jj_3R_92();
    }

    private boolean jj_3R_73() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_82()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_83()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_51() {
        return this.jj_scan_token(138);
    }

    private boolean jj_3R_105() {
        return this.jj_3R_110();
    }

    private boolean jj_3R_106() {
        return this.jj_3R_70();
    }

    private boolean jj_3R_104() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_3R_111()) {
            return true;
        }
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_46() {
        return this.jj_scan_token(53);
    }

    private boolean jj_3_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_46()) {
            this.jj_scanpos = xsp;
        }
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getFunction(this.getToken((int)1).image.toUpperCase()) != null;
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_47()) {
            return true;
        }
        return this.jj_3R_48();
    }

    private boolean jj_3R_103() {
        return this.jj_3R_109();
    }

    private boolean jj_3R_102() {
        return this.jj_3R_108();
    }

    private boolean jj_3_7() {
        return this.jj_3R_31();
    }

    private boolean jj_3_1() {
        return this.jj_3R_27();
    }

    private boolean jj_3_6() {
        return this.jj_3R_30();
    }

    private boolean jj_3_16() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_3R_29()) {
            return true;
        }
        return this.jj_scan_token(138);
    }

    private boolean jj_3R_131() {
        if (this.jj_3R_133()) {
            return true;
        }
        return this.jj_3R_134();
    }

    private boolean jj_3R_130() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_131()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_18()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_19()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_20()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_21()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_124() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_29();
    }

    private boolean jj_3_17() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_115() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_3R_111()) {
            return true;
        }
        if (this.jj_scan_token(80)) {
            return true;
        }
        return this.jj_3R_29();
    }

    private boolean jj_3R_62() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_3R_45()) {
            return true;
        }
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_17()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_130()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_5() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_109() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_115()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_116());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_117()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_61() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_37() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_3R_73()) {
            return true;
        }
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_101() {
        if (this.jj_scan_token(98)) {
            return true;
        }
        if (this.jj_3R_111()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(99)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(104)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(102)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(105)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(103)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(101)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(100)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_50() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_100() {
        return this.jj_scan_token(134);
    }

    private boolean jj_3R_81() {
        return this.jj_3R_91();
    }

    private boolean jj_3R_38() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_38()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_39();
    }

    private boolean jj_3R_89() {
        return this.jj_scan_token(133);
    }

    private boolean jj_3_14() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_121() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_15()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_80() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_89()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_90()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_90() {
        return this.jj_scan_token(128);
    }

    private boolean jj_3R_27() {
        Token xsp;
        if (this.jj_3R_50()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_51());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_99() {
        return this.jj_scan_token(131);
    }

    private boolean jj_3R_72() {
        if (this.jj_3R_79()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_81()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_98() {
        return this.jj_scan_token(122);
    }

    private boolean jj_3R_96() {
        return this.jj_scan_token(95);
    }

    private boolean jj_3R_164() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(128)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(133)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_97() {
        return this.jj_scan_token(121);
    }

    private boolean jj_3R_173() {
        return this.jj_3R_60();
    }

    private boolean jj_3R_122() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_121();
    }

    private boolean jj_3R_112() {
        Token xsp;
        if (this.jj_3R_121()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_122());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_95() {
        return this.jj_scan_token(94);
    }

    private boolean jj_3R_88() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        return this.jj_3R_33();
    }

    private boolean jj_3R_79() {
        if (this.jj_3R_33()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_88()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_87() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_94()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_95()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_96()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_97()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_98()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_99()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_100()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_101()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_102()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_103()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3_25()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_104()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_105()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_106()) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_94() {
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_127() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        return this.jj_3R_33();
    }

    private boolean jj_3R_168() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(128)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(133)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_85() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(157)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(166)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(167)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(78)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(79)) {
                            return true;
                        }
                    }
                }
            }
        }
        return this.jj_3R_78();
    }

    private boolean jj_3R_177() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_111();
    }

    private boolean jj_3_13() {
        if (this.jj_3R_36()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_164()) {
            this.jj_scanpos = xsp;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_165());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_180() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(128)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(133)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_157() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_156();
    }

    private boolean jj_3R_113() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(62)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(63)) {
                return true;
            }
        }
        return this.jj_3R_112();
    }

    private boolean jj_3R_93() {
        return this.jj_scan_token(163);
    }

    private boolean jj_3R_133() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(137)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(142)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(143)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(144)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(145)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(146)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(147)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_57() {
        return this.jj_scan_token(133);
    }

    private boolean jj_3R_111() {
        Token xsp;
        if (this.jj_3R_112()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_113());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_86() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(162)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_93()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_78() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_86()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_87();
    }

    private boolean jj_3R_169() {
        return this.jj_3R_172();
    }

    private boolean jj_3R_56() {
        return this.jj_scan_token(132);
    }

    private boolean jj_3R_170() {
        Token xsp;
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_173());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_159() {
        if (this.jj_scan_token(161)) {
            return true;
        }
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(141)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(128)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(141)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_55()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_56()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_57()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_36() {
        return this.jj_3R_39();
    }

    private boolean jj_3R_76() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(162)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(163)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(164)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(165)) {
                        return true;
                    }
                }
            }
        }
        return this.jj_3R_71();
    }

    private boolean jj_3R_77() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_33()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_127()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_165() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        if (this.jj_3R_36()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_168()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_176() {
        return this.jj_3R_179();
    }

    private boolean jj_3R_149() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_159()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_13()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_156() {
        return this.jj_3R_39();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 524288, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1610612736, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 0, 512, 0, 0, 0x1000000, 0x20000000, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100040, 0x100040, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 1024, 0, 320, 320, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24576, 0, 0, 0, 0, 0x100040, 0x100040, 0, 0, 0, 0, 1073905664, 0, 0, 1073907712, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 3072, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3072, 128, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49664, 0, 32768, 0, 512, 512, 32768, 49664, 49664, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, -1073741824, -1073741824, 0, 0x100000, 0x100000, 0, 0x110060, 0, 0, 0, 0x100000, 0, 0x100000, 0x100000, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0x400000, 0, 0, 0, 0, 0, 0, 0, 3072, 0, 0, 0x3003000, 0, 0, 0x3003000, 0, 0x4000000, 0x10000000, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{256, 3155456, 0, 0, 0, 64, 64, 0, 0, 0, 0, -1073741824, 0, 0, 0x8000000, 0, 128, 0, 128, 0, 8192, 0x8000000, 0, 0, 512, 0, 0, 0x8000000, 1, 0, 128, 0, 128, 0, 0, 0, 0, 0x800200, 0x800600, 0, 0, 0, 0, 0, 0x2000000C, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0x2000000C, 262144, 512, 0, 0, 0x8000000, 0, 1, 0, 128, 0, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 4096, 0, 4096, 0, 0x400000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 49152, 49152, 0, 0, 0, 0, -1073741824, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 0, 0x3000020, 0, 0, 0x3000020, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 269312, 24576, 0, 0, 524288, 524288, 0xF00000, 0, 0, 0, 0x2000000, 0x1008000, 0, 0, 0x2000000, 0, 0x2000000, 0, 1, 4096, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0, 0x2000000, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24576, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0, 0x2000000, 0, 1, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1016, 0, 0x6000004, 0, 0, 0, 0, 0, 0, 0, 1016, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24576, 0, 0, 0, 0, 0x4000000};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 2048, 0, 128, 57, 0, 0, 0, 25, 256, 512, 25, 1, 1024, 0, 64, 1024, 64, 1024, 0, 0, 0, 1024, 1024, 2048, 10289, 1024, 0, 0, 64, 1024, 64, 1024, 0, 0, 0, 0, 2048, 2048, 0, 1024, 3072, 1024, 1024, 0, 1024, 0, 256, 256, 8192, 8192, 8241, 1032704, 256, 0, 33, 33, 0, 0, 0, 0, 0, 2048, 0, 0, 0, 0, 0, 64, 1024, 64, 1024, 0, 0, 0x100000, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0xC000000, 0xC000000, 0x10000000, 1024, 1024, 0x20000000, 512, 0, 1, 1024, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 2048, 0, 1, 10289, 1024, 0, 0, 2048, 33, 1024, 33, 1024, 0, 33, 33, 1024, 33, 33, 0, 0, 0, 0, 0, 0, 1032704, 1032704, 1024, 0, 0, 0, 2048, 0, 0, 0, 0, 0x20000000, 0x20000000, 0, 0, 0, 0, 72, 2048, 8241, 256, 256, 0, 0, 0x20000000, 1, 1024, 2048, 0, 1024, 2048, 0, 1024, 0, 0, 0, 0, 1024, 33, 33, 1, 0};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{0, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 60, 192, 192, 12, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1792, 0, 0, 0, 0, 2048, 0, 0, 0, 0, 0};
    }

    public MysqlParser(InputStream stream) {
        this(stream, null);
    }

    public MysqlParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new MysqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 166; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 166; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public MysqlParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new MysqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 166; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 166; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public MysqlParser(MysqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 166; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(MysqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 166; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[172];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 166; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) == 0) continue;
                la1tokens[160 + j] = true;
            }
        }
        for (i = 0; i < 172; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 28; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        MysqlParser.jj_la1_init_0();
        MysqlParser.jj_la1_init_1();
        MysqlParser.jj_la1_init_2();
        MysqlParser.jj_la1_init_3();
        MysqlParser.jj_la1_init_4();
        MysqlParser.jj_la1_init_5();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

