package cn.smarthse.modules.supervise.provider;

import java.util.List;

import cn.smarthse.modules.supervise.model.CompanyModel;
import cn.smarthse.modules.supervise.model.MessageModel;
import cn.smarthse.modules.supervise.model.OrganizationModel;

/**
 * 
 * 《监管系统提供的接口》
 * 
 * 
 * @Project:  platform-supervise-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author horsy(何世壹) [hsy@smarthse.cn]
 * @since 2018年9月6日-下午6:16:36
 */
public interface ISuperviseService {

	/**
	 * 根据行政区域，获取可以监管当前行政区域的监管部门列表（在当前行政区域所属监管部门，及以上的监管部门）
	 * 如果为空，则当前行政区域无监管部门。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年9月10日-上午11:08:51
	 * @param areaId 行政区域ID
	 * @return 监管部门组织机构列表，如果为空，则当前行政区域无监管部门
	 */
	List<OrganizationModel> getOrganListByAreaId(Long areaId);
	
	/**
	 * 根据社会统一信用代码，获取未绑定的企业列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年9月10日-上午11:12:14
	 * @param unifiedSocialCc 社会统一信用代码
	 * @return
	 */
	List<CompanyModel> getCompanyUnBandedListByUnifiedSocialCc(String unifiedSocialCc, Long orgId) ;
	
	/**
	 * 请求加入监管
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年9月10日-上午11:15:08
	 * @param company 企业信息
	 */
	void claimToAddSupervise(CompanyModel company) throws RuntimeException;
	
	/**
	 * 将平台企业与监管系统企业之间进行绑定操作
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年9月10日-上午11:16:38
	 * @param company 企业信息
	 */
	void bandCompany(CompanyModel company) throws RuntimeException;
	
	/**
	 * 
	 * 
	 * @Comments:  <平台推送信息到监管系统>
	 * @author yanao
	 * @since 2018年9月26日-下午03:34:38
	 * @param message 推送信息
	 */
	void pushMessage(MessageModel message);
}
