package cn.smarthse.modules.supervise.model;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 * 《企业信息》
 * 
 * 
 * @Project:  platform-supervise-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author horsy(何世壹) [hsy@smarthse.cn]
 * @since 2018年9月6日-下午4:02:25
 */
public @Data class CompanyModel implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * 企业ID(平台)
	 */
	@ApiModelProperty(value="企业ID(平台)")
	private Long platFormId;
	
	/**
	 * 企业ID(监管系统)
	 */
	@ApiModelProperty(value="企业ID(监管系统)")
	private Long superviseId;
	
	/**
	 * 统一社会信用代码
	 */
	@ApiModelProperty(value="统一社会信用代码")
	private String unifiedSocialCc;
	
	/**
	 * 企业名称(平台)
	 */
	@ApiModelProperty(value="企业名称(平台)")
	private String namePlatForm;
	
	/**
	 * 企业简称(平台)
	 */
	//private String shortNamePlatForm;
	
	/**
	 * 系统企业名称(监管系统)
	 */
	@ApiModelProperty(value="系统企业名称(监管系统)")
	private String nameSupervise;
	
	/**
	 * 系统企业简称(监管系统)
	 */
	@ApiModelProperty(value="系统企业简称(监管系统)")
	private String shortNameSupervise;
	
	/**
	 * 企业所在的行政区域(平台)
	 */
	@ApiModelProperty(value="企业所在的行政区域(平台)")
	private Long areaIdPlatForm;
	
	/**
	 * 企业所在的行政区域（监管系统)
	 */
//	private Long areaIdSupervise;
	
	/**
	 * 监管部门ID(监管系统)
	 */
	@ApiModelProperty(value="监管部门ID(监管系统)")
	private Long organId;
	
	/**
	 * 监管部门名称(监管系统)
	 */
//	private String organName;
	
	/**
	 * 是否同意加入监管范围：true，同意；false：不同意
	 */
	@ApiModelProperty(value="是否同意加入监管范围")
	private Boolean result = false;
}
