/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.service;

import cn.smarthse.modules.platform.core.framework.Global;
import cn.smarthse.modules.platform.core.framework.mybatis.CommonMapper;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

public class CommonServiceImpl<D extends CommonMapper<T>, T>
implements IBaseService<T> {
    protected Logger logger = LogManager.getLogger(this.getClass());
    @Autowired(required=false)
    protected D dao;

    @Override
    public T getById(Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        return (T)this.dao.selectByPrimaryKey((Object)id);
    }

    @Override
    public T getById(Integer id) {
        if (id == null || id == 0) {
            return null;
        }
        return (T)this.dao.selectByPrimaryKey((Object)id);
    }

    @Override
    public T getById(Long id, Long createBy) {
        T entity = this.getById(id);
        if (entity != null) {
            Class<?> cls = entity.getClass();
            try {
                Method getCreateBy = cls.getDeclaredMethod("getCreateBy", new Class[0]);
                Object thisCreateBy = getCreateBy.invoke(entity, new Object[0]);
                if (thisCreateBy != null && thisCreateBy instanceof Long && thisCreateBy == createBy) {
                    return entity;
                }
            }
            catch (NoSuchMethodException e) {
                this.logger.info("No Such Method getCreateBy");
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public List<T> getListByExample(Example example) {
        return this.dao.selectByExample((Object)example);
    }

    public int getCountByExample(Example example) {
        return this.dao.selectCountByExample((Object)example);
    }

    private void setUpdateInfo(T entity, Long updateBy) {
        this.setUpdateDate(entity);
        this.setUpdateBy(entity, updateBy);
    }

    private void setUpdateInfo(T entity, Integer updateBy) {
        this.setUpdateDate(entity);
        this.setUpdateBy(entity, updateBy);
    }

    private void setIsValid(T entity, boolean bln) {
        Class<?> cls = entity.getClass();
        try {
            Method setIsValid = cls.getDeclaredMethod("setIsValid", Boolean.class);
            if (setIsValid != null) {
                setIsValid.invoke(entity, bln);
            }
        }
        catch (NoSuchMethodException e) {
            this.logger.info("No Such Method setIsValid");
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void setCreateDate(T entity) {
        Class<?> cls = entity.getClass();
        try {
            Method setCreateDate = cls.getDeclaredMethod("setCreateDate", Date.class);
            if (setCreateDate != null) {
                setCreateDate.invoke(entity, new Date());
            }
        }
        catch (Exception e) {
            this.logger.info("No Such Method setCreateDate");
        }
        try {
            Method setCreateTime = cls.getDeclaredMethod("setCreateTime", Date.class);
            if (setCreateTime != null) {
                setCreateTime.invoke(entity, new Date());
            }
        }
        catch (Exception e) {
            this.logger.info("No Such Method setCreateTime");
        }
    }

    private void setCreateBy(T entity, Object createBy) {
        Method setCreateBy;
        Class<?> cls = entity.getClass();
        try {
            setCreateBy = cls.getDeclaredMethod("setCreateBy", Long.class);
            if (setCreateBy != null) {
                setCreateBy.invoke(entity, createBy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            setCreateBy = cls.getDeclaredMethod("setCreateBy", Integer.class);
            if (setCreateBy != null) {
                setCreateBy.invoke(entity, createBy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setUpdateDate(T entity) {
        Class<?> cls = entity.getClass();
        try {
            Method setCreateDate = cls.getDeclaredMethod("setUpdateDate", Date.class);
            if (setCreateDate != null) {
                setCreateDate.invoke(entity, new Date());
            }
        }
        catch (Exception e) {
            this.logger.info("No Such Method setUpdateDate");
        }
        try {
            Method setCreateTime = cls.getDeclaredMethod("setUpdateTime", Date.class);
            if (setCreateTime != null) {
                setCreateTime.invoke(entity, new Date());
            }
        }
        catch (Exception e) {
            this.logger.info("No Such Method setUpdateTime");
        }
    }

    private void setUpdateBy(T entity, Object createBy) {
        Method setCreateBy;
        Class<?> cls = entity.getClass();
        try {
            setCreateBy = cls.getDeclaredMethod("setUpdateBy", Long.class);
            if (setCreateBy != null) {
                setCreateBy.invoke(entity, createBy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            setCreateBy = cls.getDeclaredMethod("setUpdateBy", Integer.class);
            if (setCreateBy != null) {
                setCreateBy.invoke(entity, createBy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setCreateInfo(T entity, Long createBy) {
        this.setCreateDate(entity);
        this.setIsValid(entity, Global.TRUE);
        this.setCreateBy(entity, createBy);
    }

    private void setCreateInfo(T entity, Integer createBy) {
        this.setCreateDate(entity);
        this.setIsValid(entity, Global.TRUE);
        this.setCreateBy(entity, createBy);
    }

    @Override
    @Transactional(readOnly=false)
    public T add(T entity) {
        this.dao.insertSelective(entity);
        return entity;
    }

    @Override
    @Transactional(readOnly=false)
    public T add(T entity, Long createBy) {
        this.setCreateInfo(entity, createBy);
        this.setUpdateInfo(entity, createBy);
        this.dao.insertSelective(entity);
        return entity;
    }

    @Override
    @Transactional(readOnly=false)
    public T add(T entity, Integer createBy) {
        this.setCreateInfo(entity, createBy);
        this.setUpdateInfo(entity, createBy);
        this.dao.insertSelective(entity);
        return entity;
    }

    @Override
    @Transactional(readOnly=false)
    public Integer update(T entity) {
        int updateCount = this.dao.updateByPrimaryKeySelective(entity);
        return updateCount;
    }

    @Override
    @Transactional(readOnly=false)
    public Integer update(T entity, Long updateBy) {
        this.setUpdateInfo(entity, updateBy);
        Integer updateCount = this.dao.updateByPrimaryKeySelective(entity);
        return updateCount;
    }

    @Override
    @Transactional(readOnly=false)
    public Integer update(T entity, Integer updateBy) {
        this.setUpdateInfo(entity, updateBy);
        Integer updateCount = this.dao.updateByPrimaryKeySelective(entity);
        return updateCount;
    }

    @Override
    @Transactional(readOnly=false)
    public Integer updateByPrimaryKey(T entity, Long updateBy) {
        this.setUpdateInfo(entity, updateBy);
        Integer updateCount = this.dao.updateByPrimaryKey(entity);
        return updateCount;
    }

    @Override
    @Transactional(readOnly=false)
    public Integer updateByPrimaryKey(T entity, Integer updateBy) {
        this.setUpdateInfo(entity, updateBy);
        Integer updateCount = this.dao.updateByPrimaryKey(entity);
        return updateCount;
    }

    @Override
    @Transactional(readOnly=false)
    public Integer delete(T entity, Long deleteBy) {
        this.setUpdateInfo(entity, deleteBy);
        this.setIsValid(entity, Global.FALSE);
        int updateCount = this.dao.updateByPrimaryKeySelective(entity);
        return updateCount;
    }

    @Override
    @Transactional(readOnly=false)
    public Integer deleteById(Long id, Long updateBy) {
        T entity = this.getById(id);
        if (entity != null) {
            return this.delete(entity, updateBy);
        }
        return 0;
    }

    @Override
    public List<T> getListByIds(String ids) {
        return this.dao.selectByIds(ids);
    }

    protected T getOneByExample(Example example) {
        List list = this.dao.selectByExampleAndRowBounds((Object)example, new RowBounds(0, 1));
        if (list.size() > 0) {
            return (T)list.get(0);
        }
        return null;
    }
}

