/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.cache.memcached;

import cn.smarthse.modules.platform.core.framework.utils.SpringContextHolder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XMemcachedUtil {
    private static Logger logger = LogManager.getLogger(XMemcachedUtil.class);
    private static MemcachedClient memcachedClient = SpringContextHolder.getBean(MemcachedClient.class);

    public static boolean add(String key, int exp, Object value) {
        block5: {
            try {
                if (logger.isInfoEnabled()) {
                    return memcachedClient.add(key, exp, value);
                }
            }
            catch (TimeoutException e1) {
                if (logger.isErrorEnabled()) {
                    logger.error("\u66f4\u65b0 Memcached \u7f13\u5b58\u8d85\u65f6", (Throwable)e1);
                }
            }
            catch (InterruptedException | MemcachedException e2) {
                if (!logger.isErrorEnabled()) break block5;
                logger.error("\u66f4\u65b0 Memcached \u7f13\u5b58\u88ab\u4e2d\u65ad", e2);
            }
        }
        return false;
    }

    public static boolean replace(String key, int exp, Object value) {
        block5: {
            try {
                if (logger.isInfoEnabled()) {
                    return memcachedClient.replace(key, exp, value);
                }
            }
            catch (TimeoutException e1) {
                if (logger.isErrorEnabled()) {
                    logger.error("\u66ff\u6362 Memcached \u7f13\u5b58\u8d85\u65f6", (Throwable)e1);
                }
            }
            catch (InterruptedException | MemcachedException e2) {
                if (!logger.isErrorEnabled()) break block5;
                logger.error("\u66ff\u6362 Memcached \u7f13\u5b58\u88ab\u4e2d\u65ad", e2);
            }
        }
        return false;
    }

    public static boolean put(String key, int exp, Object value) {
        block5: {
            try {
                if (logger.isInfoEnabled()) {
                    return memcachedClient.set(key, exp, value);
                }
            }
            catch (TimeoutException e1) {
                if (logger.isErrorEnabled()) {
                    logger.error("\u66ff\u6362 Memcached \u7f13\u5b58\u8d85\u65f6", (Throwable)e1);
                }
            }
            catch (InterruptedException | MemcachedException e2) {
                if (!logger.isErrorEnabled()) break block5;
                logger.error("\u66ff\u6362 Memcached \u7f13\u5b58\u88ab\u4e2d\u65ad", e2);
            }
        }
        return false;
    }

    public static boolean delete(String key) {
        block5: {
            try {
                if (logger.isInfoEnabled()) {
                    return memcachedClient.delete(key);
                }
            }
            catch (TimeoutException e1) {
                if (logger.isErrorEnabled()) {
                    logger.error("\u5220\u9664 Memcached \u7f13\u5b58\u8d85\u65f6", (Throwable)e1);
                }
            }
            catch (InterruptedException | MemcachedException e2) {
                if (!logger.isErrorEnabled()) break block5;
                logger.error("\u5220\u9664 Memcached \u7f13\u5b58\u88ab\u4e2d\u65ad", e2);
            }
        }
        return false;
    }

    public static Object get(String key) {
        block5: {
            try {
                if (logger.isInfoEnabled()) {
                    return memcachedClient.get(key);
                }
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                if (logger.isErrorEnabled()) {
                    logger.error("\u83b7\u53d6\u6570\u636e Memcached \u7f13\u5b58\u8d85\u65f6", (Throwable)e);
                }
            }
            catch (InterruptedException | MemcachedException e2) {
                e2.printStackTrace();
                if (!logger.isErrorEnabled()) break block5;
                logger.error("\u83b7\u53d6\u6570\u636e Memcached \u7f13\u5b58\u88ab\u4e2d\u65ad", e2);
            }
        }
        return null;
    }

    public static Object pop(String key) {
        block6: {
            try {
                Object obj;
                if (logger.isInfoEnabled()) {
                    logger.info("pop\u7f13\u5b58:{}", (Object)key);
                }
                if ((obj = memcachedClient.get(key)) != null) {
                    memcachedClient.delete(key);
                }
                return obj;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                if (logger.isErrorEnabled()) {
                    logger.error("\u83b7\u53d6\u6570\u636e Memcached \u7f13\u5b58\u8d85\u65f6", (Throwable)e);
                }
            }
            catch (InterruptedException | MemcachedException e2) {
                e2.printStackTrace();
                if (!logger.isErrorEnabled()) break block6;
                logger.error("\u83b7\u53d6\u6570\u636e Memcached \u7f13\u5b58\u88ab\u4e2d\u65ad", e2);
            }
        }
        return null;
    }

    public static Map<String, Object> getMulit(List<String> keys) {
        block5: {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("\u8bfb\u53d6\u591a\u4e2a\u7f13\u5b58:{}", keys);
                }
                return memcachedClient.get(keys);
            }
            catch (TimeoutException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("\u83b7\u53d6\u6570\u636e Memcached \u7f13\u5b58\u8d85\u65f6", (Throwable)e);
                }
            }
            catch (InterruptedException | MemcachedException e2) {
                if (!logger.isErrorEnabled()) break block5;
                logger.error("\u83b7\u53d6\u6570\u636e Memcached \u7f13\u5b58\u88ab\u4e2d\u65ad", e2);
            }
        }
        return null;
    }

    public static void clearAll() {
        block3: {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("\u6e05\u9664\u6240\u6709\u7f13\u5b58");
                }
                memcachedClient.flushAll();
            }
            catch (InterruptedException | TimeoutException | MemcachedException e) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error("\u6e05\u9664 Memcached \u7f13\u5b58\u5f02\u5e38", e);
            }
        }
    }

    public static long incr(String key, long delta, long initValue) {
        block5: {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("\u8bfb\u53d6\u539f\u5b50\u9012\u589e\u7f13\u5b58:{}", (Object)key);
                }
                return memcachedClient.incr(key, delta, initValue);
            }
            catch (TimeoutException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("\u83b7\u53d6\u539f\u5b50\u9012\u589e \u7f13\u5b58\u8d85\u65f6", (Throwable)e);
                }
            }
            catch (InterruptedException | MemcachedException e2) {
                if (!logger.isErrorEnabled()) break block5;
                logger.error("\u83b7\u53d6\u539f\u5b50\u9012\u589e\u7f13\u5b58\u88ab\u4e2d\u65ad", e2);
            }
        }
        return initValue;
    }

    public static long decr(String key, long delta, long initValue) {
        block5: {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("\u8bfb\u53d6\u539f\u5b50\u9012\u51cf\u7f13\u5b58:{}", (Object)key);
                }
                return memcachedClient.decr(key, delta, initValue);
            }
            catch (TimeoutException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("\u83b7\u53d6\u539f\u5b50\u9012\u51cf \u7f13\u5b58\u8d85\u65f6", (Throwable)e);
                }
            }
            catch (InterruptedException | MemcachedException e2) {
                if (!logger.isErrorEnabled()) break block5;
                logger.error("\u83b7\u53d6\u539f\u5b50\u9012\u51cf\u7f13\u5b58\u88ab\u4e2d\u65ad", e2);
            }
        }
        return initValue;
    }
}

