/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HtmlUtil {
    private static Logger logger = LogManager.getLogger();

    public static String xssEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        block11: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    sb.append('\uff1e');
                    continue block11;
                }
                case '<': {
                    sb.append('\uff1c');
                    continue block11;
                }
                case '\'': {
                    sb.append('\u2018');
                    continue block11;
                }
                case '\"': {
                    sb.append('\u201c');
                    continue block11;
                }
                case '&': {
                    sb.append('\uff06');
                    continue block11;
                }
                case '\\': {
                    sb.append('\uff3c');
                    continue block11;
                }
                case '#': {
                    sb.append('\uff03');
                    continue block11;
                }
                case '(': {
                    sb.append('\uff08');
                    continue block11;
                }
                case ')': {
                    sb.append('\uff09');
                    continue block11;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean checkSQLInject(String str) {
        String[] inj_stra = new String[]{"script", "mid", "master", "truncate", "insert", "select", "delete", "update", "declare", "iframe", "'", "onreadystatechange", "alert", "atestu", "xss", ";", "'", "\"", "<", ">", "(", ")", "\\", "svg", "confirm", "prompt", "onload", "onmouseover", "onfocus", "onerror"};
        str = str.toLowerCase();
        for (int i = 0; i < inj_stra.length; ++i) {
            if (str.indexOf(inj_stra[i]) < 0) continue;
            logger.info("\u4f20\u5165str=" + str + ",\u5305\u542b\u7279\u6b8a\u5b57\u7b26\uff1a" + inj_stra[i]);
            return true;
        }
        return false;
    }

    public static List<String> getHtmlImages(String html) {
        String img = "";
        ArrayList<String> pics = new ArrayList<String>();
        String regEx_img = "<img.*src=(.*?)[^>]*?>";
        Pattern p_image = Pattern.compile(regEx_img, 2);
        Matcher m_image = p_image.matcher(html);
        while (m_image.find()) {
            img = img + "," + m_image.group();
            Matcher m = Pattern.compile("src=\"?(.*?)(\"|>|\\s+)").matcher(img);
            while (m.find()) {
                String url = m.group(1);
                url = url.replace("'", "");
                pics.add(url);
            }
        }
        return pics;
    }

    public static String getTextLen(String text, int len) {
        if (text == null || "".equals(text)) {
            return "";
        }
        text = text.replaceAll("\\&[a-zA-Z]{1,10};", "").replaceAll("<[^>]*>", "");
        if ((text = text.replaceAll("[(/>)<]", "")).length() >= len) {
            return text.substring(0, len - 1) + "...";
        }
        return text;
    }

    public static String delHTMLTag(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        htmlStr = htmlStr.replaceAll("\\r\\n", "");
        htmlStr = htmlStr.replaceAll(" ", "");
        return htmlStr.trim();
    }

    public static void main(String[] args) {
        String html = "<p>\r\n \t<span style=\"line-height:2;font-family:Microsoft YaHei;font-size:16px;\">\u968f\u7740\u793e\u4f1a\u8f6c\u578b\u7684\u52a0\u5feb\u3001\u5404\u79cd\u77db\u76fe\u7684\u51f8\u663e\uff0c\u5065\u5eb7\u95ee\u9898\u65e5\u6e10\u7a81\u51fa\uff0c\u201c\u9ad8\u5b66\u5386\u4eba\u7fa4\u3001\u9ad8\u538b\u529b\u4eba\u7fa4\u3001\u9ad8\u8981\u6c42\u4eba\u7fa4\u201d\u7684\u65b0\u201c\u4e09\u9ad8\u4eba\u7fa4\u201d\u4e9a\u5065\u5eb7\u72b6\u51b5\u4e25\u91cd\u3002\u90a3\u4e48\uff0c\u5230\u5e95\u5982\u4f55\u624d\u80fd\u6446\u8131\u4e9a\u5065\u5eb7\u5462\uff1f\u4eca\u5929\u5c0f\u7f16\u5c06\u4e3a\u4f60\u4ecb\u7ecd\u6446\u8131\u4e9a\u5065\u5eb7\u7684\u51e0\u4e2a\u5c0f\u8d34\u58eb\u3002</span> \r\n </p>\r\n <p>\r\n \t<br />\r\n </p>\r\n <p>\r\n \t<span style=\"color:#006600;line-height:2;font-family:Microsoft YaHei;font-size:16px;\">\u5229\u7528\u7410\u788e\u65f6\u95f4\u6253\u76f9</span> \r\n </p>\r\n <p>\r\n \t<span style=\"line-height:2;font-family:Microsoft YaHei;font-size:16px;\">\u5348\u4f11\u671f\u95f4\u7761\u4e00\u89c9\uff0c\u80fd\u591f\u4fdd\u8bc1\u6574\u4e2a\u4e0b\u5348\u7cbe\u795e\u6ee1\u6ee1\uff0c\u4e0b\u73ed\u5730\u94c1\u4e0a\u6253\u4e2a\u76f9\uff0c\u665a\u4e0a\u82e5\u7ee7\u7eed\u5de5\u4f5c\u4fbf\u4f1a\u5f88\u6709\u6548\u7387\u3002</span> \r\n </p>\r\n <p>\r\n \t<br />\r\n </p>\r\n <p>\r\n \t<span style=\"color:#006600;line-height:2;font-family:Microsoft YaHei;font-size:16px;\">\u529e\u516c\u5ba4\u517b\u76c6\u82b1\u8349</span> \r\n </p>\r\n <p>\r\n \t<span style=\"line-height:2;font-family:Microsoft YaHei;font-size:16px;\">\u7531\u4e8e\u5f53\u4eca\u7684\u767d\u9886\u5f80\u5f80\u5728\u9cde\u6b21\u6809\u6bd4\u7684\u9ad8\u697c\u5185\u5de5\u4f5c\uff0c\u4e0d\u80fd\u5b9a\u65f6\u5f00\u7a97\u901a\u98ce\uff0c\u697c\u5185\u7684\u7a7a\u6c14\u5faa\u73af\u5927\u90fd\u9760\u901a\u98ce\u8bbe\u5907\uff0c\u800c\u8fd9\u4e9b\u8bbe\u5907\u56e0\u4e3a\u4e0d\u80fd\u5b9a\u65f6\u6e05\u7406\uff0c\u901a\u5e38\u4f34\u6709\u4e0d\u5c11\u547c\u5438\u9053\u7684\u7ec6\u83cc\u3002\u82b1\u8349\u7684\u79cd\u690d\u53ef\u4ee5\u5e2e\u52a9\u6539\u5584\u7a7a\u6c14\u8d28\u91cf\uff0c\u5728\u517b\u62a4\u7684\u540c\u65f6\u4e5f\u80fd\u653e\u677e\u8eab\u5fc3\u3002</span><img alt=\"\" src=\"http://192.168.1.188:8011/upload/image/20180815/20180815110012_266.jpg\" /> \r\n </p>\r\n <p>\r\n \t<br />\r\n </p>\r\n <p>\r\n \t<span style=\"color:#006600;line-height:2;font-family:Microsoft YaHei;font-size:16px;\">\u6bcf\u5929\u7684\u751f\u6d3b\u4f5c\u606f\u6709\u89c4\u5f8b</span> \r\n </p>\r\n <p>\r\n \t<span style=\"line-height:2;font-family:Microsoft YaHei;font-size:16px;\">\u4fdd\u8bc1\u5145\u8db3\u7684\u7761\u7720\u65f6\u95f4\uff0c\u4e00\u65e5\u4e09\u9910\u5fc5\u9700\u5b9a\u65f6\u5b9a\u91cf\u3002\u7279\u522b\u662f\u4e00\u4e9b\u5973\u6027\u767d\u9886\u4e3a\u4e86\u4fdd\u6301\u8eab\u6750\u82d7\u6761\uff0c\u5f80\u5f80\u201c\u5077\u5de5\u51cf\u6599\u201d\uff0c\u9965\u4e00\u987f\u9971\u4e00\u987f\uff0c\u6b8a\u4e0d\u77e5\u8102\u80aa\u7684\u51cf\u5c11\u4f1a\u5f71\u54cd\u514d\u75ab\u529b\uff0c\u6b64\u4e43\u517b\u751f\u5927\u5fcc\u3002\u53e6\u5916\uff0c\u4e0d\u6309\u65f6\u7761\u7720\uff0c\u6709\u53ef\u80fd\u4f1a\u9020\u6210\u7761\u7720\u7d0a\u4e71\uff0c\u800c\u5931\u7720\u4f1a\u4f7f\u4eba\u4f53\u514d\u75ab\u529b\u964d\u4f4e\uff0c\u5bb9\u6613\u611f\u67d3\u75be\u75c5\uff0c\u90a3\u4e9b\u7761\u7720\u4e0d\u8db3\u7684\u4eba\u901a\u5e38\u5c31\u662f\u6d41\u884c\u75c5\u4f20\u67d3\u75c5\u7684\u53d7\u5bb3\u8005\u3002</span> \r\n </p>\r\n <p>\r\n \t<br />\r\n </p>\r\n <p>\r\n \t<span style=\"color:#006600;line-height:2;font-family:Microsoft YaHei;font-size:16px;\">\u63d0\u524d\u4e00\u7ad9\u4e0b\u8f66</span> \r\n </p>\r\n <p>\r\n \t<span style=\"line-height:2;font-family:Microsoft YaHei;font-size:16px;\">\u4e0d\u8981\u5fd8\u8bb0\u7c7b\u4f3c\u6563\u6b65\u4e00\u7c7b\u7684\u867d\u7136\u7b80\u5355\uff0c\u4f46\u5374\u5341\u5206\u6709\u5229\u4e8e\u8eab\u5fc3\u7684\u6d3b\u52a8\u3002\u5018\u82e5\u4e0a\u73ed\u6216\u662f\u51fa\u95e8\u529e\u4e8b\u9700\u8981\u4e58\u5730\u94c1\u6216\u662f\u642d\u516c\u5171\u6c7d\u8f66\uff0c\u6700\u597d\u63d0\u524d\u4e00\u7ad9\u4e0b\u8f66\uff0c\u6b65\u884c\u5230\u8fbe\u76ee\u7684\u5730\u3002</span> \r\n </p>\r\n <p>\r\n \t<br />\r\n </p>\r\n <p>\r\n \t<span style=\"color:#006600;line-height:2;font-family:Microsoft YaHei;font-size:16px;\">\u5e38\u5e38\u542c\u8f7b\u677e\u6109\u5feb\u7684\u97f3\u4e50</span> \r\n </p>\r\n <p>\r\n \t<span style=\"line-height:2;font-family:Microsoft YaHei;font-size:16px;\">\u8282\u594f\u6b22\u5feb\u7684\u97f3\u4e50\u5f88\u5bb9\u6613\u4f7f\u4eba\u5fc3\u60c5\u653e\u677e\uff0c\u73b0\u4ee3\u533b\u5b66\u5df2\u628a\u97f3\u4e50\u7597\u6cd5\u4f5c\u4e3a\u6cbb\u7597\u5fc3\u7406\u75be\u75c5\u7684\u5e38\u89c1\u624b\u6bb5\u4e4b\u4e00</span><img alt=\"\" src=\"http://192.168.1.188:8011/upload/image/20180815/20180815110026_94.jpg\" /> \r\n </p>\r\n <p>\r\n \t<br />\r\n </p>\r\n <p>\r\n \t<span style=\"line-height:2;font-family:Microsoft YaHei;font-size:16px;background-color:#99BB00;\">\u5c0f\u8d34\u58eb\uff1a</span> \r\n </p>\r\n <p>\r\n \t<span style=\"color:#666666;line-height:2;font-family:Microsoft YaHei;font-size:16px;\">\u4ee5\u4e0b\u662f\u4e16\u754c\u7740\u540d\u5fc3\u7406\u4e13\u5bb6\u6ce2\u5fb7\u65af\u57fa\u4e3a\u4e0d\u540c\u75c7\u72b6\u7684\u75c5\u4eba\uff0c\u5f00\u51fa\u7684\u4e0d\u540c\u836f\u65b9\uff1a\u8096\u90a6\u300a\u591c\u66f2\u300b\uff1a\u6cbb\u7597\u795e\u7ecf\u8870\u5f31\u75c7\uff1b\u83ab\u624e\u7279\u300a\u5267\u573a\u7684\u7ba1\u7406\u4eba\u300b\uff1a\u6cbb\u7597\u7cbe\u795e\u5fe7\u90c1\u75c7\uff1b\u8d1d\u591a\u82ac\u300a\u7b2c\u516b\u53f7\u94a2\u7434\u594f\u9e23\u66f2\u300b\uff1a\u6cbb\u7597\u9ad8\u8840\u538b\uff1b\u5df4\u54c8\u300aD\u5c0f\u8c03\u5c0f\u63d0\u7434\u534f\u594f\u66f2\u300b\uff1a\u6cbb\u7597\u80c3\u80a0\u5931\u8c03\u3002</span> \r\n </p>";
        System.out.println(HtmlUtil.delHTMLTag(html));
    }
}

